/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.builder.JsonReader;
import io.quarkus.builder.json.JsonArray;
import io.quarkus.builder.json.JsonObject;
import io.quarkus.builder.json.JsonString;
import io.quarkus.builder.json.JsonValue;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.NativeImageBuildContainerRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;

public class NativeImageBuildRemoteContainerRunner
extends NativeImageBuildContainerRunner {
    private static final Logger log = Logger.getLogger(NativeImageBuildRemoteContainerRunner.class);
    private static final String CONTAINER_BUILD_VOLUME_NAME = "quarkus-native-builder-image-project-volume";
    private String containerId;

    protected NativeImageBuildRemoteContainerRunner(NativeConfig nativeConfig) {
        super(nativeConfig);
    }

    @Override
    protected void preBuild(Path outputDir, List<String> buildArgs) throws InterruptedException, IOException {
        this.rmVolume(null);
        List<String> containerRuntimeArgs = Arrays.asList("-v", "quarkus-native-builder-image-project-volume:/project");
        String[] createTempContainerCommand = this.buildCommand("create", containerRuntimeArgs, Collections.emptyList());
        try {
            this.containerId = this.runCommandAndReadOutput(createTempContainerCommand).get(0);
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            throw new RuntimeException("Failed to create temp container.", e);
        }
        String[] copyCommand = new String[]{this.containerRuntime.getExecutableName(), "cp", String.valueOf(outputDir.toAbsolutePath()) + "/.", this.containerId + ":/project"};
        NativeImageBuildRemoteContainerRunner.runCommand(copyCommand, "Failed to copy source-jar and libs from host to builder container");
        super.preBuild(outputDir, buildArgs);
    }

    private List<String> runCommandAndReadOutput(String[] command) throws IOException, InterruptedException {
        log.info((Object)String.join((CharSequence)" ", command).replace("$", "\\$"));
        Process process = new ProcessBuilder(command).start();
        if (process.waitFor() != 0) {
            throw new RuntimeException("Command failed: " + String.join((CharSequence)" ", command));
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            List<String> list = reader.lines().toList();
            return list;
        }
    }

    @Override
    protected void postBuild(Path outputDir, String nativeImageName, String resultingExecutableName) {
        this.copyFromContainerVolume(outputDir, resultingExecutableName, "Failed to copy native image from container volume back to the host.");
        this.copyFromContainerVolume(outputDir, "build-artifacts.json", null);
        try {
            String buildArtifactsJson;
            JsonObject jsonRead;
            JsonValue jdkLibraries;
            Path buildArtifactsFile = outputDir.resolve("build-artifacts.json");
            if (Files.exists(buildArtifactsFile, new LinkOption[0]) && (jdkLibraries = (jsonRead = (JsonObject)JsonReader.of((String)(buildArtifactsJson = Files.readString(buildArtifactsFile))).read()).get("jdk_libraries")) instanceof JsonArray) {
                for (JsonValue lib : ((JsonArray)jdkLibraries).value()) {
                    this.copyFromContainerVolume(outputDir, ((JsonString)lib).value(), "Failed to copy " + String.valueOf(lib) + " from container volume back to the host.");
                }
            }
        }
        catch (IOException e) {
            log.errorf((Throwable)e, "Failed to list .so files in the build-artifacts.json. Skipping the step.", new Object[0]);
        }
        if (this.nativeConfig.debug().enabled()) {
            this.copyFromContainerVolume(outputDir, "sources", "Failed to copy sources from container volume back to the host.");
            String symbols = String.format("%s.debug", nativeImageName);
            this.copyFromContainerVolume(outputDir, symbols, "Failed to copy debug symbols from container volume back to the host.");
        }
        String[] rmTempContainerCommand = new String[]{this.containerRuntime.getExecutableName(), "container", "rm", this.containerId};
        NativeImageBuildRemoteContainerRunner.runCommand(rmTempContainerCommand, "Failed to remove container: " + this.containerId);
        this.rmVolume("Failed to remove volume: quarkus-native-builder-image-project-volume");
    }

    private void rmVolume(String errorMsg) {
        String[] rmVolumeCommand = new String[]{this.containerRuntime.getExecutableName(), "volume", "rm", CONTAINER_BUILD_VOLUME_NAME};
        NativeImageBuildRemoteContainerRunner.runCommand(rmVolumeCommand, errorMsg);
    }

    private void copyFromContainerVolume(Path outputDir, String path, String errorMsg) {
        String[] copyCommand = new String[]{this.containerRuntime.getExecutableName(), "cp", this.containerId + ":/project/" + path, outputDir.toAbsolutePath().toString()};
        NativeImageBuildRemoteContainerRunner.runCommand(copyCommand, errorMsg);
    }

    @Override
    protected List<String> getContainerRuntimeBuildArgs(Path outputDir) {
        List<String> containerRuntimeArgs = super.getContainerRuntimeBuildArgs(outputDir);
        Collections.addAll(containerRuntimeArgs, "-v", "quarkus-native-builder-image-project-volume:/project");
        return containerRuntimeArgs;
    }
}

