/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.model.PathsCollection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.jboss.jandex.IndexView;

public interface ApplicationArchive {
    public IndexView getIndex();

    @Deprecated
    public Path getArchiveRoot();

    @Deprecated
    public boolean isJarArchive();

    @Deprecated
    public Path getArchiveLocation();

    public PathsCollection getRootDirs();

    public PathsCollection getPaths();

    default public Path getChildPath(String path) {
        return this.getRootDirs().resolveExistingOrNull(path);
    }

    default public void processEntry(String path, BiConsumer<Path, Path> consumer) {
        Iterator dirs = this.getRootDirs().iterator();
        Iterator paths = this.getPaths().iterator();
        while (dirs.hasNext()) {
            Path child = ((Path)dirs.next()).resolve(path);
            if (Files.exists(child, new LinkOption[0])) {
                consumer.accept(child, (Path)paths.next());
                return;
            }
            paths.next();
        }
    }
}

