/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner.bootstrap;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildExecutionBuilder;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.runner.bootstrap.AugmentActionImpl;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class GenerateConfigTask
implements BiConsumer<CuratedApplication, Map<String, Object>> {
    private static final Logger log = Logger.getLogger(GenerateConfigTask.class);
    public static final String CONFIG_FILE = "config-file";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(CuratedApplication application, Map<String, Object> stringObjectMap) {
        Path configFile = (Path)stringObjectMap.get(CONFIG_FILE);
        try {
            final Path temp = Files.createTempDirectory("empty", new FileAttribute[0]);
            try {
                OpenOption[] openOptionArray;
                AugmentActionImpl augmentAction = new AugmentActionImpl(application, Collections.emptyList());
                BuildResult buildResult = augmentAction.runCustomAction(new Consumer<BuildChainBuilder>(){

                    @Override
                    public void accept(BuildChainBuilder chainBuilder) {
                        chainBuilder.addFinal(ConfigDescriptionBuildItem.class);
                        chainBuilder.addInitial(ArchiveRootBuildItem.class);
                    }
                }, new Consumer<BuildExecutionBuilder>(){

                    @Override
                    public void accept(BuildExecutionBuilder buildExecutionBuilder) {
                        buildExecutionBuilder.produce((BuildItem)new ArchiveRootBuildItem(temp));
                    }
                });
                List descriptions = buildResult.consumeMulti(ConfigDescriptionBuildItem.class);
                Collections.sort(descriptions);
                String existing = "";
                if (Files.exists(configFile, new LinkOption[0])) {
                    existing = new String(Files.readAllBytes(configFile), StandardCharsets.UTF_8);
                }
                StringBuilder sb = new StringBuilder();
                for (ConfigDescriptionBuildItem i : descriptions) {
                    if (existing.contains("\n" + i.getPropertyName() + "=") || existing.contains("\n#" + i.getPropertyName() + "=")) continue;
                    sb.append("\n#\n");
                    sb.append(this.formatDocs(i.getDocs()));
                    sb.append("\n#\n#");
                    sb.append(i.getPropertyName()).append("=");
                    if (i.getDefaultValue() != null) {
                        sb.append(i.getDefaultValue());
                    }
                    sb.append("\n");
                }
                Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
                byte[] byArray = sb.toString().getBytes(StandardCharsets.UTF_8);
                if (Files.exists(configFile, new LinkOption[0])) {
                    OpenOption[] openOptionArray2 = new OpenOption[1];
                    openOptionArray = openOptionArray2;
                    openOptionArray2[0] = StandardOpenOption.APPEND;
                } else {
                    openOptionArray = new OpenOption[]{};
                }
                Files.write(configFile, byArray, openOptionArray);
            }
            finally {
                Files.deleteIfExists(temp);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate config file", e);
        }
    }

    private String formatDocs(String docs) {
        if (docs == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean lastEmpty = false;
        boolean first = true;
        for (String line : docs.replace("<p>", "\n").split("\n")) {
            String trimmed = line.trim();
            if (trimmed.isEmpty()) {
                if (lastEmpty || first) continue;
                lastEmpty = true;
                builder.append("\n#");
                continue;
            }
            lastEmpty = false;
            if (first) {
                first = false;
            } else {
                builder.append("\n");
            }
            builder.append("# " + trimmed.replace("\n", "\n#").replace("<ul>", "").replace("</ul>", "").replace("<li>", " - ").replace("</li>", ""));
        }
        String ret = builder.toString();
        ret = Pattern.compile("\\{@code (.*?)\\}").matcher(ret).replaceAll("'$1'");
        Matcher matcher = Pattern.compile("\\{@link #(.*?)\\}").matcher(ret);
        while (matcher.find()) {
            ret = ret.replace(matcher.group(0), "'" + this.configify(matcher.group(1)) + "'");
        }
        return ret;
    }

    private String configify(String group) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < group.length(); ++i) {
            char c = group.charAt(i);
            if (Character.isUpperCase(c)) {
                ret.append("-");
                ret.append(Character.toLowerCase(c));
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }
}

