/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.UnresolvedTypeVariable;
import org.jboss.jandex.VoidType;
import org.jboss.logging.Logger;

public class ReflectiveHierarchyStep {
    private static final Logger log = Logger.getLogger(ReflectiveHierarchyStep.class);
    private static final Set<String> IGNORED_PARAMETERIZED_TYPE_PACKAGE_NAMES = new HashSet<String>(Arrays.asList("java.util", "io.reactivex"));
    @Inject
    List<ReflectiveHierarchyBuildItem> hierarchy;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    @Inject
    List<ReflectiveHierarchyIgnoreWarningBuildItem> ignored;

    @BuildStep
    public void build() throws Exception {
        HashSet<DotName> processedReflectiveHierarchies = new HashSet<DotName>();
        TreeSet<DotName> unindexedClasses = new TreeSet<DotName>();
        for (ReflectiveHierarchyBuildItem reflectiveHierarchyBuildItem : this.hierarchy) {
            this.addReflectiveHierarchy(reflectiveHierarchyBuildItem, reflectiveHierarchyBuildItem.getType(), processedReflectiveHierarchies, unindexedClasses);
        }
        for (ReflectiveHierarchyIgnoreWarningBuildItem reflectiveHierarchyIgnoreWarningBuildItem : this.ignored) {
            unindexedClasses.remove(reflectiveHierarchyIgnoreWarningBuildItem.getDotName());
        }
        if (!unindexedClasses.isEmpty()) {
            String unindexedClassesWarn = unindexedClasses.stream().map(d -> "\t- " + d).collect(Collectors.joining("\n"));
            log.warnf("Unable to properly register the hierarchy of the following classes for reflection as they are not in the Jandex index:%n%s%nConsider adding them to the index either by creating a Jandex index for your dependency via the Maven plugin, an empty META-INF/beans.xml or quarkus.index-dependency properties.\");.", (Object)unindexedClassesWarn);
        }
    }

    private void addReflectiveHierarchy(ReflectiveHierarchyBuildItem i, Type type, Set<DotName> processedReflectiveHierarchies, Set<DotName> unindexedClasses) {
        block7: {
            block8: {
                block6: {
                    if (type instanceof VoidType || type instanceof PrimitiveType || type instanceof UnresolvedTypeVariable) {
                        return;
                    }
                    if (!(type instanceof ClassType)) break block6;
                    if (this.skipClass(type.name(), processedReflectiveHierarchies)) {
                        return;
                    }
                    this.addClassTypeHierarchy(i, type.name(), processedReflectiveHierarchies, unindexedClasses);
                    for (ClassInfo subclass : this.combinedIndexBuildItem.getIndex().getAllKnownSubclasses(type.name())) {
                        this.addClassTypeHierarchy(i, subclass.name(), processedReflectiveHierarchies, unindexedClasses);
                    }
                    for (ClassInfo subclass : this.combinedIndexBuildItem.getIndex().getAllKnownImplementors(type.name())) {
                        this.addClassTypeHierarchy(i, subclass.name(), processedReflectiveHierarchies, unindexedClasses);
                    }
                    break block7;
                }
                if (!(type instanceof ArrayType)) break block8;
                this.addReflectiveHierarchy(i, type.asArrayType().component(), processedReflectiveHierarchies, unindexedClasses);
                break block7;
            }
            if (!(type instanceof ParameterizedType)) break block7;
            ParameterizedType p = (ParameterizedType)type;
            if (!IGNORED_PARAMETERIZED_TYPE_PACKAGE_NAMES.contains(p.name().toString())) {
                this.addClassTypeHierarchy(i, p.name(), processedReflectiveHierarchies, unindexedClasses);
            }
            for (Type arg : p.arguments()) {
                this.addReflectiveHierarchy(i, arg, processedReflectiveHierarchies, unindexedClasses);
            }
        }
    }

    private void addClassTypeHierarchy(ReflectiveHierarchyBuildItem i, DotName name, Set<DotName> processedReflectiveHierarchies, Set<DotName> unindexedClasses) {
        if (this.skipClass(name, processedReflectiveHierarchies)) {
            return;
        }
        processedReflectiveHierarchies.add(name);
        this.reflectiveClass.produce(new ReflectiveClassBuildItem(true, true, name.toString()));
        ClassInfo info = (i.getIndex() != null ? i.getIndex() : this.combinedIndexBuildItem.getIndex()).getClassByName(name);
        if (info == null) {
            unindexedClasses.add(name);
        } else {
            this.addClassTypeHierarchy(i, info.superName(), processedReflectiveHierarchies, unindexedClasses);
            for (FieldInfo field : info.fields()) {
                if (Modifier.isStatic(field.flags()) || field.name().startsWith("this$") || field.name().startsWith("val$")) continue;
                this.addReflectiveHierarchy(i, field.type(), processedReflectiveHierarchies, unindexedClasses);
            }
            for (MethodInfo method : info.methods()) {
                if (method.parameters().size() > 0 || Modifier.isStatic(method.flags()) || method.returnType().kind() == Type.Kind.VOID) continue;
                this.addReflectiveHierarchy(i, method.returnType(), processedReflectiveHierarchies, unindexedClasses);
            }
        }
    }

    private boolean skipClass(DotName name, Set<DotName> processedReflectiveHierarchies) {
        return name.toString().startsWith("java.") || processedReflectiveHierarchies.contains(name);
    }
}

