/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class LiveReloadBuildItem
extends SimpleBuildItem {
    private final boolean liveReload;
    private final Set<String> changedResources;
    private final Map<Class<?>, Object> reloadContext;

    public LiveReloadBuildItem() {
        this.liveReload = false;
        this.changedResources = Collections.emptySet();
        this.reloadContext = new ConcurrentHashMap();
    }

    public LiveReloadBuildItem(boolean liveReload, Set<String> changedResources, Map<Class<?>, Object> reloadContext) {
        this.liveReload = liveReload;
        this.changedResources = changedResources;
        this.reloadContext = reloadContext;
    }

    public boolean isLiveReload() {
        return this.liveReload;
    }

    public Set<String> getChangedResources() {
        return this.changedResources;
    }

    public <T> T getContextObject(Class<T> type) {
        return (T)this.reloadContext.get(type);
    }

    public <T> void setContextObject(Class<T> type, T val) {
        this.reloadContext.put(type, val);
    }
}

