/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.bean;

public class JavaBeanUtil {
    private static final String GET = "get";
    private static final String IS = "is";

    public static String getGetterName(String name, String type) {
        String prefix = type.equals("Z") ? IS : GET;
        return prefix + JavaBeanUtil.capitalize(name);
    }

    public static String getSetterName(String name) {
        return "set" + JavaBeanUtil.capitalize(name);
    }

    public static String capitalize(String name) {
        if (name != null && name.length() != 0) {
            if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
                return name;
            }
            char[] chars = name.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars);
        }
        return name;
    }

    public static String decapitalize(String name) {
        if (name != null && name.length() != 0) {
            if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
                return name;
            }
            char[] chars = name.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            return new String(chars);
        }
        return name;
    }

    public static String getPropertyNameFromGetter(String methodName) {
        if (methodName.startsWith(GET)) {
            return JavaBeanUtil.decapitalize(methodName.substring(GET.length()));
        }
        if (methodName.startsWith(IS)) {
            return JavaBeanUtil.decapitalize(methodName.substring(IS.length()));
        }
        throw new IllegalArgumentException(methodName + " is not a getter");
    }
}

