/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.recording;

import io.quarkus.deployment.proxy.ProxyConfiguration;
import io.quarkus.deployment.proxy.ProxyFactory;
import io.quarkus.deployment.recording.AnnotationProxyProvider;
import io.quarkus.deployment.recording.ObjectLoader;
import io.quarkus.deployment.recording.PropertyUtils;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.ObjectSubstitution;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.StartupContext;
import io.quarkus.runtime.StartupTask;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.wildfly.common.Assert;

public class BytecodeRecorderImpl
implements RecorderContext {
    private static final Class<?> SINGLETON_LIST_CLASS = Collections.singletonList(1).getClass();
    private static final Class<?> SINGLETON_SET_CLASS = Collections.singleton(1).getClass();
    private static final Class<?> SINGLETON_MAP_CLASS = Collections.singletonMap(1, 1).getClass();
    private static final AtomicInteger COUNT = new AtomicInteger();
    private static final AtomicInteger OUTPUT_COUNT = new AtomicInteger();
    private static final String BASE_PACKAGE = "io.quarkus.deployment.steps.";
    private static final String PROXY_KEY = "proxykey";
    private static final MethodDescriptor COLLECTION_ADD = MethodDescriptor.ofMethod(Collection.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor MAP_PUT = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    private final boolean staticInit;
    private final ClassLoader classLoader;
    private final Map<Class<?>, Object> existingProxyClasses = new HashMap();
    private final List<BytecodeInstruction> storedMethodCalls = new ArrayList<BytecodeInstruction>();
    private final Map<Class, ProxyFactory<?>> returnValueProxy = new HashMap();
    private final IdentityHashMap<Class<?>, String> classProxies = new IdentityHashMap();
    private final Map<Class<?>, SubstitutionHolder> substitutions = new HashMap();
    private final Map<Class<?>, NonDefaultConstructorHolder> nonDefaultConstructors = new HashMap();
    private final String className;
    private final List<ObjectLoader> loaders = new ArrayList<ObjectLoader>();
    private static final int MAX_INSTRUCTION_GROUPS = 300;
    private int deferredParameterCount = 0;
    private boolean loadComplete;

    public BytecodeRecorderImpl(ClassLoader classLoader, boolean staticInit, String className) {
        this.classLoader = classLoader;
        this.staticInit = staticInit;
        this.className = className;
    }

    public BytecodeRecorderImpl(boolean staticInit, String buildStepName, String methodName) {
        this(Thread.currentThread().getContextClassLoader(), staticInit, BASE_PACKAGE + buildStepName + "$" + methodName + OUTPUT_COUNT.incrementAndGet());
    }

    public boolean isEmpty() {
        return this.storedMethodCalls.isEmpty();
    }

    @Override
    public <F, T> void registerSubstitution(Class<F> from, Class<T> to, Class<? extends ObjectSubstitution<F, T>> substitution) {
        this.substitutions.put(from, new SubstitutionHolder(from, to, substitution));
    }

    @Override
    public <T> void registerNonDefaultConstructor(Constructor<T> constructor, Function<T, List<Object>> parameters) {
        this.nonDefaultConstructors.put(constructor.getDeclaringClass(), new NonDefaultConstructorHolder(constructor, parameters));
    }

    @Override
    public void registerObjectLoader(ObjectLoader loader) {
        Assert.checkNotNullParam((String)"loader", (Object)loader);
        this.loaders.add(loader);
    }

    @Override
    public Class<?> classProxy(String name) {
        switch (name) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        ProxyFactory<Object> factory = new ProxyFactory<Object>(new ProxyConfiguration<Object>().setSuperClass(Object.class).setClassLoader(this.classLoader).setAnchorClass(this.getClass()).setProxyNameSuffix("$$ClassProxy" + COUNT.incrementAndGet()));
        Class<Object> theClass = factory.defineClass();
        this.classProxies.put(theClass, name);
        return theClass;
    }

    @Override
    public <T> RuntimeValue<T> newInstance(String name) {
        try {
            ProxyInstance ret = this.getProxyInstance(RuntimeValue.class);
            NewInstance instance = new NewInstance(name, ret.proxy, ret.key);
            this.storedMethodCalls.add(instance);
            return (RuntimeValue)ret.proxy;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isProxiable(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return false;
        }
        if (Modifier.isFinal(returnType.getModifiers())) {
            return false;
        }
        boolean returnInterface = returnType.isInterface();
        if (!returnInterface) {
            try {
                returnType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return true;
    }

    public <T> T getRecordingProxy(final Class<T> theClass) {
        if (this.existingProxyClasses.containsKey(theClass)) {
            return theClass.cast(this.existingProxyClasses.get(theClass));
        }
        String proxyNameSuffix = "$$RecordingProxyProxy" + COUNT.incrementAndGet();
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration<T>().setSuperClass(theClass).setClassLoader(this.classLoader).setAnchorClass(this.getClass()).setProxyNameSuffix(proxyNameSuffix);
        final String proxyName = proxyConfiguration.getProxyName();
        ProxyFactory factory = new ProxyFactory(proxyConfiguration);
        try {
            Object recordingProxy = factory.newInstance(new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    StoredMethodCall storedMethodCall = new StoredMethodCall(theClass, method, args);
                    BytecodeRecorderImpl.this.storedMethodCalls.add(storedMethodCall);
                    Class<?> returnType = method.getReturnType();
                    if (method.getName().equals("toString") && method.getParameterTypes().length == 0 && returnType.equals(String.class)) {
                        return proxyName;
                    }
                    boolean voidMethod = method.getReturnType().equals(Void.TYPE);
                    if (!voidMethod && !BytecodeRecorderImpl.isProxiable(method.getReturnType())) {
                        throw new RuntimeException("Cannot use " + method + " as a recorder method as the return type cannot be proxied. Use RuntimeValue to wrap the return value instead.");
                    }
                    if (voidMethod) {
                        return null;
                    }
                    ProxyInstance instance = BytecodeRecorderImpl.this.getProxyInstance(returnType);
                    if (instance == null) {
                        return null;
                    }
                    storedMethodCall.returnedProxy = instance.proxy;
                    storedMethodCall.proxyId = instance.key;
                    return instance.proxy;
                }
            });
            this.existingProxyClasses.put(theClass, recordingProxy);
            return recordingProxy;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private ProxyInstance getProxyInstance(final Class<?> returnType) throws InstantiationException, IllegalAccessException {
        boolean returnInterface = returnType.isInterface();
        ProxyFactory<Object> proxyFactory = this.returnValueProxy.get(returnType);
        if (proxyFactory == null) {
            ProxyConfiguration<Object> proxyConfiguration = new ProxyConfiguration<Object>().setSuperClass(returnInterface ? Object.class : returnType).setClassLoader(this.classLoader).addAdditionalInterface(ReturnedProxy.class).setAnchorClass(this.getClass()).setProxyNameSuffix("$$ReturnValueProxy" + COUNT.incrementAndGet());
            if (returnInterface) {
                proxyConfiguration.addAdditionalInterface(returnType);
            }
            proxyFactory = new ProxyFactory<Object>(proxyConfiguration);
            this.returnValueProxy.put(returnType, proxyFactory);
        }
        final String key = PROXY_KEY + COUNT.incrementAndGet();
        Object proxyInstance = proxyFactory.newInstance(new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("__returned$proxy$key")) {
                    return key;
                }
                if (method.getName().equals("__static$$init")) {
                    return BytecodeRecorderImpl.this.staticInit;
                }
                if (method.getName().equals("toString") && method.getParameterTypes().length == 0 && method.getReturnType().equals(String.class)) {
                    return "Runtime proxy of " + returnType + " with id " + key;
                }
                throw new RuntimeException("You cannot invoke " + method.getName() + "() directly on an object returned from the bytecode recorder, you can only pass it back into the recorder as a parameter");
            }
        });
        ProxyInstance instance = new ProxyInstance(proxyInstance, key);
        return instance;
    }

    public String getClassName() {
        return this.className;
    }

    public void writeBytecode(ClassOutput classOutput) {
        ClassCreator file = ClassCreator.builder().classOutput(classOutput).className(this.className).superClass(Object.class).interfaces(new Class[]{StartupTask.class}).build();
        MethodCreator mainMethod = file.getMethodCreator("deploy", Void.TYPE, new Class[]{StartupContext.class});
        HashMap classInstanceVariables = new HashMap();
        IdentityHashMap<Object, DeferredParameter> parameterMap = new IdentityHashMap<Object, DeferredParameter>();
        for (BytecodeInstruction set : this.storedMethodCalls) {
            if (!(set instanceof StoredMethodCall)) continue;
            final StoredMethodCall call = (StoredMethodCall)set;
            if (!classInstanceVariables.containsKey(call.theClass)) {
                DeferredArrayStoreParameter value = new DeferredArrayStoreParameter(){

                    @Override
                    ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.newInstance(MethodDescriptor.ofConstructor(call.theClass, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
                classInstanceVariables.put(call.theClass, value);
            }
            for (int i = 0; i < call.parameters.length; ++i) {
                call.deferredParameters[i] = this.loadObjectInstance(call.parameters[i], parameterMap, call.method.getParameterTypes()[i]);
            }
        }
        this.loadComplete = true;
        ResultHandle array = mainMethod.newArray(Object.class, mainMethod.load(this.deferredParameterCount));
        SplitMethodContext context = new SplitMethodContext(array, mainMethod, file);
        for (final BytecodeInstruction set : this.storedMethodCalls) {
            if (set instanceof StoredMethodCall) {
                final StoredMethodCall call = (StoredMethodCall)set;
                for (int i = 0; i < call.parameters.length; ++i) {
                    call.deferredParameters[i].prepare(context);
                }
                final DeferredArrayStoreParameter recorderInstance = (DeferredArrayStoreParameter)classInstanceVariables.get(call.theClass);
                recorderInstance.prepare(context);
                context.writeInstruction(new InstructionGroup(){

                    @Override
                    public void write(MethodContext context, MethodCreator method, ResultHandle array) {
                        ResultHandle[] params = new ResultHandle[call.parameters.length];
                        for (int i = 0; i < call.parameters.length; ++i) {
                            params[i] = context.loadDeferred(call.deferredParameters[i]);
                        }
                        ResultHandle callResult = method.invokeVirtualMethod(MethodDescriptor.ofMethod(call.method.getDeclaringClass(), (String)call.method.getName(), call.method.getReturnType(), (Class[])call.method.getParameterTypes()), context.loadDeferred(recorderInstance), params);
                        if (call.method.getReturnType() != Void.TYPE && call.returnedProxy != null) {
                            method.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"putValue", Void.TYPE, (Class[])new Class[]{String.class, Object.class}), method.getMethodParam(0), new ResultHandle[]{method.load(call.proxyId), callResult});
                        }
                    }
                });
                continue;
            }
            if (set instanceof NewInstance) {
                context.writeInstruction(new InstructionGroup(){

                    @Override
                    public void write(MethodContext context, MethodCreator method, ResultHandle array) {
                        NewInstance ni = (NewInstance)set;
                        ResultHandle val = method.newInstance(MethodDescriptor.ofConstructor((String)ni.theClass, (String[])new String[0]), new ResultHandle[0]);
                        ResultHandle rv = method.newInstance(MethodDescriptor.ofConstructor(RuntimeValue.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{val});
                        method.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"putValue", Void.TYPE, (Class[])new Class[]{String.class, Object.class}), method.getMethodParam(0), new ResultHandle[]{method.load(ni.proxyId), rv});
                    }
                });
                continue;
            }
            throw new RuntimeException("unknown type " + set);
        }
        context.close();
        mainMethod.returnValue(null);
        file.close();
    }

    private DeferredParameter loadObjectInstance(Object param, Map<Object, DeferredParameter> existing, Class<?> expectedType) {
        if (this.loadComplete) {
            throw new RuntimeException("All parameters have already been loaded, it is too late to call loadObjectInstance");
        }
        if (existing.containsKey(param)) {
            return existing.get(param);
        }
        DeferredParameter ret = this.loadObjectInstanceImpl(param, existing, expectedType);
        existing.put(param, ret);
        return ret;
    }

    private DeferredParameter loadObjectInstanceImpl(final Object param, Map<Object, DeferredParameter> existing, final Class<?> expectedType) {
        if (param == null) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext creator, MethodCreator method, ResultHandle array) {
                    return method.loadNull();
                }
            };
        }
        DeferredParameter loadedObject = this.findLoaded(param);
        if (loadedObject != null) {
            return loadedObject;
        }
        loadedObject = this.handleCollectionsObjects(param, existing);
        if (loadedObject != null) {
            return loadedObject;
        }
        if (this.substitutions.containsKey(param.getClass()) || this.substitutions.containsKey(expectedType)) {
            SubstitutionHolder holder = this.substitutions.get(param.getClass());
            if (holder == null) {
                holder = this.substitutions.get(expectedType);
            }
            try {
                ObjectSubstitution<?, ?> substitution = holder.sub.newInstance();
                Object res = substitution.serialize(param);
                final DeferredParameter serialized = this.loadObjectInstance(res, existing, holder.to);
                final SubstitutionHolder finalHolder = holder;
                return new DeferredArrayStoreParameter(){

                    @Override
                    void doPrepare(MethodContext context) {
                        serialized.prepare(context);
                        super.doPrepare(context);
                    }

                    @Override
                    ResultHandle createValue(MethodContext creator, MethodCreator method, ResultHandle array) {
                        ResultHandle subInstance = method.newInstance(MethodDescriptor.ofConstructor(finalHolder.sub, (Class[])new Class[0]), new ResultHandle[0]);
                        return method.invokeInterfaceMethod(MethodDescriptor.ofMethod(ObjectSubstitution.class, (String)"deserialize", Object.class, (Class[])new Class[]{Object.class}), subInstance, new ResultHandle[]{creator.loadDeferred(serialized)});
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to substitute " + param, e);
            }
        }
        if (param instanceof Optional) {
            Optional val = (Optional)param;
            if (val.isPresent()) {
                final DeferredParameter res = this.loadObjectInstance(val.get(), existing, Object.class);
                return new DeferredArrayStoreParameter(){

                    @Override
                    ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"of", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{context.loadDeferred(res)});
                    }
                };
            }
            return new DeferredArrayStoreParameter(){

                @Override
                ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"empty", Optional.class, (Class[])new Class[0]), new ResultHandle[0]);
                }
            };
        }
        if (param instanceof String) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load((String)param);
                }
            };
        }
        if (param instanceof Integer) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Integer.class, (String)"valueOf", Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{method.load(((Integer)param).intValue())});
                }
            };
        }
        if (param instanceof Boolean) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Boolean.class, (String)"valueOf", Boolean.class, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{method.load(((Boolean)param).booleanValue())});
                }
            };
        }
        if (param instanceof URL) {
            final String url = ((URL)param).toExternalForm();
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    AssignableResultHandle value = method.createVariable(URL.class);
                    try (TryBlock et = method.tryBlock();){
                        et.assign(value, et.newInstance(MethodDescriptor.ofConstructor(URL.class, (Class[])new Class[]{String.class}), new ResultHandle[]{et.load(url)}));
                        try (CatchBlockCreator malformed = et.addCatch(MalformedURLException.class);){
                            malformed.throwException(RuntimeException.class, "Malformed URL", malformed.getCaughtException());
                        }
                    }
                    return value;
                }
            };
        }
        if (param instanceof Enum) {
            final Enum e = (Enum)param;
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    ResultHandle nm = method.load(e.name());
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(e.getDeclaringClass(), (String)"valueOf", e.getDeclaringClass(), (Class[])new Class[]{String.class}), new ResultHandle[]{nm});
                }
            };
        }
        if (param instanceof ReturnedProxy) {
            ReturnedProxy rp = (ReturnedProxy)param;
            if (!rp.__static$$init() && this.staticInit) {
                throw new RuntimeException("Invalid proxy passed to recorder. " + rp + " was created in a runtime recorder method, while this recorder is for a static init method. The object will not have been created at the time this method is run.");
            }
            final String proxyId = rp.__returned$proxy$key();
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"getValue", Object.class, (Class[])new Class[]{String.class}), method.getMethodParam(0), new ResultHandle[]{method.load(proxyId)});
                }
            };
        }
        if (param instanceof Duration) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Duration.class, (String)"parse", Duration.class, (Class[])new Class[]{CharSequence.class}), new ResultHandle[]{method.load(param.toString())});
                }
            };
        }
        if (param instanceof Class) {
            if (!((Class)param).isPrimitive()) {
                String name = this.classProxies.get(param);
                if (name == null) {
                    name = ((Class)param).getName();
                }
                final String finalName = name;
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        ResultHandle currentThread = method.invokeStaticMethod(MethodDescriptor.ofMethod(Thread.class, (String)"currentThread", Thread.class, (Class[])new Class[0]), new ResultHandle[0]);
                        ResultHandle tccl = method.invokeVirtualMethod(MethodDescriptor.ofMethod(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]), currentThread, new ResultHandle[0]);
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{method.load(finalName), method.load(true), tccl});
                    }
                };
            }
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.loadClass((Class)param);
                }
            };
        }
        if (expectedType == Boolean.TYPE) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Boolean)param).booleanValue());
                }
            };
        }
        if (expectedType == Boolean.class) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Boolean.class, (String)"valueOf", Boolean.class, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{method.load(((Boolean)param).booleanValue())});
                }
            };
        }
        if (expectedType == Integer.TYPE) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Integer)param).intValue());
                }
            };
        }
        if (expectedType == Integer.class) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Integer.class, (String)"valueOf", Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{method.load(((Integer)param).intValue())});
                }
            };
        }
        if (expectedType == Short.TYPE) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Short)param).shortValue());
                }
            };
        }
        if (expectedType == Short.class || param instanceof Short) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Short.class, (String)"valueOf", Short.class, (Class[])new Class[]{Short.TYPE}), new ResultHandle[]{method.load(((Short)param).shortValue())});
                }
            };
        }
        if (expectedType == Byte.TYPE) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Byte)param).byteValue());
                }
            };
        }
        if (expectedType == Byte.class || param instanceof Byte) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Byte.class, (String)"valueOf", Byte.class, (Class[])new Class[]{Byte.TYPE}), new ResultHandle[]{method.load(((Byte)param).byteValue())});
                }
            };
        }
        if (expectedType == Character.TYPE) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Character)param).charValue());
                }
            };
        }
        if (expectedType == Character.class || param instanceof Character) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Character.class, (String)"valueOf", Character.class, (Class[])new Class[]{Character.TYPE}), new ResultHandle[]{method.load(((Character)param).charValue())});
                }
            };
        }
        if (expectedType == Long.TYPE) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Long)param).longValue());
                }
            };
        }
        if (expectedType == Long.class || param instanceof Long) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Long.class, (String)"valueOf", Long.class, (Class[])new Class[]{Long.TYPE}), new ResultHandle[]{method.load(((Long)param).longValue())});
                }
            };
        }
        if (expectedType == Float.TYPE) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Float)param).floatValue());
                }
            };
        }
        if (expectedType == Float.class || param instanceof Float) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Float.class, (String)"valueOf", Float.class, (Class[])new Class[]{Float.TYPE}), new ResultHandle[]{method.load(((Float)param).floatValue())});
                }
            };
        }
        if (expectedType == Double.TYPE) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.load(((Double)param).doubleValue());
                }
            };
        }
        if (expectedType == Double.class || param instanceof Double) {
            return new DeferredParameter(){

                @Override
                ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.invokeStaticMethod(MethodDescriptor.ofMethod(Double.class, (String)"valueOf", Double.class, (Class[])new Class[]{Double.TYPE}), new ResultHandle[]{method.load(((Double)param).doubleValue())});
                }
            };
        }
        if (expectedType.isArray()) {
            final int length = Array.getLength(param);
            final DeferredParameter[] components = new DeferredParameter[length];
            for (int i = 0; i < length; ++i) {
                DeferredParameter component;
                components[i] = component = this.loadObjectInstance(Array.get(param, i), existing, expectedType.getComponentType());
            }
            return new DeferredArrayStoreParameter(){

                @Override
                void doPrepare(MethodContext context) {
                    for (int i = 0; i < length; ++i) {
                        components[i].prepare(context);
                    }
                    super.doPrepare(context);
                }

                @Override
                ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                    ResultHandle out = method.newArray(expectedType.getComponentType(), method.load(length));
                    for (int i = 0; i < length; ++i) {
                        method.writeArrayValue(out, i, context.loadDeferred(components[i]));
                    }
                    return out;
                }
            };
        }
        if (param instanceof AnnotationProxyProvider.AnnotationProxy) {
            final AnnotationProxyProvider.AnnotationProxy annotationProxy = (AnnotationProxyProvider.AnnotationProxy)param;
            final List constructorParams = annotationProxy.getAnnotationClass().methods().stream().filter(m -> !m.name().equals("<clinit>") && !m.name().equals("<init>")).collect(Collectors.toList());
            Map annotationValues = annotationProxy.getAnnotationInstance().values().stream().collect(Collectors.toMap(AnnotationValue::name, Function.identity()));
            final DeferredParameter[] constructorParamsHandles = new DeferredParameter[constructorParams.size()];
            ListIterator iterator = constructorParams.listIterator();
            while (iterator.hasNext()) {
                DeferredParameter retValue;
                MethodInfo valueMethod = (MethodInfo)iterator.next();
                AnnotationValue value = (AnnotationValue)annotationValues.get(valueMethod.name());
                if (value == null) {
                    Object defaultValue = annotationProxy.getDefaultValues().get(valueMethod.name());
                    if (defaultValue != null) {
                        constructorParamsHandles[iterator.previousIndex()] = this.loadObjectInstance(defaultValue, existing, defaultValue.getClass());
                        continue;
                    }
                    if (value == null) {
                        value = valueMethod.defaultValue();
                    }
                }
                if (value == null) {
                    throw new NullPointerException("Value not set for " + param);
                }
                constructorParamsHandles[iterator.previousIndex()] = retValue = this.loadValue(value, annotationProxy.getAnnotationClass(), valueMethod);
            }
            return new DeferredArrayStoreParameter(){

                @Override
                ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                    return method.newInstance(MethodDescriptor.ofConstructor((Object)annotationProxy.getAnnotationLiteralType(), (Object[])constructorParams.stream().map(m -> m.returnType().name().toString()).toArray()), (ResultHandle[])Arrays.stream(constructorParamsHandles).map(m -> context.loadDeferred((DeferredParameter)m)).toArray(ResultHandle[]::new));
                }
            };
        }
        return this.loadComplexObject(param, existing, expectedType);
    }

    private DeferredParameter handleCollectionsObjects(Object param, Map<Object, DeferredParameter> existing) {
        if (param instanceof Collection) {
            if (param.getClass().equals(Collections.emptyList().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptyList", List.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(Collections.emptySet().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptySet", Set.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(Collections.emptySortedSet().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptySortedSet", SortedSet.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(Collections.emptyNavigableSet().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptyNavigableSet", NavigableSet.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(SINGLETON_LIST_CLASS)) {
                final DeferredParameter deferred = this.loadObjectInstance(((List)param).get(0), existing, Object.class);
                return new DeferredParameter(){

                    @Override
                    void doPrepare(MethodContext context) {
                        super.doPrepare(context);
                        deferred.doPrepare(context);
                    }

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        ResultHandle res = context.loadDeferred(deferred);
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"singletonList", List.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{res});
                    }
                };
            }
            if (param.getClass().equals(SINGLETON_SET_CLASS)) {
                final DeferredParameter deferred = this.loadObjectInstance(((Set)param).iterator().next(), existing, Object.class);
                return new DeferredParameter(){

                    @Override
                    void doPrepare(MethodContext context) {
                        super.doPrepare(context);
                        deferred.doPrepare(context);
                    }

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        ResultHandle res = context.loadDeferred(deferred);
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"singleton", Set.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{res});
                    }
                };
            }
        } else if (param instanceof Map) {
            if (param.getClass().equals(Collections.emptyMap().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptyMap", Map.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(Collections.emptySortedMap().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptySortedMap", SortedMap.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(Collections.emptyNavigableMap().getClass())) {
                return new DeferredParameter(){

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"emptyNavigableMap", SortedMap.class, (Class[])new Class[0]), new ResultHandle[0]);
                    }
                };
            }
            if (param.getClass().equals(SINGLETON_MAP_CLASS)) {
                Map.Entry entry = ((Map)param).entrySet().iterator().next();
                final DeferredParameter key = this.loadObjectInstance(entry.getKey(), existing, Object.class);
                final DeferredParameter value = this.loadObjectInstance(entry.getValue(), existing, Object.class);
                return new DeferredParameter(){

                    @Override
                    void doPrepare(MethodContext context) {
                        super.doPrepare(context);
                        key.doPrepare(context);
                        value.doPrepare(context);
                    }

                    @Override
                    ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
                        ResultHandle k = context.loadDeferred(key);
                        ResultHandle v = context.loadDeferred(value);
                        return method.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"singletonMap", Map.class, (Class[])new Class[]{Object.class, Object.class}), new ResultHandle[]{k, v});
                    }
                };
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private DeferredParameter loadComplexObject(final Object param, Map<Object, DeferredParameter> existing, Class<?> expectedType) {
        void var7_17;
        PropertyUtils.Property[] propertyArray;
        final ArrayList<SerialzationStep> setupSteps = new ArrayList<SerialzationStep>();
        if (param instanceof Collection) {
            for (Object e : (Collection)param) {
                final DeferredParameter deferredParameter = this.loadObjectInstance(e, existing, e.getClass());
                setupSteps.add(new SerialzationStep(){

                    @Override
                    public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                        method.invokeInterfaceMethod(COLLECTION_ADD, context.loadDeferred(out), new ResultHandle[]{context.loadDeferred(deferredParameter)});
                    }

                    @Override
                    public void prepare(MethodContext context) {
                        deferredParameter.prepare(context);
                    }
                });
            }
        }
        if (param instanceof Map) {
            for (Map.Entry entry : ((Map)param).entrySet()) {
                final DeferredParameter deferredParameter = this.loadObjectInstance(entry.getKey(), existing, entry.getKey().getClass());
                final DeferredParameter val = entry.getValue() != null ? this.loadObjectInstance(entry.getValue(), existing, entry.getValue().getClass()) : null;
                setupSteps.add(new SerialzationStep(){

                    @Override
                    public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                        method.invokeInterfaceMethod(MAP_PUT, context.loadDeferred(out), new ResultHandle[]{context.loadDeferred(deferredParameter), context.loadDeferred(val)});
                    }

                    @Override
                    public void prepare(MethodContext context) {
                        deferredParameter.prepare(context);
                        val.prepare(context);
                    }
                });
            }
        }
        HashSet<String> handledProperties = new HashSet<String>();
        for (final PropertyUtils.Property property : propertyArray = PropertyUtils.getPropertyDescriptors(param)) {
            Object propertyValue;
            if (property.getReadMethod() != null && property.getWriteMethod() == null) {
                try {
                    if (Collection.class.isAssignableFrom(property.getPropertyType())) {
                        handledProperties.add(property.getName());
                        propertyValue = (Collection)property.read(param);
                        if (propertyValue.isEmpty()) continue;
                        final ArrayList<DeferredParameter> params = new ArrayList<DeferredParameter>();
                        Method[] methodArray = propertyValue.iterator();
                        while (methodArray.hasNext()) {
                            Object e = methodArray.next();
                            DeferredParameter toAdd = this.loadObjectInstance(e, existing, Object.class);
                            params.add(toAdd);
                        }
                        setupSteps.add(new SerialzationStep(){

                            @Override
                            public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                                ResultHandle prop = method.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)property.getReadMethod()), context.loadDeferred(out), new ResultHandle[0]);
                                for (DeferredParameter i : params) {
                                    method.invokeInterfaceMethod(COLLECTION_ADD, prop, new ResultHandle[]{context.loadDeferred(i)});
                                }
                            }

                            @Override
                            public void prepare(MethodContext context) {
                                for (DeferredParameter i : params) {
                                    i.prepare(context);
                                }
                            }
                        });
                        continue;
                    }
                    if (!Map.class.isAssignableFrom(property.getPropertyType())) continue;
                    handledProperties.add(property.getName());
                    propertyValue = (Map)property.read(param);
                    if (propertyValue.isEmpty()) continue;
                    final LinkedHashMap<DeferredParameter, DeferredParameter> def = new LinkedHashMap<DeferredParameter, DeferredParameter>();
                    for (Map.Entry entry : propertyValue.entrySet()) {
                        DeferredParameter key = this.loadObjectInstance(entry.getKey(), existing, Object.class);
                        DeferredParameter val = this.loadObjectInstance(entry.getValue(), existing, Object.class);
                        def.put(key, val);
                    }
                    setupSteps.add(new SerialzationStep(){

                        @Override
                        public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                            ResultHandle prop = method.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)property.getReadMethod()), context.loadDeferred(out), new ResultHandle[0]);
                            for (Map.Entry e : def.entrySet()) {
                                method.invokeInterfaceMethod(MAP_PUT, prop, new ResultHandle[]{context.loadDeferred((DeferredParameter)e.getKey()), context.loadDeferred((DeferredParameter)e.getValue())});
                            }
                        }

                        @Override
                        public void prepare(MethodContext context) {
                            for (Map.Entry e : def.entrySet()) {
                                ((DeferredParameter)e.getKey()).prepare(context);
                                ((DeferredParameter)e.getValue()).prepare(context);
                            }
                        }
                    });
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (property.getReadMethod() == null || property.getWriteMethod() == null) continue;
            try {
                handledProperties.add(property.getName());
                propertyValue = property.read(param);
                if (propertyValue == null) continue;
                Class<?> propertyType = property.getPropertyType();
                if (property.getReadMethod().getReturnType() != property.getWriteMethod().getParameterTypes()[0]) {
                    for (Method m : param.getClass().getMethods()) {
                        if (!m.getName().equals(property.getWriteMethod().getName()) || m.getParameterTypes().length <= 0 || !m.getParameterTypes()[0].isAssignableFrom(param.getClass())) continue;
                        propertyType = m.getParameterTypes()[0];
                        break;
                    }
                }
                final DeferredParameter val = this.loadObjectInstance(propertyValue, existing, property.getPropertyType());
                final Class<?> clazz = propertyType;
                setupSteps.add(new SerialzationStep(){

                    @Override
                    public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                        method.invokeVirtualMethod(MethodDescriptor.ofMethod(param.getClass(), (String)property.getWriteMethod().getName(), property.getWriteMethod().getReturnType(), (Class[])new Class[]{clazz}), context.loadDeferred(out), new ResultHandle[]{context.loadDeferred(val)});
                    }

                    @Override
                    public void prepare(MethodContext context) {
                        val.prepare(context);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (final Field field : param.getClass().getFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || handledProperties.contains(field.getName())) continue;
            try {
                final DeferredParameter val = this.loadObjectInstance(field.get(param), existing, field.getType());
                setupSteps.add(new SerialzationStep(){

                    @Override
                    public void handle(MethodContext context, MethodCreator method, DeferredArrayStoreParameter out) {
                        method.writeInstanceField(FieldDescriptor.of(param.getClass(), (String)field.getName(), field.getType()), context.loadDeferred(out), context.loadDeferred(val));
                    }

                    @Override
                    public void prepare(MethodContext context) {
                        val.prepare(context);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Object var7_15 = null;
        ArrayList<DeferredParameter> nonDefaultConstructorHandles = new ArrayList<DeferredParameter>();
        if (this.nonDefaultConstructors.containsKey(param.getClass())) {
            NonDefaultConstructorHolder nonDefaultConstructorHolder = this.nonDefaultConstructors.get(param.getClass());
            List<Object> params = nonDefaultConstructorHolder.paramGenerator.apply(param);
            if (params.size() != nonDefaultConstructorHolder.constructor.getParameterCount()) {
                throw new RuntimeException("Unable to serialize " + param + " as the wrong number of parameters were generated for " + nonDefaultConstructorHolder.constructor);
            }
            boolean bl = false;
            for (Object i : params) {
                void var10_28;
                nonDefaultConstructorHandles.add(this.loadObjectInstance(i, existing, nonDefaultConstructorHolder.constructor.getParameterTypes()[++var10_28]));
            }
        }
        void finalNonDefaultConstructorHolder = var7_17;
        final DeferredArrayStoreParameter deferredArrayStoreParameter = new DeferredArrayStoreParameter((NonDefaultConstructorHolder)finalNonDefaultConstructorHolder, nonDefaultConstructorHandles, param, expectedType){
            final /* synthetic */ NonDefaultConstructorHolder val$finalNonDefaultConstructorHolder;
            final /* synthetic */ List val$nonDefaultConstructorHandles;
            final /* synthetic */ Object val$param;
            final /* synthetic */ Class val$expectedType;
            {
                this.val$finalNonDefaultConstructorHolder = nonDefaultConstructorHolder;
                this.val$nonDefaultConstructorHandles = list;
                this.val$param = object;
                this.val$expectedType = clazz;
            }

            @Override
            ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                ResultHandle out;
                if (this.val$finalNonDefaultConstructorHolder != null) {
                    out = method.newInstance(MethodDescriptor.ofConstructor(this.val$finalNonDefaultConstructorHolder.constructor.getDeclaringClass(), (Class[])this.val$finalNonDefaultConstructorHolder.constructor.getParameterTypes()), (ResultHandle[])this.val$nonDefaultConstructorHandles.stream().map(m -> context.loadDeferred((DeferredParameter)m)).toArray(ResultHandle[]::new));
                } else {
                    try {
                        this.val$param.getClass().getDeclaredConstructor(new Class[0]);
                        out = method.newInstance(MethodDescriptor.ofConstructor(this.val$param.getClass(), (Class[])new Class[0]), new ResultHandle[0]);
                    }
                    catch (NoSuchMethodException e) {
                        if (SortedMap.class.isAssignableFrom(this.val$expectedType)) {
                            out = method.newInstance(MethodDescriptor.ofConstructor(TreeMap.class, (Class[])new Class[0]), new ResultHandle[0]);
                        }
                        if (Map.class.isAssignableFrom(this.val$expectedType)) {
                            out = method.newInstance(MethodDescriptor.ofConstructor(LinkedHashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
                        }
                        if (List.class.isAssignableFrom(this.val$expectedType)) {
                            out = method.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                        }
                        if (SortedSet.class.isAssignableFrom(this.val$expectedType)) {
                            out = method.newInstance(MethodDescriptor.ofConstructor(TreeSet.class, (Class[])new Class[0]), new ResultHandle[0]);
                        }
                        if (Set.class.isAssignableFrom(this.val$expectedType)) {
                            out = method.newInstance(MethodDescriptor.ofConstructor(LinkedHashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
                        }
                        throw new RuntimeException("Unable to serialize objects of type " + this.val$param.getClass() + " to bytecode as it has no default constructor");
                    }
                }
                return out;
            }
        };
        return new DeferredArrayStoreParameter(){

            @Override
            void doPrepare(MethodContext context) {
                deferredArrayStoreParameter.prepare(context);
                for (final SerialzationStep i : setupSteps) {
                    i.prepare(context);
                }
                for (final SerialzationStep i : setupSteps) {
                    context.writeInstruction(new InstructionGroup(){

                        @Override
                        public void write(MethodContext context, MethodCreator method, ResultHandle array) {
                            i.handle(context, method, deferredArrayStoreParameter);
                        }
                    });
                }
                super.doPrepare(context);
            }

            @Override
            ResultHandle createValue(MethodContext context, MethodCreator method, ResultHandle array) {
                return context.loadDeferred(deferredArrayStoreParameter);
            }
        };
    }

    private DeferredParameter findLoaded(final Object param) {
        for (final ObjectLoader loader : this.loaders) {
            if (!loader.canHandleObject(param, this.staticInit)) continue;
            return new DeferredArrayStoreParameter(){

                @Override
                ResultHandle createValue(MethodContext creator, MethodCreator method, ResultHandle array) {
                    return loader.load((BytecodeCreator)method, param, BytecodeRecorderImpl.this.staticInit);
                }
            };
        }
        return null;
    }

    DeferredParameter loadValue(final AnnotationValue value, final ClassInfo annotationClass, final MethodInfo method) {
        return new DeferredParameter(){

            @Override
            ResultHandle doLoad(MethodContext context, MethodCreator valueMethod, ResultHandle array) {
                ResultHandle retValue;
                switch (value.kind()) {
                    case BOOLEAN: {
                        retValue = valueMethod.load(value.asBoolean());
                        break;
                    }
                    case STRING: {
                        retValue = valueMethod.load(value.asString());
                        break;
                    }
                    case BYTE: {
                        retValue = valueMethod.load(value.asByte());
                        break;
                    }
                    case SHORT: {
                        retValue = valueMethod.load(value.asShort());
                        break;
                    }
                    case LONG: {
                        retValue = valueMethod.load(value.asLong());
                        break;
                    }
                    case INTEGER: {
                        retValue = valueMethod.load(value.asInt());
                        break;
                    }
                    case FLOAT: {
                        retValue = valueMethod.load(value.asFloat());
                        break;
                    }
                    case DOUBLE: {
                        retValue = valueMethod.load(value.asDouble());
                        break;
                    }
                    case CHARACTER: {
                        retValue = valueMethod.load(value.asChar());
                        break;
                    }
                    case CLASS: {
                        retValue = valueMethod.loadClass(value.asClass().toString());
                        break;
                    }
                    case ARRAY: {
                        retValue = BytecodeRecorderImpl.arrayValue(value, (BytecodeCreator)valueMethod, method, annotationClass);
                        break;
                    }
                    case ENUM: {
                        retValue = valueMethod.readStaticField(FieldDescriptor.of((String)value.asEnumType().toString(), (String)value.asEnum(), (String)value.asEnumType().toString()));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported value: " + value);
                    }
                }
                return retValue;
            }
        };
    }

    static ResultHandle arrayValue(AnnotationValue value, BytecodeCreator valueMethod, MethodInfo method, ClassInfo annotationClass) {
        ResultHandle retValue;
        switch (value.componentKind()) {
            case CLASS: {
                Type[] classArray = value.asClassArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(classArray.length));
                for (int i = 0; i < classArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.loadClass(classArray[i].name().toString()));
                }
                break;
            }
            case STRING: {
                String[] stringArray = value.asStringArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(stringArray.length));
                for (int i = 0; i < stringArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(stringArray[i]));
                }
                break;
            }
            case INTEGER: {
                int[] intArray = value.asIntArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(intArray.length));
                for (int i = 0; i < intArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(intArray[i]));
                }
                break;
            }
            case LONG: {
                long[] longArray = value.asLongArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(longArray.length));
                for (int i = 0; i < longArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(longArray[i]));
                }
                break;
            }
            case BYTE: {
                byte[] byteArray = value.asByteArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(byteArray.length));
                for (int i = 0; i < byteArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(byteArray[i]));
                }
                break;
            }
            case CHARACTER: {
                char[] charArray = value.asCharArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(charArray.length));
                for (int i = 0; i < charArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.load(charArray[i]));
                }
                break;
            }
            case ENUM: {
                String[] enumArray = value.asEnumArray();
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(enumArray.length));
                String enumType = BytecodeRecorderImpl.componentType(method);
                for (int i = 0; i < enumArray.length; ++i) {
                    valueMethod.writeArrayValue(retValue, i, valueMethod.readStaticField(FieldDescriptor.of((String)enumType, (String)enumArray[i], (String)enumType)));
                }
                break;
            }
            default: {
                retValue = valueMethod.newArray(BytecodeRecorderImpl.componentType(method), valueMethod.load(0));
            }
        }
        return retValue;
    }

    static String componentType(MethodInfo method) {
        ArrayType arrayType = method.returnType().asArrayType();
        return arrayType.component().name().toString();
    }

    public static interface MethodContext {
        public void writeInstruction(InstructionGroup var1);

        public ResultHandle loadDeferred(DeferredParameter var1);
    }

    static interface InstructionGroup {
        public void write(MethodContext var1, MethodCreator var2, ResultHandle var3);
    }

    final class FixedMethodContext
    implements MethodContext {
        final SplitMethodContext parent;
        final MethodCreator currentMethod;
        final Map<Integer, ResultHandle> currentMethodCache;

        FixedMethodContext(SplitMethodContext parent) {
            this.parent = parent;
            this.currentMethod = parent.currentMethod;
            this.currentMethodCache = parent.currentMethodCache;
        }

        @Override
        public void writeInstruction(InstructionGroup writer) {
            writer.write(this, this.currentMethod, this.currentMethod.getMethodParam(1));
        }

        @Override
        public ResultHandle loadDeferred(DeferredParameter parameter) {
            if (parameter instanceof DeferredArrayStoreParameter) {
                int arrayIndex = ((DeferredArrayStoreParameter)parameter).arrayIndex;
                if (this.currentMethodCache.containsKey(arrayIndex)) {
                    return this.currentMethodCache.get(arrayIndex);
                }
                ResultHandle loaded = parameter.doLoad(this, this.currentMethod, this.currentMethod.getMethodParam(1));
                if (this.parent.currentMethod == this.currentMethod) {
                    this.currentMethodCache.put(arrayIndex, loaded);
                    return loaded;
                }
                ResultHandle ret = this.currentMethod.readArrayValue(this.currentMethod.getMethodParam(1), arrayIndex);
                this.currentMethodCache.put(arrayIndex, ret);
                return ret;
            }
            return parameter.doLoad(this, this.currentMethod, this.currentMethod.getMethodParam(1));
        }
    }

    class SplitMethodContext
    implements Closeable,
    MethodContext {
        final ResultHandle deferredParameterArray;
        final MethodCreator mainMethod;
        final ClassCreator classCreator;
        List<MethodCreator> allMethods = new ArrayList<MethodCreator>();
        int methodCount;
        int currentCount;
        MethodCreator currentMethod;
        Map<Integer, ResultHandle> currentMethodCache = new HashMap<Integer, ResultHandle>();

        SplitMethodContext(ResultHandle deferredParameterArray, MethodCreator mainMethod, ClassCreator classCreator) {
            this.deferredParameterArray = deferredParameterArray;
            this.mainMethod = mainMethod;
            this.classCreator = classCreator;
        }

        @Override
        public void writeInstruction(InstructionGroup writer) {
            if (this.currentMethod == null || this.currentCount++ >= 300) {
                this.newMethod();
            }
            FixedMethodContext c = new FixedMethodContext(this);
            c.writeInstruction(writer);
        }

        @Override
        public ResultHandle loadDeferred(DeferredParameter parameter) {
            if (this.currentMethod == null || this.currentCount++ >= 300) {
                this.newMethod();
            }
            FixedMethodContext c = new FixedMethodContext(this);
            return c.loadDeferred(parameter);
        }

        void newMethod() {
            this.currentCount = 0;
            this.currentMethod = this.classCreator.getMethodCreator(this.mainMethod.getMethodDescriptor().getName() + "_" + this.methodCount++, (Object)this.mainMethod.getMethodDescriptor().getReturnType(), new Object[]{StartupContext.class, Object[].class});
            this.mainMethod.invokeVirtualMethod(this.currentMethod.getMethodDescriptor(), this.mainMethod.getThis(), new ResultHandle[]{this.mainMethod.getMethodParam(0), this.deferredParameterArray});
            this.currentMethodCache = new HashMap<Integer, ResultHandle>();
            this.allMethods.add(this.currentMethod);
        }

        @Override
        public void close() {
            for (MethodCreator i : this.allMethods) {
                i.returnValue(null);
            }
        }
    }

    static interface SerialzationStep {
        public void handle(MethodContext var1, MethodCreator var2, DeferredArrayStoreParameter var3);

        public void prepare(MethodContext var1);
    }

    abstract class DeferredArrayStoreParameter
    extends DeferredParameter {
        final int arrayIndex;

        abstract ResultHandle createValue(MethodContext var1, MethodCreator var2, ResultHandle var3);

        @Override
        void doPrepare(MethodContext context) {
            context.writeInstruction(new InstructionGroup(){

                @Override
                public void write(MethodContext context, MethodCreator method, ResultHandle array) {
                    ResultHandle val = DeferredArrayStoreParameter.this.createValue(context, method, array);
                    method.writeArrayValue(array, DeferredArrayStoreParameter.this.arrayIndex, val);
                }
            });
            this.prepared = true;
        }

        @Override
        final ResultHandle doLoad(MethodContext context, MethodCreator method, ResultHandle array) {
            return method.readArrayValue(array, this.arrayIndex);
        }

        DeferredArrayStoreParameter() {
            this.arrayIndex = BytecodeRecorderImpl.this.deferredParameterCount++;
        }
    }

    abstract class DeferredParameter {
        boolean prepared = false;

        DeferredParameter() {
        }

        abstract ResultHandle doLoad(MethodContext var1, MethodCreator var2, ResultHandle var3);

        final void prepare(MethodContext context) {
            if (!this.prepared) {
                this.prepared = true;
                this.doPrepare(context);
            }
        }

        void doPrepare(MethodContext context) {
        }
    }

    private static final class ProxyInstance {
        final Object proxy;
        final String key;

        ProxyInstance(Object proxy, String key) {
            this.proxy = proxy;
            this.key = key;
        }
    }

    static final class NonDefaultConstructorHolder {
        final Constructor<?> constructor;
        final Function<Object, List<Object>> paramGenerator;

        NonDefaultConstructorHolder(Constructor<?> constructor, Function<Object, List<Object>> paramGenerator) {
            this.constructor = constructor;
            this.paramGenerator = paramGenerator;
        }
    }

    static final class SubstitutionHolder {
        final Class<?> from;
        final Class<?> to;
        final Class<? extends ObjectSubstitution<?, ?>> sub;

        SubstitutionHolder(Class<?> from, Class<?> to, Class<? extends ObjectSubstitution<?, ?>> sub) {
            this.from = from;
            this.to = to;
            this.sub = sub;
        }
    }

    static final class NewInstance
    implements BytecodeInstruction {
        final String theClass;
        final Object returnedProxy;
        final String proxyId;

        NewInstance(String theClass, Object returnedProxy, String proxyId) {
            this.theClass = theClass;
            this.returnedProxy = returnedProxy;
            this.proxyId = proxyId;
        }
    }

    static final class StoredMethodCall
    implements BytecodeInstruction {
        final Class<?> theClass;
        final Method method;
        final Object[] parameters;
        final DeferredParameter[] deferredParameters;
        Object returnedProxy;
        String proxyId;

        StoredMethodCall(Class<?> theClass, Method method, Object[] parameters) {
            this.theClass = theClass;
            this.method = method;
            this.parameters = parameters;
            this.deferredParameters = new DeferredParameter[parameters.length];
        }
    }

    public static interface ReturnedProxy {
        public String __returned$proxy$key();

        public boolean __static$$init();
    }

    static interface BytecodeInstruction {
    }
}

