/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.s2i.deployment;

import io.dekorate.utils.Clients;
import io.dekorate.utils.Serialization;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.InputStreamable;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.ImageUtil;
import io.quarkus.container.image.s2i.deployment.PackageUtil;
import io.quarkus.container.image.s2i.deployment.S2iBaseJavaImage;
import io.quarkus.container.image.s2i.deployment.S2iBaseNativeImage;
import io.quarkus.container.image.s2i.deployment.S2iBuild;
import io.quarkus.container.image.s2i.deployment.S2iConfig;
import io.quarkus.container.image.s2i.deployment.S2iUtils;
import io.quarkus.container.spi.AvailableContainerImageExtensionBuildItem;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.deployment.IsNormalNotRemoteDev;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.kubernetes.client.deployment.KubernetesClientErrorHandler;
import io.quarkus.kubernetes.client.spi.KubernetesClientBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class S2iProcessor {
    public static final String S2I = "s2i";
    private static final String OPENSHIFT = "openshift";
    private static final String BUILD_CONFIG_NAME = "openshift.io/build-config.name";
    private static final String RUNNING = "Running";
    private static final Logger LOG = Logger.getLogger(S2iProcessor.class);

    @BuildStep
    public AvailableContainerImageExtensionBuildItem availability() {
        return new AvailableContainerImageExtensionBuildItem(S2I);
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, S2iBuild.class}, onlyIfNot={NativeBuild.class})
    public void s2iRequirementsJvm(S2iConfig s2iConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem out, PackageConfig packageConfig, JarBuildItem jarBuildItem, CompiledJavaVersionBuildItem compiledJavaVersion, BuildProducer<KubernetesEnvBuildItem> envProducer, BuildProducer<BaseImageInfoBuildItem> builderImageProducer, BuildProducer<KubernetesCommandBuildItem> commandProducer) {
        Collection appDeps = curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies();
        String outputJarFileName = jarBuildItem.getPath().getFileName().toString();
        String classpath = appDeps.stream().map(d -> d.getGroupId() + "." + d.getResolvedPaths().getSinglePath().getFileName()).map(s -> S2iProcessor.concatUnixPaths(s2iConfig.jarDirectory, "lib", s)).collect(Collectors.joining(":"));
        String jarFileName = s2iConfig.jarFileName.orElse(outputJarFileName);
        String jarDirectory = s2iConfig.jarDirectory;
        String pathToJar = S2iProcessor.concatUnixPaths(jarDirectory, jarFileName);
        String baseJvmImage = s2iConfig.baseJvmImage.orElse(S2iConfig.getDefaultJvmImage(compiledJavaVersion.getJavaVersion()));
        builderImageProducer.produce((BuildItem)new BaseImageInfoBuildItem(baseJvmImage));
        Optional<S2iBaseJavaImage> baseImage = S2iBaseJavaImage.findMatching(baseJvmImage);
        baseImage.ifPresent(b -> {
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getJarEnvVar(), (String)pathToJar, (String)OPENSHIFT, (boolean[])new boolean[0]));
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getJarLibEnvVar(), (String)S2iProcessor.concatUnixPaths(jarDirectory, "lib"), (String)OPENSHIFT, (boolean[])new boolean[0]));
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getClasspathEnvVar(), (String)classpath, (String)OPENSHIFT, (boolean[])new boolean[0]));
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getJvmOptionsEnvVar(), (String)String.join((CharSequence)" ", s2iConfig.jvmArguments), (String)OPENSHIFT, (boolean[])new boolean[0]));
        });
        if (!baseImage.isPresent()) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("java");
            cmd.addAll(s2iConfig.jvmArguments);
            cmd.addAll(Arrays.asList("-jar", pathToJar, "-cp", classpath));
            commandProducer.produce((BuildItem)KubernetesCommandBuildItem.command(cmd));
        }
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, S2iBuild.class, NativeBuild.class})
    public void s2iRequirementsNative(S2iConfig s2iConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem out, PackageConfig packageConfig, NativeImageBuildItem nativeImage, BuildProducer<KubernetesEnvBuildItem> envProducer, BuildProducer<BaseImageInfoBuildItem> builderImageProducer, BuildProducer<KubernetesCommandBuildItem> commandProducer) {
        boolean usingDefaultBuilder = ImageUtil.getRepository((String)"quay.io/quarkus/ubi-quarkus-native-binary-s2i:1.0").equals(ImageUtil.getRepository((String)s2iConfig.baseNativeImage));
        String outputNativeBinaryFileName = nativeImage.getPath().getFileName().toString();
        String nativeBinaryFileName = null;
        nativeBinaryFileName = usingDefaultBuilder && !s2iConfig.nativeBinaryFileName.isPresent() ? "application" : s2iConfig.nativeBinaryFileName.orElse(outputNativeBinaryFileName);
        String pathToNativeBinary = S2iProcessor.concatUnixPaths(s2iConfig.nativeBinaryDirectory, nativeBinaryFileName);
        builderImageProducer.produce((BuildItem)new BaseImageInfoBuildItem(s2iConfig.baseNativeImage));
        Optional<S2iBaseNativeImage> baseImage = S2iBaseNativeImage.findMatching(s2iConfig.baseNativeImage);
        List nativeArguments = s2iConfig.nativeArguments.orElse(Collections.emptyList());
        baseImage.ifPresent(b -> {
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getHomeDirEnvVar(), (String)s2iConfig.nativeBinaryDirectory, (String)OPENSHIFT, (boolean[])new boolean[0]));
            envProducer.produce((BuildItem)KubernetesEnvBuildItem.createSimpleVar((String)b.getOptsEnvVar(), (String)String.join((CharSequence)" ", nativeArguments), (String)OPENSHIFT, (boolean[])new boolean[0]));
        });
        if (!baseImage.isPresent()) {
            commandProducer.produce((BuildItem)KubernetesCommandBuildItem.commandWithArgs((String)pathToNativeBinary, nativeArguments));
        }
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, S2iBuild.class}, onlyIfNot={NativeBuild.class})
    public void s2iBuildFromJar(S2iConfig s2iConfig, ContainerImageConfig containerImageConfig, KubernetesClientBuildItem kubernetesClient, ContainerImageInfoBuildItem containerImage, ArchiveRootBuildItem archiveRoot, OutputTargetBuildItem out, PackageConfig packageConfig, List<GeneratedFileSystemResourceBuildItem> generatedResources, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, JarBuildItem jar) {
        if (containerImageConfig.isBuildExplicitlyDisabled()) {
            return;
        }
        if (!(containerImageConfig.isBuildExplicitlyEnabled() || containerImageConfig.isPushExplicitlyEnabled() || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        Optional<GeneratedFileSystemResourceBuildItem> openshiftYml = generatedResources.stream().filter(r -> r.getName().endsWith("kubernetes" + File.separator + "openshift.yml")).findFirst();
        if (openshiftYml.isEmpty()) {
            LOG.warn((Object)"No Openshift manifests were generated so no s2i process will be taking place");
            return;
        }
        String namespace = Optional.ofNullable(kubernetesClient.getClient().getNamespace()).orElse("default");
        LOG.info((Object)("Performing s2i binary build with jar on server: " + kubernetesClient.getClient().getMasterUrl() + " in namespace:" + namespace + "."));
        S2iProcessor.createContainerImage(kubernetesClient, openshiftYml.get(), s2iConfig, out.getOutputDirectory(), jar.getPath(), out.getOutputDirectory().resolve("lib"));
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "jar-container", Collections.emptyMap()));
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, S2iBuild.class, NativeBuild.class})
    public void s2iBuildFromNative(S2iConfig s2iConfig, ContainerImageConfig containerImageConfig, KubernetesClientBuildItem kubernetesClient, ContainerImageInfoBuildItem containerImage, ArchiveRootBuildItem archiveRoot, OutputTargetBuildItem out, PackageConfig packageConfig, List<GeneratedFileSystemResourceBuildItem> generatedResources, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, NativeImageBuildItem nativeImage) {
        if (containerImageConfig.isBuildExplicitlyDisabled()) {
            return;
        }
        if (!(containerImageConfig.isBuildExplicitlyEnabled() || containerImageConfig.isPushExplicitlyEnabled() || buildRequest.isPresent() || pushRequest.isPresent())) {
            return;
        }
        String namespace = Optional.ofNullable(kubernetesClient.getClient().getNamespace()).orElse("default");
        LOG.info((Object)("Performing s2i binary build with native image on server: " + kubernetesClient.getClient().getMasterUrl() + " in namespace:" + namespace + "."));
        Optional<GeneratedFileSystemResourceBuildItem> openshiftYml = generatedResources.stream().filter(r -> r.getName().endsWith("kubernetes" + File.separator + "openshift.yml")).findFirst();
        if (openshiftYml.isEmpty()) {
            LOG.warn((Object)"No Openshift manifests were generated so no s2i process will be taking place");
            return;
        }
        S2iProcessor.createContainerImage(kubernetesClient, openshiftYml.get(), s2iConfig, out.getOutputDirectory(), nativeImage.getPath());
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "native-container", Collections.emptyMap()));
    }

    public static void createContainerImage(KubernetesClientBuildItem kubernetesClient, GeneratedFileSystemResourceBuildItem openshiftManifests, S2iConfig s2iConfig, Path output, Path ... additional) {
        File tar;
        try {
            File original = PackageUtil.packageFile(output, additional);
            tar = Files.createTempFile("quarkus-", "-s2i", new FileAttribute[0]).toFile();
            Files.move(original.toPath(), tar.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating the s2i binary build archive.", e);
        }
        Config config = kubernetesClient.getClient().getConfiguration();
        config.setHttp2Disable(true);
        try (KubernetesClient client = Clients.fromConfig((Object)config);){
            OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            KubernetesList kubernetesList = Serialization.unmarshalAsList((InputStream)new ByteArrayInputStream(openshiftManifests.getData()));
            List<HasMetadata> buildResources = kubernetesList.getItems().stream().filter(i -> i instanceof BuildConfig || i instanceof ImageStream || i instanceof Secret).collect(Collectors.toList());
            S2iProcessor.applyS2iResources(openShiftClient, buildResources);
            S2iProcessor.s2iBuild(openShiftClient, buildResources, tar, s2iConfig);
        }
    }

    private static void applyS2iResources(OpenShiftClient client, List<HasMetadata> buildResources) {
        try {
            for (HasMetadata i : S2iProcessor.distinct(buildResources)) {
                if (i instanceof BuildConfig) {
                    ((Deletable)client.resource(i).cascading(true)).delete();
                    try {
                        client.resource(i).waitUntilCondition(d -> d == null, 10L, TimeUnit.SECONDS);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (i instanceof ImageStream) {
                    ImageStream is = (ImageStream)i;
                    ImageStream existing = (ImageStream)((Resource)client.imageStreams().withName(i.getMetadata().getName())).get();
                    if (existing != null && existing.getSpec() != null && existing.getSpec().getDockerImageRepository() != null && existing.getSpec().getDockerImageRepository().equals(is.getSpec().getDockerImageRepository())) {
                        LOG.info((Object)("Found: " + i.getKind() + " " + i.getMetadata().getName() + " repository: " + existing.getSpec().getDockerImageRepository()));
                        continue;
                    }
                }
                client.resource(i).createOrReplace();
                LOG.info((Object)("Applied: " + i.getKind() + " " + i.getMetadata().getName()));
            }
            S2iUtils.waitForImageStreamTags(client, buildResources, 2L, TimeUnit.MINUTES);
        }
        catch (KubernetesClientException e) {
            KubernetesClientErrorHandler.handle((Exception)((Object)e));
        }
    }

    private static void s2iBuild(OpenShiftClient client, List<HasMetadata> buildResources, File binaryFile, S2iConfig s2iConfig) {
        S2iProcessor.distinct(buildResources).stream().filter(i -> i instanceof BuildConfig).map(i -> (BuildConfig)i).forEach(bc -> S2iProcessor.s2iBuild(client, bc, binaryFile, s2iConfig));
    }

    private static void s2iBuild(OpenShiftClient client, BuildConfig buildConfig, File binaryFile, S2iConfig s2iConfig) {
        Build build;
        try {
            build = (Build)((InputStreamable)((BuildConfigResource)client.buildConfigs().withName(buildConfig.getMetadata().getName())).instantiateBinary().withTimeoutInMillis(s2iConfig.buildTimeout.toMillis())).fromFile(binaryFile);
        }
        catch (Exception e) {
            Optional<Build> running = S2iProcessor.runningBuildsOf(client, buildConfig).findFirst();
            if (running.isPresent()) {
                LOG.warn((Object)("An exception: '" + e.getMessage() + " ' occurred while instantiating the build, however the build has been started."));
                build = running.get();
            }
            throw S2iProcessor.s2iException(e);
        }
        String buildName = build.getMetadata().getName();
        try (LogWatch w = (LogWatch)((Loggable)((BuildResource)client.builds().withName(build.getMetadata().getName())).withPrettyOutput()).watchLog();
             BufferedReader reader = new BufferedReader(new InputStreamReader(w.getOutput()));){
            S2iProcessor.waitForBuildComplete(client, s2iConfig, buildName, (Closeable)w);
            String line = reader.readLine();
            while (line != null) {
                LOG.info((Object)line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw S2iProcessor.s2iException(e);
        }
    }

    private static void waitForBuildComplete(OpenShiftClient client, S2iConfig s2iConfig, String buildName, Closeable watch) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            try {
                ((BuildResource)client.builds().withName(buildName)).waitUntilCondition(b -> !RUNNING.equalsIgnoreCase(b.getStatus().getPhase()), s2iConfig.buildTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            finally {
                try {
                    watch.close();
                }
                catch (IOException e) {
                    LOG.debug((Object)"Error closing log reader.");
                }
            }
        });
    }

    public static Predicate<HasMetadata> distictByResourceKey() {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(t.getApiVersion() + "/" + t.getKind() + ":" + t.getMetadata().getName(), Boolean.TRUE) == null;
    }

    private static Collection<HasMetadata> distinct(Collection<HasMetadata> resources) {
        return resources.stream().filter(S2iProcessor.distictByResourceKey()).collect(Collectors.toList());
    }

    private static List<Build> buildsOf(OpenShiftClient client, BuildConfig config) {
        return ((BuildList)((FilterWatchListDeletable)client.builds().withLabel(BUILD_CONFIG_NAME, config.getMetadata().getName())).list()).getItems();
    }

    private static Stream<Build> runningBuildsOf(OpenShiftClient client, BuildConfig config) {
        return S2iProcessor.buildsOf(client, config).stream().filter(b -> RUNNING.equalsIgnoreCase(b.getStatus().getPhase()));
    }

    private static RuntimeException s2iException(Throwable t) {
        if (t instanceof KubernetesClientException) {
            KubernetesClientErrorHandler.handle((Exception)((Object)((KubernetesClientException)t)));
        }
        return new RuntimeException("Execution of s2i build failed. See s2i output for more details", t);
    }

    static String concatUnixPaths(String ... elements) {
        StringBuilder result = new StringBuilder();
        for (String element : elements) {
            if (element.endsWith("/")) {
                element = element.substring(0, element.length() - 1);
            }
            if (element.isEmpty()) continue;
            if (!element.startsWith("/") && result.length() > 0) {
                result.append('/');
            }
            result.append(element);
        }
        return result.toString();
    }
}

