/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.docker.common.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.EnablementUtil;
import io.quarkus.container.image.deployment.util.NativeBinaryUtil;
import io.quarkus.container.image.docker.common.deployment.CommonConfig;
import io.quarkus.container.image.docker.common.deployment.DockerFileBaseInformationProvider;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageBuilderBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.util.PathsUtil;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.ContainerRuntimeStatusBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.deployment.util.ExecUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;

public abstract class CommonProcessor<C extends CommonConfig> {
    private static final Logger LOGGER = Logger.getLogger(CommonProcessor.class);
    protected static final String DOCKERFILE_JVM = "Dockerfile.jvm";
    protected static final String DOCKERFILE_LEGACY_JAR = "Dockerfile.legacy-jar";
    protected static final String DOCKERFILE_NATIVE = "Dockerfile.native";
    protected static final String DOCKER_DIRECTORY_NAME = "docker";

    protected abstract String getProcessorImplementation();

    protected abstract String createContainerImage(ContainerImageConfig var1, C var2, ContainerImageInfoBuildItem var3, OutputTargetBuildItem var4, DockerfilePaths var5, boolean var6, boolean var7, PackageConfig var8, String var9);

    protected void buildFromJar(C config, ContainerRuntimeStatusBuildItem containerRuntimeStatusBuildItem, ContainerImageConfig containerImageConfig, OutputTargetBuildItem out, ContainerImageInfoBuildItem containerImageInfo, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder, PackageConfig packageConfig, ContainerRuntimeUtil.ContainerRuntime ... containerRuntimes) {
        boolean buildContainerImage = EnablementUtil.buildContainerImageNeeded((ContainerImageConfig)containerImageConfig, buildRequest);
        boolean pushContainerImage = EnablementUtil.pushContainerImageNeeded((ContainerImageConfig)containerImageConfig, pushRequest);
        if (buildContainerImage || pushContainerImage) {
            if (!containerRuntimeStatusBuildItem.isContainerRuntimeAvailable()) {
                throw new RuntimeException("Unable to build container image. Please check your %s installation.".formatted(this.getProcessorImplementation()));
            }
            DockerfilePaths dockerfilePaths = this.getDockerfilePaths(config, false, packageConfig, out);
            Optional<DockerFileBaseInformationProvider.DockerFileBaseInformation> dockerfileBaseInformation = DockerFileBaseInformationProvider.impl().determine(dockerfilePaths.dockerfilePath());
            if (dockerfileBaseInformation.isPresent() && dockerfileBaseInformation.get().javaVersion() < 17) {
                throw new IllegalStateException("The project is built with Java 17 or higher, but the selected Dockerfile (%s) is using a lower Java version in the base image (%s). Please ensure you are using the proper base image in the Dockerfile.".formatted(dockerfilePaths.dockerfilePath().toAbsolutePath(), dockerfileBaseInformation.get().baseImage()));
            }
            if (buildContainerImage) {
                LOGGER.infof("Starting (local) container image build for jar using %s", (Object)this.getProcessorImplementation());
            }
            String executableName = this.getExecutableName(config, containerRuntimes);
            String builtContainerImage = this.createContainerImage(containerImageConfig, config, containerImageInfo, out, dockerfilePaths, buildContainerImage, pushContainerImage, packageConfig, executableName);
            artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "jar-container", Map.of("container-image", builtContainerImage, "pull-required", "false")));
            containerImageBuilder.produce((BuildItem)new ContainerImageBuilderBuildItem(this.getProcessorImplementation()));
        }
    }

    protected void buildFromNativeImage(C config, ContainerRuntimeStatusBuildItem containerRuntimeStatusBuildItem, ContainerImageConfig containerImageConfig, ContainerImageInfoBuildItem containerImage, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, OutputTargetBuildItem out, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder, PackageConfig packageConfig, NativeImageBuildItem nativeImage, ContainerRuntimeUtil.ContainerRuntime ... containerRuntimes) {
        boolean buildContainerImage = EnablementUtil.buildContainerImageNeeded((ContainerImageConfig)containerImageConfig, buildRequest);
        boolean pushContainerImage = EnablementUtil.pushContainerImageNeeded((ContainerImageConfig)containerImageConfig, pushRequest);
        if (buildContainerImage || pushContainerImage) {
            if (!containerRuntimeStatusBuildItem.isContainerRuntimeAvailable()) {
                throw new RuntimeException("Unable to build container image. Please check your %s installation.".formatted(this.getProcessorImplementation()));
            }
            if (!NativeBinaryUtil.nativeIsLinuxBinary((NativeImageBuildItem)nativeImage)) {
                throw new RuntimeException("The native binary produced by the build is not a Linux binary and therefore cannot be used in a Linux container image. Consider adding \"quarkus.native.container-build=true\" to your configuration.");
            }
            if (buildContainerImage) {
                LOGGER.infof("Starting (local) container image build for jar using %s", (Object)this.getProcessorImplementation());
            }
            String executableName = this.getExecutableName(config, containerRuntimes);
            DockerfilePaths dockerfilePaths = this.getDockerfilePaths(config, true, packageConfig, out);
            String builtContainerImage = this.createContainerImage(containerImageConfig, config, containerImage, out, dockerfilePaths, buildContainerImage, pushContainerImage, packageConfig, executableName);
            artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "native-container", Map.of("container-image", builtContainerImage, "pull-required", "false")));
            containerImageBuilder.produce((BuildItem)new ContainerImageBuilderBuildItem(this.getProcessorImplementation()));
        }
    }

    protected void loginToRegistryIfNeeded(ContainerImageConfig containerImageConfig, ContainerImageInfoBuildItem containerImageInfo, String executableName) {
        boolean loginSuccessful;
        String registry = containerImageInfo.getRegistry().orElseGet(() -> {
            LOGGER.info((Object)"No container image registry was set, so 'docker.io' will be used");
            return "docker.io";
        });
        if (containerImageConfig.username().isPresent() && containerImageConfig.password().isPresent() && !(loginSuccessful = ExecUtil.exec((String)executableName, (String[])new String[]{"login", registry, "-u", (String)containerImageConfig.username().get(), "-p", (String)containerImageConfig.password().get()}))) {
            throw this.containerRuntimeException(executableName, new String[]{"-u", (String)containerImageConfig.username().get(), "-p", "********"});
        }
    }

    protected List<String> getContainerCommonBuildArgs(String image, DockerfilePaths dockerfilePaths, ContainerImageConfig containerImageConfig, C config, boolean addImageAsTag) {
        ArrayList<String> args = new ArrayList<String>(6 + config.buildArgs().size() + config.additionalArgs().map(List::size).orElse(0));
        args.addAll(List.of("build", "-f", dockerfilePaths.dockerfilePath().toAbsolutePath().toString()));
        config.buildArgs().forEach((k, v) -> args.addAll(List.of("--build-arg", "%s=%s".formatted(k, v))));
        containerImageConfig.labels().forEach((k, v) -> args.addAll(List.of("--label", "%s=%s".formatted(k, v))));
        config.cacheFrom().filter(cacheFrom -> !cacheFrom.isEmpty()).ifPresent(cacheFrom -> args.addAll(List.of("--cache-from", String.join((CharSequence)",", cacheFrom))));
        config.network().ifPresent(network -> args.addAll(List.of("--network", network)));
        config.additionalArgs().ifPresent(args::addAll);
        if (addImageAsTag) {
            args.addAll(List.of("-t", image));
        }
        return args;
    }

    protected void createAdditionalTags(String image, List<String> additionalImageTags, String executableName) {
        additionalImageTags.stream().map(additionalTag -> new String[]{"tag", image, additionalTag}).forEach(tagArgs -> {
            LOGGER.infof("Running '%s %s'", (Object)executableName, (Object)String.join((CharSequence)" ", tagArgs));
            boolean tagSuccessful = ExecUtil.exec((String)executableName, (String[])tagArgs);
            if (!tagSuccessful) {
                throw this.containerRuntimeException(executableName, (String[])tagArgs);
            }
        });
    }

    protected void pushImages(ContainerImageInfoBuildItem containerImageInfo, String executableName, C config) {
        ArrayList<String> imagesToPush = new ArrayList<String>(1 + containerImageInfo.getAdditionalImageTags().size());
        imagesToPush.add(containerImageInfo.getImage());
        imagesToPush.addAll(containerImageInfo.getAdditionalImageTags());
        for (String image : imagesToPush) {
            this.pushImage(image, executableName, config);
        }
    }

    protected void pushImage(String image, String executableName, C config) {
        String[] pushArgs = this.createPushArgs(image, config);
        boolean pushSuccessful = ExecUtil.exec((String)executableName, (String[])pushArgs);
        if (!pushSuccessful) {
            throw this.containerRuntimeException(executableName, pushArgs);
        }
        LOGGER.infof("Successfully pushed %s image %s", (Object)this.getProcessorImplementation(), (Object)image);
    }

    protected String[] createPushArgs(String image, C config) {
        return new String[]{"push", image};
    }

    protected void buildImage(ContainerImageInfoBuildItem containerImageInfo, OutputTargetBuildItem out, String executableName, String[] args, boolean createAdditionalTags) {
        LOGGER.infof("Executing the following command to build image: '%s %s'", (Object)executableName, (Object)String.join((CharSequence)" ", args));
        boolean buildSuccessful = ExecUtil.exec((File)out.getOutputDirectory().toFile(), (String)executableName, (String[])args);
        if (!buildSuccessful) {
            throw this.containerRuntimeException(executableName, args);
        }
        if (createAdditionalTags && !containerImageInfo.getAdditionalImageTags().isEmpty()) {
            this.createAdditionalTags(containerImageInfo.getImage(), containerImageInfo.getAdditionalImageTags(), executableName);
        }
    }

    protected RuntimeException containerRuntimeException(String executableName, String[] args) {
        return new RuntimeException("Execution of '%s %s' failed. See %s output for more details".formatted(executableName, String.join((CharSequence)" ", args), this.getProcessorImplementation()));
    }

    protected String getExecutableName(C config, ContainerRuntimeUtil.ContainerRuntime ... containerRuntimes) {
        return config.executableName().orElseGet(() -> ContainerRuntimeUtil.detectContainerRuntime((ContainerRuntimeUtil.ContainerRuntime[])containerRuntimes).getExecutableName());
    }

    private DockerfilePaths getDockerfilePaths(C config, boolean forNative, PackageConfig packageConfig, OutputTargetBuildItem out) {
        Path outputDirectory = out.getOutputDirectory();
        if (forNative) {
            return config.dockerfileNativePath().map(dockerfileNativePath -> ProvidedDockerfile.get(Paths.get(dockerfileNativePath, new String[0]), outputDirectory)).orElseGet(() -> DockerfileDetectionResult.detect(DOCKERFILE_NATIVE, outputDirectory));
        }
        return config.dockerfileJvmPath().map(dockerfileJvmPath -> ProvidedDockerfile.get(Paths.get(dockerfileJvmPath, new String[0]), outputDirectory)).orElseGet(() -> packageConfig.jar().type() == PackageConfig.JarConfig.JarType.LEGACY_JAR ? DockerfileDetectionResult.detect(DOCKERFILE_LEGACY_JAR, outputDirectory) : DockerfileDetectionResult.detect(DOCKERFILE_JVM, outputDirectory));
    }

    protected static interface DockerfilePaths {
        public Path dockerfilePath();

        public Path dockerExecutionPath();
    }

    protected record DockerfileDetectionResult(Path dockerfilePath, Path dockerExecutionPath) implements DockerfilePaths
    {
        protected static DockerfilePaths detect(String resource, Path outputDirectory) {
            Map.Entry<Path, Path> dockerfileToExecutionRoot = DockerfileDetectionResult.findDockerfileRoot(outputDirectory);
            if (dockerfileToExecutionRoot == null) {
                throw new IllegalStateException("Unable to find root of Dockerfile files. Consider adding 'src/main/docker/' to your project root.");
            }
            Path dockerFilePath = dockerfileToExecutionRoot.getKey().resolve(resource);
            if (!Files.exists(dockerFilePath, new LinkOption[0])) {
                throw new IllegalStateException("Unable to find Dockerfile %s in %s".formatted(resource, dockerfileToExecutionRoot.getKey().toAbsolutePath()));
            }
            return new DockerfileDetectionResult(dockerFilePath, dockerfileToExecutionRoot.getValue());
        }

        private static Map.Entry<Path, Path> findDockerfileRoot(Path outputDirectory) {
            AbstractMap.SimpleEntry mainSourcesRoot = PathsUtil.findMainSourcesRoot((Path)outputDirectory);
            if (mainSourcesRoot == null) {
                return null;
            }
            Path dockerfilesRoot = ((Path)mainSourcesRoot.getKey()).resolve(CommonProcessor.DOCKER_DIRECTORY_NAME);
            if (!dockerfilesRoot.toFile().exists()) {
                return null;
            }
            return new AbstractMap.SimpleEntry<Path, Path>(dockerfilesRoot, (Path)mainSourcesRoot.getValue());
        }
    }

    protected record ProvidedDockerfile(Path dockerfilePath, Path dockerExecutionPath) implements DockerfilePaths
    {
        protected static DockerfilePaths get(Path dockerfilePath, Path outputDirectory) {
            Path effectiveDockerfilePath;
            AbstractMap.SimpleEntry mainSourcesRoot = PathsUtil.findMainSourcesRoot((Path)outputDirectory);
            if (mainSourcesRoot == null) {
                throw new IllegalStateException("Unable to determine project root");
            }
            Path executionPath = (Path)mainSourcesRoot.getValue();
            Path path = effectiveDockerfilePath = dockerfilePath.isAbsolute() ? dockerfilePath : executionPath.resolve(dockerfilePath);
            if (!effectiveDockerfilePath.toFile().exists()) {
                throw new IllegalArgumentException("Specified Dockerfile path %s does not exist".formatted(effectiveDockerfilePath.toAbsolutePath()));
            }
            return new ProvidedDockerfile(effectiveDockerfilePath, executionPath);
        }
    }
}

