/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.confluent.registry.avro;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import org.jboss.logging.Logger;

public class ConfluentRegistryAvroProcessor {
    public static final String CONFLUENT_GROUP_ID = "io.confluent";
    public static final String CONFLUENT_ARTIFACT_ID = "kafka-avro-serializer";
    private static final Logger LOGGER = Logger.getLogger((String)ConfluentRegistryAvroProcessor.class.getName());
    public static final String CONFLUENT_REPO = "https://packages.confluent.io/maven/";
    public static final String GUIDE_URL = "https://quarkus.io/guides/kafka-schema-registry-avro";

    @BuildStep
    FeatureBuildItem featureAndCheckDependency(CurateOutcomeBuildItem cp) {
        if (this.findConfluentSerde(cp.getApplicationModel().getDependencies()).isEmpty()) {
            LOGGER.warnf("The application uses the `quarkus-confluent-registry-avro` extension, but does not depend on `%s:%s`. Note that this dependency is only available from the `%s` Maven repository. Check %s for more details.", new Object[]{CONFLUENT_GROUP_ID, CONFLUENT_ARTIFACT_ID, CONFLUENT_REPO, GUIDE_URL});
        }
        return new FeatureBuildItem(Feature.CONFLUENT_REGISTRY_AVRO);
    }

    @BuildStep
    public void confluentRegistryAvro(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.confluent.kafka.serializers.KafkaAvroDeserializer", "io.confluent.kafka.serializers.KafkaAvroSerializer"}).methods().build());
    }

    @BuildStep
    public void configureNative(BuildProducer<NativeImageConfigBuildItem> config, CurateOutcomeBuildItem cp) {
        Optional<ResolvedDependency> serde = this.findConfluentSerde(cp.getApplicationModel().getDependencies());
        if (serde.isPresent()) {
            String version = serde.get().getVersion();
            NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder();
            if (version.startsWith("7.1") || version.startsWith("7.2")) {
                builder.addRuntimeInitializedClass("io.confluent.kafka.schemaregistry.client.rest.utils.UrlList");
            }
            builder.addRuntimeInitializedClass("io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils");
            config.produce((BuildItem)builder.build());
        }
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem enableSslInNative() {
        return new ExtensionSslNativeSupportBuildItem(Feature.CONFLUENT_REGISTRY_AVRO);
    }

    private Optional<ResolvedDependency> findConfluentSerde(Collection<ResolvedDependency> dependencies) {
        return dependencies.stream().filter(new Predicate<ResolvedDependency>(){

            @Override
            public boolean test(ResolvedDependency rd) {
                return rd.getGroupId().equalsIgnoreCase(ConfluentRegistryAvroProcessor.CONFLUENT_GROUP_ID) && rd.getArtifactId().equalsIgnoreCase(ConfluentRegistryAvroProcessor.CONFLUENT_ARTIFACT_ID);
            }
        }).findAny();
    }
}

