/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.config.doc.generator;

import java.util.Set;

public enum Format {
    asciidoc("adoc", Set.of("default")),
    markdown("md", Set.of("default", "github"));

    public static final String DEFAULT_THEME = "default";
    private final String extension;
    private final Set<String> supportedThemes;

    private Format(String extension, Set<String> supportedThemes) {
        this.extension = extension;
        this.supportedThemes = supportedThemes;
    }

    public String getExtension() {
        return this.extension;
    }

    public String normalizeTheme(String theme) {
        return this.supportedThemes.contains(theme = theme.trim()) ? theme : DEFAULT_THEME;
    }

    public static Format normalizeFormat(String format) {
        format = format.trim();
        return Format.valueOf(format);
    }
}

