/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.config.doc.generator;

import io.quarkus.annotation.processor.documentation.config.merger.JavadocRepository;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.JavadocFormat;
import io.quarkus.maven.config.doc.GenerateConfigDocMojo;
import io.quarkus.maven.config.doc.generator.AbstractFormatter;
import io.quarkus.maven.config.doc.generator.GenerationReport;

final class MarkdownFormatter
extends AbstractFormatter {
    private static final String MORE_INFO_ABOUT_TYPE_FORMAT = "[\ud83d\udec8](#%s)";

    MarkdownFormatter(GenerationReport generationReport, JavadocRepository javadocRepository) {
        super(generationReport, javadocRepository, false);
    }

    @Override
    protected JavadocFormat javadocFormat() {
        return JavadocFormat.MARKDOWN;
    }

    @Override
    public String formatSectionTitle(ConfigSection configSection) {
        return "&nbsp;".repeat(configSection.getLevel() * 4) + super.formatSectionTitle(configSection);
    }

    @Override
    protected String moreInformationAboutType(GenerateConfigDocMojo.Context context, String anchorRoot, String type) {
        return MORE_INFO_ABOUT_TYPE_FORMAT.formatted(anchorRoot);
    }

    @Override
    protected String link(String href, String description) {
        return String.format("[%2$s](%1$s)", href, description);
    }

    @Override
    protected String tooltip(String value, String javadocDescription) {
        return "`" + value + "`";
    }
}

