/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.config.doc.generator;

import io.quarkus.annotation.processor.documentation.config.model.SourceElementType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GenerationReport {
    private Map<String, List<GenerationViolation>> violations = new LinkedHashMap<String, List<GenerationViolation>>();

    void addError(GenerationViolation error) {
        this.violations.computeIfAbsent(error.sourceType(), k -> new ArrayList()).add(error);
    }

    public Map<String, List<GenerationViolation>> getViolations() {
        return this.violations;
    }

    public static interface GenerationViolation {
        public String sourceType();

        public String sourceElement();

        public String message();
    }

    public record ConfigPropertyGenerationViolation(String sourceType, String sourceElement, SourceElementType sourceElementType, String message) implements GenerationViolation
    {
        private final String sourceElement;

        @Override
        public String sourceElement() {
            return this.sourceElement + (this.sourceElementType == SourceElementType.METHOD ? "()" : "");
        }
    }
}

