/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.cli.build.BuildSystemRunner;
import io.quarkus.qute.CheckedTemplate;
import io.quarkus.qute.TemplateInstance;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@CheckedTemplate(basePath="")
public class BuildReport {
    private final BuildSystemRunner runner;

    static native TemplateInstance buildReport(String var0, long var1, Set<String> var3, List<BuildStepRecord> var4, List<BuildItem> var5, int var6);

    public BuildReport(BuildSystemRunner runner) {
        this.runner = runner;
    }

    File generate() throws IOException {
        File metricsJsonFile = this.runner.getProjectRoot().resolve(this.runner.getBuildTool().getBuildDirectory()).resolve("build-metrics.json").toFile();
        if (!metricsJsonFile.canRead()) {
            throw new IllegalStateException("Build metrics file cannot be read: " + String.valueOf(metricsJsonFile));
        }
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode root = objectMapper.readTree(metricsJsonFile);
        String buildTarget = root.get("buildTarget").asText();
        long duration = root.get("duration").asLong();
        HashSet<String> threads = new HashSet<String>();
        ArrayList<BuildStepRecord> records = new ArrayList<BuildStepRecord>();
        ArrayList<BuildItem> items = new ArrayList<BuildItem>();
        int itemsCount = root.get("itemsCount").asInt();
        for (JsonNode record : root.get("records")) {
            String thread = record.get("thread").asText();
            threads.add(thread);
            records.add(new BuildStepRecord(record.get("stepId").asText(), record.get("started").asText(), record.get("duration").asLong(), thread));
        }
        for (JsonNode item : root.get("items")) {
            items.add(new BuildItem(item.get("class").asText(), item.get("count").asInt()));
        }
        File output = this.runner.getProjectRoot().resolve(this.runner.getBuildTool().getBuildDirectory()).resolve("build-report.html").toFile();
        if (output.exists() && !output.canWrite()) {
            throw new IllegalStateException("Build report file cannot be written to: " + String.valueOf(output));
        }
        try {
            Files.writeString(output.toPath(), (CharSequence)BuildReport.buildReport(buildTarget, duration, threads, records, items, itemsCount).render(), new OpenOption[0]);
            return output;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class BuildStepRecord {
        public final String stepId;
        public final String started;
        public final long duration;
        public final String thread;

        public BuildStepRecord(String stepId, String started, long duration, String thread) {
            this.stepId = stepId;
            this.started = started;
            this.duration = duration;
            this.thread = thread;
        }
    }

    public static class BuildItem {
        public final String clazz;
        public final int count;

        public BuildItem(String clazz, int count) {
            this.clazz = clazz;
            this.count = count;
        }
    }
}

