/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.CacheManager;
import io.quarkus.cache.CacheManagerInfo;
import io.quarkus.cache.runtime.CacheBuildConfig;
import io.quarkus.cache.runtime.CacheConfig;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheManagerBuilder;
import io.quarkus.cache.runtime.noop.NoOpCacheManagerBuilder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;

@Recorder
public class CacheManagerRecorder {
    private final CacheBuildConfig cacheBuildConfig;
    private final RuntimeValue<CacheConfig> cacheConfigRV;

    public CacheManagerRecorder(CacheBuildConfig cacheBuildConfig, RuntimeValue<CacheConfig> cacheConfigRV) {
        this.cacheBuildConfig = cacheBuildConfig;
        this.cacheConfigRV = cacheConfigRV;
    }

    public Supplier<CacheManager> resolveCacheInfo(Collection<CacheManagerInfo> infos, final Set<String> cacheNames, final boolean micrometerMetricsEnabled) {
        final CacheConfig cacheConfig = (CacheConfig)this.cacheConfigRV.getValue();
        CacheManagerInfo.Context context = new CacheManagerInfo.Context(){

            public boolean cacheEnabled() {
                return cacheConfig.enabled();
            }

            public CacheManagerInfo.Context.Metrics metrics() {
                return micrometerMetricsEnabled ? CacheManagerInfo.Context.Metrics.MICROMETER : CacheManagerInfo.Context.Metrics.NONE;
            }

            public String cacheType() {
                return CacheManagerRecorder.this.cacheBuildConfig.type();
            }

            public Set<String> cacheNames() {
                return cacheNames;
            }
        };
        for (CacheManagerInfo info : infos) {
            if (!info.supports(context)) continue;
            return info.get(context);
        }
        throw new DeploymentException("Unknown cache type: " + context.cacheType());
    }

    public CacheManagerInfo noOpCacheManagerInfo() {
        return new CacheManagerInfo(){

            public boolean supports(CacheManagerInfo.Context context) {
                return !context.cacheEnabled();
            }

            public Supplier<CacheManager> get(CacheManagerInfo.Context context) {
                return NoOpCacheManagerBuilder.build(context.cacheNames());
            }
        };
    }

    public CacheManagerInfo getCacheManagerInfoWithMicrometerMetrics() {
        return new CacheManagerInfo(){

            public boolean supports(CacheManagerInfo.Context context) {
                return context.cacheEnabled() && context.cacheType().equals("caffeine") && context.metrics() == CacheManagerInfo.Context.Metrics.MICROMETER;
            }

            public Supplier<CacheManager> get(CacheManagerInfo.Context context) {
                return CaffeineCacheManagerBuilder.buildWithMicrometerMetrics(context.cacheNames(), (CacheConfig)CacheManagerRecorder.this.cacheConfigRV.getValue());
            }
        };
    }

    public CacheManagerInfo getCacheManagerInfoWithoutMetrics() {
        return new CacheManagerInfo(){

            public boolean supports(CacheManagerInfo.Context context) {
                return context.cacheEnabled() && context.cacheType().equals("caffeine") && context.metrics() == CacheManagerInfo.Context.Metrics.NONE;
            }

            public Supplier<CacheManager> get(CacheManagerInfo.Context context) {
                return CaffeineCacheManagerBuilder.buildWithoutMetrics(context.cacheNames(), (CacheConfig)CacheManagerRecorder.this.cacheConfigRV.getValue());
            }
        };
    }
}

