/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.arc.AbstractAnnotationLiteral;
import io.quarkus.arc.runtime.InterceptorBindings;
import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheException;
import io.quarkus.cache.CacheKey;
import io.quarkus.cache.CacheKeyGenerator;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.CompositeCacheKey;
import io.quarkus.cache.runtime.CacheInterceptionContext;
import io.quarkus.cache.runtime.CacheKeyParameterPositions;
import io.quarkus.cache.runtime.UndefinedCacheKeyGenerator;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public abstract class CacheInterceptor {
    public static final int BASE_PRIORITY = 0;
    private static final Logger LOGGER = Logger.getLogger(CacheInterceptor.class);
    private static final String PERFORMANCE_WARN_MSG = "Cache key resolution based on reflection calls. Please create a GitHub issue in the Quarkus repository, the maintainers might be able to improve your application performance.";
    protected static final String UNHANDLED_ASYNC_RETURN_TYPE_MSG = "Unhandled async return type";
    @Inject
    CacheManager cacheManager;
    @Inject
    @Any
    Instance<CacheKeyGenerator> keyGenerator;

    protected <T> CacheInterceptionContext<T> getInterceptionContext(final InvocationContext invocationContext, final Class<T> interceptorBindingClass, final boolean supportsCacheKey) {
        return this.getArcCacheInterceptionContext(invocationContext, interceptorBindingClass).orElseGet(new Supplier<CacheInterceptionContext<T>>(){

            @Override
            public CacheInterceptionContext<T> get() {
                return CacheInterceptor.this.getNonArcCacheInterceptionContext(invocationContext, interceptorBindingClass, supportsCacheKey);
            }
        });
    }

    private <T> Optional<CacheInterceptionContext<T>> getArcCacheInterceptionContext(InvocationContext invocationContext, Class<T> interceptorBindingClass) {
        Set bindings = InterceptorBindings.getInterceptorBindingLiterals((InvocationContext)invocationContext);
        if (bindings == null || bindings.isEmpty() || !(bindings.iterator().next() instanceof AbstractAnnotationLiteral)) {
            LOGGER.trace((Object)"Interceptor bindings not found in ArC or not created by ArC");
            return Optional.empty();
        }
        ArrayList<AbstractAnnotationLiteral> interceptorBindings = new ArrayList<AbstractAnnotationLiteral>();
        ArrayList<Short> cacheKeyParameterPositions = new ArrayList<Short>();
        for (AbstractAnnotationLiteral binding : bindings) {
            if (binding.annotationType().isAssignableFrom(CacheKeyParameterPositions.class)) {
                for (short position : ((CacheKeyParameterPositions)binding).value()) {
                    cacheKeyParameterPositions.add(position);
                }
                continue;
            }
            if (!binding.annotationType().isAssignableFrom(interceptorBindingClass)) continue;
            interceptorBindings.add(binding);
        }
        return Optional.of(new CacheInterceptionContext(interceptorBindings, cacheKeyParameterPositions));
    }

    private <T> CacheInterceptionContext<T> getNonArcCacheInterceptionContext(InvocationContext invocationContext, Class<T> interceptorBindingClass, boolean supportsCacheKey) {
        LOGGER.trace((Object)"Retrieving interceptor bindings using reflection");
        ArrayList<Annotation> interceptorBindings = new ArrayList<Annotation>();
        ArrayList<Short> cacheKeyParameterPositions = new ArrayList<Short>();
        boolean cacheKeyParameterPositionsFound = false;
        for (Annotation annotation : invocationContext.getMethod().getAnnotations()) {
            if (annotation instanceof CacheKeyParameterPositions) {
                cacheKeyParameterPositionsFound = true;
                for (short position : ((CacheKeyParameterPositions)annotation).value()) {
                    cacheKeyParameterPositions.add(position);
                }
                continue;
            }
            if (!interceptorBindingClass.isInstance(annotation)) continue;
            interceptorBindings.add(annotation);
        }
        if (supportsCacheKey && !cacheKeyParameterPositionsFound) {
            LOGGER.warn((Object)PERFORMANCE_WARN_MSG);
            Parameter[] parameters = invocationContext.getMethod().getParameters();
            for (short i = 0; i < parameters.length; i = (short)(i + 1)) {
                if (!parameters[i].isAnnotationPresent(CacheKey.class)) continue;
                cacheKeyParameterPositions.add(i);
            }
        }
        return new CacheInterceptionContext(interceptorBindings, cacheKeyParameterPositions);
    }

    protected Object getCacheKey(Cache cache, Class<? extends CacheKeyGenerator> keyGeneratorClass, List<Short> cacheKeyParameterPositions, Method method, Object[] methodParameterValues) {
        if (keyGeneratorClass != UndefinedCacheKeyGenerator.class) {
            return this.generateKey(keyGeneratorClass, method, methodParameterValues);
        }
        if (methodParameterValues == null || methodParameterValues.length == 0) {
            return cache.getDefaultKey();
        }
        if (cacheKeyParameterPositions.size() == 1) {
            return methodParameterValues[cacheKeyParameterPositions.get(0)];
        }
        if (cacheKeyParameterPositions.size() >= 2) {
            ArrayList<Object> keyElements = new ArrayList<Object>();
            for (short position : cacheKeyParameterPositions) {
                keyElements.add(methodParameterValues[position]);
            }
            return new CompositeCacheKey(keyElements.toArray(new Object[0]));
        }
        if (methodParameterValues.length == 1) {
            return methodParameterValues[0];
        }
        return new CompositeCacheKey(methodParameterValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends CacheKeyGenerator> Object generateKey(Class<T> keyGeneratorClass, Method method, Object[] methodParameterValues) {
        Instance keyGenInstance = this.keyGenerator.select(keyGeneratorClass, new Annotation[0]);
        if (keyGenInstance.isResolvable()) {
            LOGGER.tracef("Using cache key generator bean from Arc [class=%s]", (Object)keyGeneratorClass.getName());
            Instance.Handle keyGen = keyGenInstance.getHandle();
            try {
                Object object = ((CacheKeyGenerator)keyGen.get()).generate(method, methodParameterValues);
                return object;
            }
            finally {
                Bean bean = keyGen.getBean();
                if (bean != null && Dependent.class.equals((Object)bean.getScope())) {
                    keyGen.destroy();
                }
            }
        }
        try {
            LOGGER.tracef("Creating a new cache key generator instance [class=%s]", (Object)keyGeneratorClass.getName());
            return ((CacheKeyGenerator)keyGeneratorClass.getConstructor(new Class[0]).newInstance(new Object[0])).generate(method, methodParameterValues);
        }
        catch (NoSuchMethodException e) {
            throw new CacheException("No default constructor found in cache key generator [class=" + keyGeneratorClass.getName() + "]", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new CacheException("Cache key generator instantiation failed", e);
        }
    }

    protected static ReturnType determineReturnType(Class<?> returnType) {
        if (Uni.class.isAssignableFrom(returnType)) {
            return ReturnType.Uni;
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return ReturnType.CompletionStage;
        }
        return ReturnType.NonAsync;
    }

    protected Uni<?> asyncInvocationResultToUni(final Object invocationResult, ReturnType returnType) {
        if (returnType == ReturnType.Uni) {
            return (Uni)invocationResult;
        }
        if (returnType == ReturnType.CompletionStage) {
            return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<? extends Object>>(){

                @Override
                public CompletionStage<?> get() {
                    return (CompletionStage)invocationResult;
                }
            });
        }
        throw new CacheException(new IllegalStateException(UNHANDLED_ASYNC_RETURN_TYPE_MSG));
    }

    protected Object createAsyncResult(Uni<Object> cacheValue, ReturnType returnType) {
        if (returnType == ReturnType.Uni) {
            return cacheValue;
        }
        if (returnType == ReturnType.CompletionStage) {
            return cacheValue.subscribeAsCompletionStage();
        }
        throw new CacheException(new IllegalStateException(UNHANDLED_ASYNC_RETURN_TYPE_MSG));
    }

    protected static enum ReturnType {
        NonAsync,
        Uni,
        CompletionStage;

    }
}

