/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.builder.Json;
import io.quarkus.builder.StepInfo;
import io.quarkus.builder.item.BuildItem;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;

public class BuildMetrics {
    static final Logger LOG = Logger.getLogger((String)BuildMetrics.class.getName());
    private volatile LocalDateTime started;
    private volatile long duration;
    private final String buildTargetName;
    private final ConcurrentMap<String, BuildStepRecord> records = new ConcurrentHashMap<String, BuildStepRecord>();
    private final ConcurrentMap<String, Integer> buildItems = new ConcurrentHashMap<String, Integer>();
    private final AtomicInteger idGenerator;

    public BuildMetrics(String buildTargetName) {
        this.buildTargetName = buildTargetName;
        this.idGenerator = new AtomicInteger();
    }

    public Collection<BuildStepRecord> getRecords() {
        return this.records.values();
    }

    public void buildStarted() {
        this.started = LocalDateTime.now().truncatedTo(ChronoUnit.MILLIS);
    }

    public void buildFinished(long duration) {
        this.duration = duration;
    }

    public void buildStepFinished(StepInfo stepInfo, String thread, LocalTime started, long duration) {
        this.records.put(stepInfo.getBuildStep().getId(), new BuildStepRecord(this.idGenerator.incrementAndGet(), stepInfo, thread, started, duration));
    }

    public void buildItemProduced(BuildItem buildItem) {
        this.buildItems.compute(buildItem.getClass().getName(), this::itemProduced);
    }

    private Integer itemProduced(String key, Integer val) {
        if (val == null) {
            return 1;
        }
        return val + 1;
    }

    public void dumpTo(Path file) throws IOException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
        ArrayList sortedSteps = new ArrayList(this.records.values());
        sortedSteps.sort(new Comparator<BuildStepRecord>(){

            @Override
            public int compare(BuildStepRecord o1, BuildStepRecord o2) {
                return Long.compare(o2.duration, o1.duration);
            }
        });
        Json.JsonObjectBuilder json = Json.object();
        json.put("buildTarget", this.buildTargetName);
        json.put("started", this.started.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        json.put("duration", this.duration);
        Json.JsonArrayBuilder steps = Json.array();
        json.put("records", steps);
        for (BuildStepRecord rec : sortedSteps) {
            Json.JsonObjectBuilder recObject = Json.object();
            recObject.put("id", rec.id);
            recObject.put("stepId", rec.stepInfo.getBuildStep().getId());
            recObject.put("thread", rec.thread);
            recObject.put("started", rec.started.format(formatter));
            recObject.put("duration", rec.duration);
            Json.JsonArrayBuilder dependentsArray = Json.array();
            for (StepInfo dependent : rec.stepInfo.getDependents()) {
                BuildStepRecord dependentRecord = (BuildStepRecord)this.records.get(dependent.getBuildStep().getId());
                if (dependentRecord != null) {
                    dependentsArray.add(dependentRecord.id);
                    continue;
                }
                LOG.warnf("Dependent record not found for stepId: %s", (Object)dependent.getBuildStep().getId());
            }
            recObject.put("dependents", dependentsArray);
            steps.add(recObject);
        }
        ArrayList<Map.Entry<String, Integer>> sortedItems = new ArrayList<Map.Entry<String, Integer>>(this.buildItems.size());
        this.buildItems.entrySet().forEach(sortedItems::add);
        sortedItems.sort(new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return Integer.compare(o2.getValue(), o1.getValue());
            }
        });
        Json.JsonArrayBuilder items = Json.array();
        json.put("items", items);
        Integer itemsCount = 0;
        for (Map.Entry entry : sortedItems) {
            Json.JsonObjectBuilder itemObject = Json.object();
            itemObject.put("class", (String)entry.getKey());
            itemObject.put("count", (Integer)entry.getValue());
            items.add(itemObject);
            itemsCount = itemsCount + (Integer)entry.getValue();
        }
        json.put("itemsCount", itemsCount);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file.toFile(), StandardCharsets.UTF_8));){
            json.appendTo(writer);
        }
    }

    public static class BuildStepRecord {
        public final int id;
        public final StepInfo stepInfo;
        public final String thread;
        public final LocalTime started;
        public final long duration;

        BuildStepRecord(int id, StepInfo stepInfo, String thread, LocalTime started, long duration) {
            this.id = id;
            this.stepInfo = stepInfo;
            this.thread = thread;
            this.started = started;
            this.duration = duration;
        }
    }
}

