/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.ClassLoadingResource;
import io.quarkus.bootstrap.runner.JarResource;
import io.quarkus.bootstrap.runner.ManifestInfo;
import io.quarkus.bootstrap.runner.RunnerClassLoader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class SerializedApplication {
    public static final String META_INF_VERSIONS = "META-INF/versions/";
    private static final List<String> FULLY_INDEXED_PATHS = List.of("", "META-INF/services");
    private static final int MAGIC = -265202638;
    private static final int VERSION = 2;
    private static final ClassLoadingResource[] EMPTY_ARRAY = new ClassLoadingResource[0];
    private static final JarResource SENTINEL = new JarResource(null, Path.of("wqxehxivam", new String[0]));
    private final RunnerClassLoader runnerClassLoader;
    private final String mainClass;

    public SerializedApplication(RunnerClassLoader runnerClassLoader, String mainClass) {
        this.runnerClassLoader = runnerClassLoader;
        this.mainClass = mainClass;
    }

    public RunnerClassLoader getRunnerClassLoader() {
        return this.runnerClassLoader;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public static void write(OutputStream outputStream, String mainClass, Path applicationRoot, List<Path> classPath, List<Path> parentFirst, List<String> nonExistentResources) throws IOException {
        try (DataOutputStream data = new DataOutputStream(outputStream);){
            data.writeInt(-265202638);
            data.writeInt(2);
            data.writeUTF(mainClass);
            data.writeShort(classPath.size());
            LinkedHashMap<String, List> directlyIndexedResourcesToCPJarIndex = new LinkedHashMap<String, List>();
            for (int i = 0; i < classPath.size(); ++i) {
                Path jar = classPath.get(i);
                String string = applicationRoot.relativize(jar).toString().replace('\\', '/');
                data.writeUTF(string);
                List<String> resources = SerializedApplication.writeJar(data, jar);
                for (String resource : resources) {
                    directlyIndexedResourcesToCPJarIndex.computeIfAbsent(resource, s -> new ArrayList()).add(i);
                }
            }
            HashSet<String> parentFirstPackages = new HashSet<String>();
            for (Path path : parentFirst) {
                SerializedApplication.collectPackages(path, parentFirstPackages);
            }
            data.writeShort(parentFirstPackages.size());
            for (String string : parentFirstPackages) {
                data.writeUTF(string.replace('/', '.').replace('\\', '.'));
            }
            data.writeShort(nonExistentResources.size());
            for (String string : nonExistentResources) {
                data.writeUTF(string);
            }
            data.writeShort(directlyIndexedResourcesToCPJarIndex.size());
            for (Map.Entry entry : directlyIndexedResourcesToCPJarIndex.entrySet()) {
                data.writeUTF((String)entry.getKey());
                data.writeShort(((List)entry.getValue()).size());
                for (Integer index : (List)entry.getValue()) {
                    data.writeShort(index);
                }
            }
            data.flush();
        }
    }

    public static SerializedApplication read(InputStream inputStream, Path appRoot) throws IOException {
        try (DataInputStream in = new DataInputStream(inputStream);){
            if (in.readInt() != -265202638) {
                throw new RuntimeException("Wrong magic number");
            }
            if (in.readInt() != 2) {
                throw new RuntimeException("Wrong class path version");
            }
            String mainClass = in.readUTF();
            ResourceDirectoryTracker resourceDirectoryTracker = new ResourceDirectoryTracker();
            HashSet<String> parentFirstPackages = new HashSet<String>();
            int numPaths = in.readUnsignedShort();
            ClassLoadingResource[] allClassLoadingResources = new ClassLoadingResource[numPaths];
            for (int pathCount = 0; pathCount < numPaths; ++pathCount) {
                String path = in.readUTF();
                boolean hasManifest = in.readBoolean();
                ManifestInfo info = null;
                if (hasManifest) {
                    info = new ManifestInfo(SerializedApplication.readNullableString(in), SerializedApplication.readNullableString(in), SerializedApplication.readNullableString(in), SerializedApplication.readNullableString(in), SerializedApplication.readNullableString(in), SerializedApplication.readNullableString(in));
                }
                JarResource resource = new JarResource(info, appRoot.resolve(path));
                allClassLoadingResources[pathCount] = resource;
                int numDirs = in.readUnsignedShort();
                for (int i = 0; i < numDirs; ++i) {
                    String dir = in.readUTF();
                    int j = dir.indexOf(47);
                    while (j >= 0) {
                        resourceDirectoryTracker.addResourceDir(dir.substring(0, j), resource);
                        j = dir.indexOf(47, j + 1);
                    }
                    resourceDirectoryTracker.addResourceDir(dir, resource);
                }
            }
            int packages = in.readUnsignedShort();
            for (int i = 0; i < packages; ++i) {
                parentFirstPackages.add(in.readUTF());
            }
            HashSet<String> nonExistentResources = new HashSet<String>();
            int nonExistentResourcesSize = in.readUnsignedShort();
            for (int i = 0; i < nonExistentResourcesSize; ++i) {
                nonExistentResources.add(in.readUTF());
            }
            HashMap<String, ClassLoadingResource[]> directlyIndexedResourcesIndexMap = new HashMap<String, ClassLoadingResource[]>();
            int directlyIndexedSize = in.readUnsignedShort();
            for (int i = 0; i < directlyIndexedSize; ++i) {
                String string = in.readUTF();
                int indexesSize = in.readUnsignedShort();
                ClassLoadingResource[] matchingResources = new ClassLoadingResource[indexesSize];
                for (int j = 0; j < indexesSize; ++j) {
                    matchingResources[j] = allClassLoadingResources[in.readUnsignedShort()];
                }
                directlyIndexedResourcesIndexMap.put(string, matchingResources);
            }
            RunnerClassLoader runnerClassLoader = new RunnerClassLoader(ClassLoader.getSystemClassLoader(), resourceDirectoryTracker.getResult(), parentFirstPackages, nonExistentResources, FULLY_INDEXED_PATHS, directlyIndexedResourcesIndexMap);
            for (ClassLoadingResource classLoadingResource : allClassLoadingResources) {
                classLoadingResource.init(runnerClassLoader);
            }
            SerializedApplication serializedApplication = new SerializedApplication(runnerClassLoader, mainClass);
            return serializedApplication;
        }
    }

    private static String readNullableString(DataInputStream in) throws IOException {
        if (in.readBoolean()) {
            return in.readUTF();
        }
        return null;
    }

    private static List<String> writeJar(DataOutputStream out, Path jar) throws IOException {
        try (JarFile zip = new JarFile(jar.toFile());){
            Manifest manifest = zip.getManifest();
            if (manifest == null) {
                out.writeBoolean(false);
            } else {
                Attributes ma = manifest.getMainAttributes();
                if (ma == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.SPECIFICATION_TITLE));
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.SPECIFICATION_VERSION));
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.SPECIFICATION_VENDOR));
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.IMPLEMENTATION_TITLE));
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.IMPLEMENTATION_VENDOR));
                }
            }
            LinkedHashSet<String> dirs = new LinkedHashSet<String>();
            LinkedHashMap<String, List> fullyIndexedPaths = new LinkedHashMap<String, List>();
            Enumeration<JarEntry> entries = zip.entries();
            boolean hasDefaultPackage = false;
            while (entries.hasMoreElements()) {
                int subIndex;
                String part;
                int slash;
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().contains("/")) {
                    hasDefaultPackage = true;
                    if (entry.getName().isEmpty() || !FULLY_INDEXED_PATHS.contains("")) continue;
                    fullyIndexedPaths.computeIfAbsent("", SerializedApplication::newFullyIndexedPathsValue).add(entry.getName());
                    continue;
                }
                if (entry.isDirectory()) continue;
                int index = entry.getName().lastIndexOf(47);
                dirs.add(entry.getName().substring(0, index));
                if (entry.getName().startsWith(META_INF_VERSIONS) && (slash = (part = entry.getName().substring(META_INF_VERSIONS.length())).indexOf("/")) != -1 && (subIndex = part.lastIndexOf(47)) != slash) {
                    dirs.add(part.substring(slash + 1, subIndex));
                }
                for (int i = 0; i < FULLY_INDEXED_PATHS.size(); ++i) {
                    String path = FULLY_INDEXED_PATHS.get(i);
                    if (path.isEmpty() || !entry.getName().startsWith(path)) continue;
                    fullyIndexedPaths.computeIfAbsent(path, SerializedApplication::newFullyIndexedPathsValue).add(entry.getName());
                }
            }
            if (hasDefaultPackage) {
                dirs.add("");
            }
            out.writeShort(dirs.size());
            for (String i : dirs) {
                out.writeUTF(i);
            }
            ArrayList result = new ArrayList();
            for (List values : fullyIndexedPaths.values()) {
                result.addAll(values);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
    }

    private static List<String> newFullyIndexedPathsValue(String ignored) {
        return new ArrayList<String>(10);
    }

    private static void collectPackages(final Path jar, final Set<String> dirs) throws IOException {
        if (Files.isDirectory(jar, new LinkOption[0])) {
            Files.walkFileTree(jar, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    dirs.add(jar.relativize(dir).toString());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            try (JarFile zip = new JarFile(jar.toFile());){
                Enumeration<JarEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    int index;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || (index = entry.getName().lastIndexOf(47)) <= 0) continue;
                    dirs.add(entry.getName().substring(0, index));
                }
            }
        }
    }

    private static void writeNullableString(DataOutputStream out, String string) throws IOException {
        if (string == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(string);
        }
    }

    private static class ResourceDirectoryTracker {
        private final Map<String, ClassLoadingResource[]> result = new HashMap<String, ClassLoadingResource[]>();
        private final Map<String, Set<ClassLoadingResource>> overrides = new HashMap<String, Set<ClassLoadingResource>>();

        private ResourceDirectoryTracker() {
        }

        void addResourceDir(String dir, JarResource resource) {
            ClassLoadingResource[] existing = this.result.get(dir);
            if (existing == null) {
                this.result.put(dir, new JarResource[]{resource});
            } else {
                ClassLoadingResource existingResource = existing[0];
                if (!existingResource.equals(resource)) {
                    Set<ClassLoadingResource> dirOverrides = this.overrides.get(dir);
                    if (dirOverrides == null) {
                        dirOverrides = new LinkedHashSet<ClassLoadingResource>(2);
                        dirOverrides.add(existingResource);
                        dirOverrides.add(resource);
                        this.overrides.put(dir, dirOverrides);
                        existing[0] = SENTINEL;
                    } else {
                        dirOverrides.add(resource);
                    }
                }
            }
        }

        Map<String, ClassLoadingResource[]> getResult() {
            this.overrides.forEach(this::addToResult);
            return this.result;
        }

        private void addToResult(String dir, Set<? extends ClassLoadingResource> jarResources) {
            this.result.put(dir, jarResources.toArray(EMPTY_ARRAY));
        }
    }
}

