/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.LocalPomResolver;
import java.io.File;
import java.util.Objects;

public class MavenLocalPomResolver
implements LocalPomResolver {
    private final File repoDir;

    private static String getRelativePomPath(String groupId, String artifactId, String version) {
        return groupId.replace('.', File.separatorChar) + File.separator + artifactId + File.separator + version + File.separator + artifactId + "-" + version + ".pom";
    }

    public MavenLocalPomResolver(File repoDir) {
        this.repoDir = Objects.requireNonNull(repoDir);
    }

    @Override
    public File resolvePom(String groupId, String artifactId, String version) {
        File pom = new File(this.repoDir, MavenLocalPomResolver.getRelativePomPath(groupId, artifactId, version));
        return pom.exists() ? pom : null;
    }
}

