/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.AbstractClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.paths.DirectoryPathTree;
import io.quarkus.paths.OpenPathTree;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@Deprecated
public class DirectoryClassPathElement
extends AbstractClassPathElement {
    private final Path root;
    private final boolean runtime;

    public DirectoryClassPathElement(Path root, boolean runtime) {
        assert (root != null) : "root is null";
        this.root = root.normalize();
        this.runtime = runtime;
    }

    @Override
    public <T> T apply(Function<OpenPathTree, T> func) {
        return func.apply((OpenPathTree)new DirectoryPathTree(this.root));
    }

    @Override
    public boolean isRuntime() {
        return this.runtime;
    }

    @Override
    public Path getRoot() {
        return this.root;
    }

    @Override
    public ClassPathResource getResource(final String name) {
        Path file;
        try {
            file = this.root.resolve(name);
        }
        catch (InvalidPathException ipe) {
            return null;
        }
        Path normal = file.normalize();
        String cn = name;
        if (File.separatorChar == '\\') {
            cn = cn.replace('/', '\\');
        }
        if (!normal.startsWith(file)) {
            return null;
        }
        if (normal.toString().equals(cn)) {
            return null;
        }
        if (!normal.endsWith(Paths.get(cn, new String[0])) && !cn.isEmpty()) {
            return null;
        }
        if (Files.exists(file, new LinkOption[0])) {
            return new ClassPathResource(){

                @Override
                public ClassPathElement getContainingElement() {
                    return DirectoryClassPathElement.this;
                }

                @Override
                public String getPath() {
                    return name;
                }

                @Override
                public URL getUrl() {
                    try {
                        URI uri = file.toUri();
                        if (uri.getPath().endsWith("/")) {
                            String uriStr = uri.toString();
                            return new URL(uriStr.substring(0, uriStr.length() - 1));
                        }
                        return uri.toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public byte[] getData() {
                    try {
                        try {
                            return Files.readAllBytes(file);
                        }
                        catch (InterruptedIOException e) {
                            byte[] bytes = Files.readAllBytes(file);
                            Thread.currentThread().interrupt();
                            return bytes;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to read " + String.valueOf(file), e);
                    }
                }

                @Override
                public boolean isDirectory() {
                    return Files.isDirectory(file, new LinkOption[0]);
                }
            };
        }
        return null;
    }

    @Override
    public Set<String> getProvidedResources() {
        HashSet<String> hashSet;
        block8: {
            Stream<Path> files = Files.walk(this.root, new FileVisitOption[0]);
            try {
                final HashSet<String> paths = new HashSet<String>();
                files.forEach(new Consumer<Path>(){

                    @Override
                    public void accept(Path path) {
                        if (!path.equals(DirectoryClassPathElement.this.root)) {
                            String st = DirectoryClassPathElement.this.root.relativize(path).toString();
                            if (!path.getFileSystem().getSeparator().equals("/")) {
                                st = st.replace(path.getFileSystem().getSeparator(), "/");
                            }
                            paths.add(st);
                        }
                    }
                });
                hashSet = paths;
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            files.close();
        }
        return hashSet;
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        URL url = null;
        try {
            URI uri = this.root.toUri();
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to create protection domain for " + String.valueOf(this.root), e);
        }
        CodeSource codesource = new CodeSource(url, (Certificate[])null);
        return new ProtectionDomain(codesource, null);
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return this.root.toAbsolutePath().toString();
    }
}

