/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.azure.functions.deployment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionConfiguration;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.AnnotationHandlerImpl;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.azure.functions.deployment.AzureFunctionBuildItem;
import io.quarkus.azure.functions.deployment.AzureFunctionsAppNameBuildItem;
import io.quarkus.azure.functions.deployment.AzureFunctionsConfig;
import io.quarkus.azure.functions.deployment.AzureFunctionsDotNames;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsProduction;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class AzureFunctionsProcessor {
    private static final Logger log = Logger.getLogger(AzureFunctionsProcessor.class);
    protected static final String HOST_JSON = "host.json";
    protected static final String LOCAL_SETTINGS_JSON = "local.settings.json";
    public static final String FUNCTION_JSON = "function.json";
    private static final String DEFAULT_HOST_JSON = "{\"version\":\"2.0\",\"extensionBundle\":{\"id\":\"Microsoft.Azure.Functions.ExtensionBundle\",\"version\":\"[3.*, 4.0.0)\"}}\n";
    private static final String DEFAULT_LOCAL_SETTINGS_JSON = "{ \"IsEncrypted\": false, \"Values\": { \"FUNCTIONS_WORKER_RUNTIME\": \"java\" } }";
    private static final String AZURE_FUNCTIONS_JAVA_CORE_LIBRARY = "com.microsoft.azure.functions.azure-functions-java-core-library";
    protected static final String AZURE_FUNCTIONS_JAVA_LIBRARY = "com.microsoft.azure.functions.azure-functions-java-library";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.AZURE_FUNCTIONS);
    }

    @BuildStep
    AzureFunctionsAppNameBuildItem appName(OutputTargetBuildItem output, AzureFunctionsConfig functionsConfig) {
        String appName = functionsConfig.appName().orElse(output.getBaseName());
        return new AzureFunctionsAppNameBuildItem(appName);
    }

    @BuildStep(onlyIf={IsProduction.class}, onlyIfNot={NativeBuild.class})
    public ArtifactResultBuildItem packageFunctions(List<AzureFunctionBuildItem> functions, OutputTargetBuildItem target, AzureFunctionsConfig functionsConfig, PackageConfig packageConfig, AzureFunctionsAppNameBuildItem appName, JarBuildItem jar) throws Exception {
        if (functions == null || functions.isEmpty()) {
            log.warn((Object)"No azure functions exist in deployment");
            return null;
        }
        if (packageConfig.jar().type() != PackageConfig.JarConfig.JarType.LEGACY_JAR) {
            throw new BuildException("Azure Function deployment need to use a legacy JAR, please set 'quarkus.package.jar.type=legacy-jar' inside your application.properties", List.of());
        }
        AnnotationHandlerImpl handler = new AnnotationHandlerImpl();
        HashSet<Method> methods = new HashSet<Method>();
        for (AzureFunctionBuildItem item : functions) {
            methods.add(item.getMethod());
        }
        Map configMap = handler.generateConfigurations(methods);
        String scriptFilePath = String.format("../%s.jar", target.getBaseName() + packageConfig.computedRunnerSuffix());
        configMap.values().forEach(config -> config.setScriptFile(scriptFilePath));
        configMap.values().forEach(FunctionConfiguration::validate);
        ObjectWriter objectWriter = this.getObjectWriter();
        Path rootPath = target.getOutputDirectory().resolve("..");
        Path outputDirectory = target.getOutputDirectory();
        Path functionStagingDir = outputDirectory.resolve("azure-functions").resolve(appName.getAppName());
        this.copyHostJson(rootPath, functionStagingDir);
        this.copyLocalSettingsJson(rootPath, functionStagingDir);
        this.writeFunctionJsonFiles(objectWriter, configMap, functionStagingDir);
        this.copyJarsToStageDirectory(jar, functionStagingDir);
        return new ArtifactResultBuildItem(functionStagingDir, "azure-functions", Collections.EMPTY_MAP);
    }

    protected void writeFunctionJsonFiles(ObjectWriter objectWriter, Map<String, FunctionConfiguration> configMap, Path functionStagingDir) throws IOException {
        if (!configMap.isEmpty()) {
            String functionDir = functionStagingDir.toString();
            for (Map.Entry<String, FunctionConfiguration> config : configMap.entrySet()) {
                this.writeFunctionJsonFile(objectWriter, config.getKey(), config.getValue(), functionDir);
            }
        }
    }

    protected void writeFunctionJsonFile(ObjectWriter objectWriter, String functionName, FunctionConfiguration config, String functionStagingDir) throws IOException {
        File functionJsonFile = Paths.get(functionStagingDir, functionName, FUNCTION_JSON).toFile();
        this.writeObjectToFile(objectWriter, config, functionJsonFile);
    }

    protected void copyHostJson(Path rootPath, Path functionStagingDir) throws IOException {
        File sourceHostJsonFile = rootPath.resolve(HOST_JSON).toFile();
        File destHostJsonFile = functionStagingDir.resolve(HOST_JSON).toFile();
        AzureFunctionsProcessor.copyFilesWithDefaultContent(sourceHostJsonFile, destHostJsonFile, DEFAULT_HOST_JSON);
    }

    protected void copyLocalSettingsJson(Path rootPath, Path functionStagingDir) throws IOException {
        File sourceLocalSettingsJsonFile = rootPath.resolve(LOCAL_SETTINGS_JSON).toFile();
        File destLocalSettingsJsonFile = functionStagingDir.resolve(LOCAL_SETTINGS_JSON).toFile();
        AzureFunctionsProcessor.copyFilesWithDefaultContent(sourceLocalSettingsJsonFile, destLocalSettingsJsonFile, DEFAULT_LOCAL_SETTINGS_JSON);
    }

    private static void copyFilesWithDefaultContent(File source, File dest, String defaultContent) throws IOException {
        if (source != null && source.exists()) {
            FileUtils.copyFile((File)source, (File)dest);
        } else {
            FileUtils.write((File)dest, (CharSequence)defaultContent, (Charset)Charset.defaultCharset());
        }
    }

    protected void copyJarsToStageDirectory(JarBuildItem jar, Path functionStagingDir) throws IOException, AzureExecutionException {
        String stagingDirectory = functionStagingDir.toString();
        File libFolder = Paths.get(stagingDirectory, "lib").toFile();
        if (libFolder.exists()) {
            FileUtils.cleanDirectory((File)libFolder);
        }
        for (File dep : jar.getLibraryDir().toFile().listFiles()) {
            if (dep.getName().startsWith(AZURE_FUNCTIONS_JAVA_CORE_LIBRARY) || dep.getName().startsWith(AZURE_FUNCTIONS_JAVA_LIBRARY)) continue;
            FileUtils.copyFileToDirectory((File)dep, (File)libFolder);
        }
        FileUtils.copyFileToDirectory((File)jar.getPath().toFile(), (File)functionStagingDir.toFile());
    }

    protected void writeObjectToFile(ObjectWriter objectWriter, Object object, File targetFile) throws IOException {
        targetFile.getParentFile().mkdirs();
        targetFile.createNewFile();
        objectWriter.writeValue(targetFile, object);
    }

    protected ObjectWriter getObjectWriter() {
        DefaultIndenter indenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withLinefeed("\n");
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
        return new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).writer((PrettyPrinter)prettyPrinter);
    }

    @BuildStep
    public void findFunctions(CombinedIndexBuildItem combined, BuildProducer<AzureFunctionBuildItem> functions) {
        IndexView index = combined.getIndex();
        Collection anns = index.getAnnotations(AzureFunctionsDotNames.FUNCTION_NAME);
        anns.forEach(annotationInstance -> {
            MethodInfo methodInfo = annotationInstance.target().asMethod();
            ClassInfo ci = methodInfo.declaringClass();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> declaring = loader.loadClass(ci.name().toString());
                Class[] params = (Class[])methodInfo.parameters().stream().map(methodParameterInfo -> {
                    try {
                        return Class.forName(methodParameterInfo.type().name().toString(), false, loader);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeploymentException((Throwable)e);
                    }
                }).toArray(Class[]::new);
                Method method = null;
                try {
                    method = declaring.getMethod(methodInfo.name(), params);
                }
                catch (NoSuchMethodException e) {
                    throw new DeploymentException((Throwable)e);
                }
                String funcName = annotationInstance.value().asString();
                functions.produce((BuildItem)new AzureFunctionBuildItem(funcName, declaring, method));
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException((Throwable)e);
            }
        });
    }

    @BuildStep
    public void registerArc(BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<AdditionalBeanBuildItem> additionalBeans, List<AzureFunctionBuildItem> functions) {
        if (functions == null || functions.isEmpty()) {
            return;
        }
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setDefaultScope(BuiltinScope.REQUEST.getName()).setUnremovable();
        Set classes = functions.stream().map(item -> item.getDeclaring()).collect(Collectors.toSet());
        for (Class funcClass : classes) {
            if (Modifier.isInterface(funcClass.getModifiers()) || Modifier.isAbstract(funcClass.getModifiers())) continue;
            if (AzureFunctionsProcessor.isScoped(funcClass)) {
                unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNameExclusion(funcClass.getName())));
                continue;
            }
            builder.addBeanClass(funcClass.getName());
        }
        additionalBeans.produce((BuildItem)builder.build());
    }

    public static boolean isScoped(Class clazz) {
        if (clazz.isAnnotationPresent(Dependent.class)) {
            return true;
        }
        if (clazz.isAnnotationPresent(Singleton.class)) {
            return true;
        }
        if (clazz.isAnnotationPresent(ApplicationScoped.class)) {
            return true;
        }
        return clazz.isAnnotationPresent(RequestScoped.class);
    }
}

