/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.azure.functions.deployment;

import com.azure.core.management.AzureEnvironment;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import com.microsoft.azure.toolkit.lib.auth.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.exception.InvalidConfigurationException;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public class AzureFunctionsConfig {
    @ConfigItem
    public Optional<String> appName;
    @ConfigItem(defaultValue="quarkus")
    public String resourceGroup;
    @ConfigItem(defaultValue="westus")
    public String region;
    @ConfigItem(defaultValue="false")
    public boolean disableAppInsights;
    @ConfigItem
    public Optional<String> appInsightsKey;
    public RuntimeConfig runtime;
    public AuthConfig auth;
    @ConfigItem(defaultValue="java-functions-app-service-plan")
    public String appServicePlanName;
    @ConfigItem
    public Optional<String> appServicePlanResourceGroup;
    @ConfigItem
    public Optional<String> subscriptionId;
    @ConfigItem
    public Optional<String> pricingTier;
    @ConfigItem
    public Optional<Integer> funcPort;
    @ConfigItem(defaultValue="transport=dt_socket,server=y,suspend=n,address=5005")
    public String localDebugConfig;
    @ConfigItem
    @ConfigDocMapKey(value="setting-name")
    public Map<String, String> appSettings = Collections.emptyMap();

    public FunctionAppConfig toFunctionAppConfig(String subscriptionId, String appName) {
        Map<String, String> appSettings = this.appSettings;
        if (appSettings.isEmpty()) {
            appSettings = new HashMap<String, String>();
            appSettings.put("FUNCTIONS_EXTENSION_VERSION", "~4");
        }
        return (FunctionAppConfig)new FunctionAppConfig().disableAppInsights(this.disableAppInsights).appInsightsKey((String)this.appInsightsKey.orElse(null)).appInsightsInstance((String)this.appInsightsKey.orElse(null)).subscriptionId(subscriptionId).resourceGroup(this.resourceGroup).appName(appName).servicePlanName(this.appServicePlanName).servicePlanResourceGroup((String)this.appServicePlanResourceGroup.orElse(null)).pricingTier(this.getParsedPricingTier(subscriptionId)).region(this.getParsedRegion()).runtime(this.getRuntimeConfig(subscriptionId)).appSettings(appSettings);
    }

    private PricingTier getParsedPricingTier(String subscriptionId) {
        return Optional.ofNullable(this.pricingTier.orElse(null)).map(PricingTier::fromString).orElseGet(() -> Optional.ofNullable(this.getServicePlan(subscriptionId)).map(AppServicePlan::getPricingTier).orElse(null));
    }

    private AppServicePlan getServicePlan(String subscriptionId) {
        String servicePlan = this.appServicePlanName;
        String servicePlanGroup = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.appServicePlanResourceGroup.orElse(null), this.resourceGroup});
        return StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{subscriptionId, servicePlan, servicePlanGroup}) ? null : (AppServicePlan)((AzureAppService)Azure.az(AzureAppService.class)).plans(subscriptionId).get(servicePlan, servicePlanGroup);
    }

    private com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig getRuntimeConfig(String subscriptionId) {
        RuntimeConfig runtime = this.runtime;
        if (runtime == null) {
            return null;
        }
        OperatingSystem os = Optional.ofNullable(runtime.os).map(OperatingSystem::fromString).orElseGet(() -> Optional.ofNullable(this.getServicePlan(subscriptionId)).map(AppServicePlan::getOperatingSystem).orElse(null));
        JavaVersion javaVersion = Optional.ofNullable(runtime.javaVersion).map(JavaVersion::fromString).orElse(null);
        com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig result = new com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig().os(os).javaVersion(javaVersion).webContainer(WebContainer.JAVA_OFF).image((String)runtime.image.orElse(null)).registryUrl((String)runtime.registryUrl.orElse(null));
        return result;
    }

    private Region getParsedRegion() {
        return Optional.ofNullable(this.region).map(Region::fromName).orElse(null);
    }

    @ConfigGroup
    public static class RuntimeConfig {
        @ConfigItem(defaultValue="linux")
        public String os;
        @ConfigItem(defaultValue="11")
        public String javaVersion;
        @ConfigItem
        public Optional<String> image;
        @ConfigItem
        public Optional<String> registryUrl;
    }

    @ConfigGroup
    public static class AuthConfig {
        @ConfigItem(defaultValue="azure_cli")
        public String type;
        @ConfigItem
        public Optional<String> path;
        @ConfigItem
        public Optional<String> client;
        @ConfigItem
        public Optional<String> tenant;
        private static final Logger log = Logger.getLogger(AzureFunctionsConfig.class);

        private static String findValue(Properties props, String key) {
            if (props.contains(key)) {
                return (String)props.get(key);
            }
            return (String)props.get("quarkus.azure-functions.auth." + key);
        }

        private static AuthConfiguration fromFile(Optional<String> path) {
            try {
                if (path.isEmpty()) {
                    throw new IllegalArgumentException("Path must be set if using file auth config");
                }
                File file = new File(path.get());
                if (!file.exists()) {
                    throw new IllegalArgumentException("Auth config file not found: " + path.get());
                }
                Properties props = new Properties();
                props.load(new FileInputStream(file));
                String typeVal = AuthConfig.findValue(props, "type");
                if (typeVal == null) {
                    throw new IllegalArgumentException("Auth config file does not define type: " + String.valueOf(path));
                }
                AuthType type = AuthType.parseAuthType((String)typeVal);
                AuthConfiguration authConfiguration = new AuthConfiguration(type);
                authConfiguration.setClient(AuthConfig.findValue(props, "client"));
                authConfiguration.setTenant(AuthConfig.findValue(props, "tenant"));
                authConfiguration.setCertificate(AuthConfig.findValue(props, "certificate"));
                authConfiguration.setCertificatePassword(AuthConfig.findValue(props, "certificate-password"));
                authConfiguration.setKey(AuthConfig.findValue(props, "key"));
                authConfiguration.setEnvironment(AuthConfig.findValue(props, "environment"));
                authConfiguration.setEnvironment(Optional.ofNullable(authConfiguration.getEnvironment()).orElseGet(() -> AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)AzureEnvironment.AZURE)));
                if (authConfiguration.getType() == AuthType.SERVICE_PRINCIPAL) {
                    authConfiguration.validate();
                }
                return authConfiguration;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        public AuthConfiguration toAuthConfiguration() {
            try {
                if (this.type.equalsIgnoreCase("file")) {
                    return AuthConfig.fromFile(this.path);
                }
                AuthType type = AuthType.parseAuthType((String)this.type);
                AuthConfiguration authConfiguration = new AuthConfiguration(type);
                authConfiguration.setClient((String)this.client.orElse(null));
                authConfiguration.setTenant((String)this.tenant.orElse(null));
                authConfiguration.setEnvironment(AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)AzureEnvironment.AZURE));
                return authConfiguration;
            }
            catch (InvalidConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

