/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.staticmethods;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.deployment.InterceptorResolverBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.staticmethods.InterceptedStaticMethodBuildItem;
import io.quarkus.arc.deployment.staticmethods.InterceptedStaticMethodsTransformersRegisteredBuildItem;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.InterceptedMethodMetadata;
import io.quarkus.arc.impl.InterceptedStaticMethods;
import io.quarkus.arc.impl.InterceptorInvocation;
import io.quarkus.arc.impl.Reflections;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.runtime.InterceptedStaticMethodsRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmo2Adaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.Reflection2Gizmo;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.interceptor.InvocationContext;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Descriptor;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;

public class InterceptedStaticMethodsProcessor {
    private static final Logger LOGGER = Logger.getLogger(InterceptedStaticMethodsProcessor.class);
    static final MethodDesc INTERCEPTED_STATIC_METHODS_REGISTER = MethodDesc.of(InterceptedStaticMethods.class, (String)"register", Void.TYPE, (Class[])new Class[]{String.class, InterceptedMethodMetadata.class});
    static final MethodDesc INTERCEPTED_STATIC_METHODS_AROUND_INVOKE = MethodDesc.of(InterceptedStaticMethods.class, (String)"aroundInvoke", Object.class, (Class[])new Class[]{String.class, Object[].class});
    static final MethodDesc ARC_REQUIRE_CONTAINER = MethodDesc.of(Arc.class, (String)"requireContainer", ArcContainer.class, (Class[])new Class[0]);
    static final MethodDesc ARC_CONTAINER_BEAN = MethodDesc.of(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class});
    static final MethodDesc CREATIONAL_CTX_CHILD = MethodDesc.of(CreationalContextImpl.class, (String)"child", CreationalContextImpl.class, (Class[])new Class[]{CreationalContext.class});
    static final MethodDesc INJECTABLE_REF_PROVIDER_GET = MethodDesc.of(InjectableReferenceProvider.class, (String)"get", Object.class, (Class[])new Class[]{CreationalContext.class});
    static final ConstructorDesc INTERCEPTED_METHOD_METADATA_CONSTRUCTOR = ConstructorDesc.of(InterceptedMethodMetadata.class, (Class[])new Class[]{List.class, Method.class, Set.class, BiFunction.class});
    static final MethodDesc INTERCEPTOR_INVOCATION_AROUND_INVOKE = MethodDesc.of(InterceptorInvocation.class, (String)"aroundInvoke", InterceptorInvocation.class, (Class[])new Class[]{InjectableInterceptor.class, Object.class});
    static final MethodDesc REFLECTIONS_FIND_METHOD = MethodDesc.of(Reflections.class, (String)"findMethod", Method.class, (Class[])new Class[]{Class.class, String.class, Class[].class});
    private static final String ORIGINAL_METHOD_COPY_SUFFIX = "_orig";
    private static final String INITIALIZER_CLASS_SUFFIX = "_InterceptorInitializer";

    @BuildStep
    void collectInterceptedStaticMethods(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<InterceptedStaticMethodBuildItem> interceptedStaticMethods, InterceptorResolverBuildItem interceptorResolver, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        for (ClassInfo clazz : beanArchiveIndex.getIndex().getKnownClasses()) {
            for (MethodInfo method : clazz.methods()) {
                Collection<AnnotationInstance> annotations;
                if (method.isSynthetic() || !Modifier.isStatic(method.flags()) || method.isStaticInitializer() || (annotations = transformedAnnotations.getAnnotations((AnnotationTarget)method)).isEmpty()) continue;
                HashSet<AnnotationInstance> methodLevelBindings = null;
                for (AnnotationInstance annotationInstance : annotations) {
                    Collection<AnnotationInstance> bindings;
                    if (annotationInstance.target().kind() != AnnotationTarget.Kind.METHOD || (bindings = interceptorResolver.extractInterceptorBindings(annotationInstance)).isEmpty()) continue;
                    if (methodLevelBindings == null) {
                        methodLevelBindings = new HashSet<AnnotationInstance>();
                    }
                    methodLevelBindings.addAll(bindings);
                }
                if (methodLevelBindings == null || methodLevelBindings.isEmpty()) continue;
                if (Modifier.isPrivate(method.flags())) {
                    LOGGER.warnf("Interception of private static methods is not supported; bindings found on %s: %s", (Object)method.declaringClass().name(), (Object)method);
                    continue;
                }
                List interceptors = interceptorResolver.get().resolve(InterceptionType.AROUND_INVOKE, (Set)methodLevelBindings);
                if (interceptors.isEmpty()) continue;
                LOGGER.debugf("Intercepted static method found on %s: %s", (Object)method.declaringClass().name(), (Object)method);
                unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames(interceptors.stream().map(BeanInfo::getBeanClass).map(Object::toString).collect(Collectors.toSet())));
                interceptedStaticMethods.produce((BuildItem)new InterceptedStaticMethodBuildItem(method, methodLevelBindings, interceptors));
            }
        }
    }

    @Produce(value=InterceptedStaticMethodsTransformersRegisteredBuildItem.class)
    @BuildStep
    void processInterceptedStaticMethods(BeanArchiveIndexBuildItem beanArchiveIndex, BeanRegistrationPhaseBuildItem phase, List<InterceptedStaticMethodBuildItem> interceptedStaticMethods, final CompletedApplicationClassPredicateBuildItem applicationClassPredicate, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods) {
        if (interceptedStaticMethods.isEmpty()) {
            return;
        }
        final HashMap<DotName, CallSite> baseToGeneratedInitializer = new HashMap<DotName, CallSite>();
        GeneratedClassGizmo2Adaptor classOutput = new GeneratedClassGizmo2Adaptor(generatedClasses, generatedResources, (Predicate)new Predicate<String>(){

            @Override
            public boolean test(String name) {
                if ("io.quarkus.arc.runtime.InterceptedStaticMethodsInitializer".equals(name)) {
                    return true;
                }
                DotName base = null;
                for (Map.Entry e : baseToGeneratedInitializer.entrySet()) {
                    if (!name.equals(e.getValue()) && !name.startsWith((String)e.getValue())) continue;
                    base = (DotName)e.getKey();
                }
                if (base == null) {
                    throw new IllegalStateException("Unable to find the base class for " + name);
                }
                return applicationClassPredicate.test(base);
            }
        });
        Gizmo gizmo = Gizmo.create((ClassOutput)classOutput);
        HashMap<DotName, List> interceptedStaticMethodsMap = new HashMap<DotName, List>();
        for (InterceptedStaticMethodBuildItem interceptedStaticMethod : interceptedStaticMethods) {
            List list = interceptedStaticMethodsMap.computeIfAbsent(interceptedStaticMethod.getTarget().name(), k -> new ArrayList());
            list.add(interceptedStaticMethod);
        }
        String initAllMethodName = "init_static_intercepted_methods";
        for (Map.Entry entry : interceptedStaticMethodsMap.entrySet()) {
            String initializerName = String.valueOf(entry.getKey()) + INITIALIZER_CLASS_SUFFIX;
            baseToGeneratedInitializer.put((DotName)entry.getKey(), (CallSite)((Object)initializerName));
            gizmo.class_(initializerName, cc -> {
                cc.final_();
                ArrayList<MethodDesc> initMethods = new ArrayList<MethodDesc>();
                for (InterceptedStaticMethodBuildItem interceptedStaticMethod : (List)entry.getValue()) {
                    initMethods.add(this.generateInit(beanArchiveIndex.getIndex(), (ClassCreator)cc, interceptedStaticMethod, reflectiveMethods, phase.getBeanProcessor()));
                    this.generateForward((ClassCreator)cc, interceptedStaticMethod);
                }
                cc.staticMethod(initAllMethodName, mc -> mc.body(bc -> {
                    for (MethodDesc initMethod : initMethods) {
                        bc.invokeStatic(initMethod);
                    }
                    bc.return_();
                }));
            });
        }
        for (Map.Entry entry : interceptedStaticMethodsMap.entrySet()) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(((DotName)entry.getKey()).toString(), (BiFunction)new InterceptedStaticMethodsEnhancer((String)baseToGeneratedInitializer.get(entry.getKey()), (List)entry.getValue())));
        }
        gizmo.class_("io.quarkus.arc.runtime.InterceptedStaticMethodsInitializer", cc -> {
            cc.final_();
            cc.staticInitializer(bc -> {
                for (String initializerClass : baseToGeneratedInitializer.values()) {
                    bc.invokeStatic((MethodDesc)ClassMethodDesc.of((ClassDesc)ClassDesc.of(initializerClass), (String)initAllMethodName, Void.TYPE, (Class[])new Class[0]));
                }
                bc.return_();
            });
        });
    }

    private MethodDesc generateInit(IndexView index, ClassCreator cc, InterceptedStaticMethodBuildItem interceptedStaticMethod, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BeanProcessor beanProcessor) {
        MethodInfo btMethod = interceptedStaticMethod.getMethod();
        List<InterceptorInfo> interceptors = interceptedStaticMethod.getInterceptors();
        Set<AnnotationInstance> btBindings = interceptedStaticMethod.getBindings();
        return cc.staticMethod("init_" + btMethod.name() + "_" + interceptedStaticMethod.getHash(), mc -> {
            mc.private_();
            mc.body(b0 -> {
                LocalVar creationalContext = b0.localVar("creationalContext", b0.new_(ConstructorDesc.of(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), (Expr)Const.ofNull(Contextual.class)));
                LocalVar chain = b0.localVar("chain", b0.blockExpr(List.class, b1 -> {
                    if (interceptors.size() == 1) {
                        b1.yield(b1.listOf(new Expr[]{this.createInterceptorInvocation((InterceptorInfo)interceptors.get(0), (BlockCreator)b1, creationalContext)}));
                    } else {
                        LocalVar list = b1.localVar("list", b1.new_(ArrayList.class));
                        for (InterceptorInfo interceptor : interceptors) {
                            b1.withList((Expr)list).add(this.createInterceptorInvocation(interceptor, (BlockCreator)b1, creationalContext));
                        }
                        b1.yield((Expr)list);
                    }
                }));
                LocalVar rtMethod = b0.localVar("method", b0.blockExpr(Reflection2Gizmo.classDescOf(Method.class), b1 -> {
                    Const className = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)btMethod.declaringClass()));
                    Const name = Const.of((String)btMethod.name());
                    Expr params = b1.newArray(Class.class, btMethod.parameterTypes(), type -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)type)));
                    b1.yield(b1.invokeStatic(REFLECTIONS_FIND_METHOD, new Expr[]{className, name, params}));
                }));
                LocalVar rtBindings = b0.localVar("bindings", b0.blockExpr(Set.class, b1 -> {
                    if (btBindings.size() == 1) {
                        b1.yield(b1.setOf(new Expr[]{this.createBindingLiteral(index, (BlockCreator)b1, (AnnotationInstance)btBindings.iterator().next(), beanProcessor.getAnnotationLiteralProcessor())}));
                    } else {
                        LocalVar set = b1.localVar("set", b1.new_(HashSet.class));
                        for (AnnotationInstance btBinding : btBindings) {
                            b1.withSet((Expr)set).add(this.createBindingLiteral(index, (BlockCreator)b1, btBinding, beanProcessor.getAnnotationLiteralProcessor()));
                        }
                        b1.yield((Expr)set);
                    }
                }));
                Expr forwardingFunc = b0.lambda(BiFunction.class, lc -> {
                    lc.parameter("ignored", 0);
                    ParamVar ctx = lc.parameter("ctx", 1);
                    lc.body(lbc -> {
                        Expr[] args;
                        ClassDesc[] params;
                        if (btMethod.parametersCount() == 0) {
                            params = new ClassDesc[]{};
                            args = new Expr[]{};
                        } else {
                            params = new ClassDesc[btMethod.parametersCount()];
                            args = new Expr[btMethod.parametersCount()];
                            LocalVar ctxParams = lbc.localVar("params", lbc.invokeInterface(MethodDesc.of(InvocationContext.class, (String)"getParameters", Object[].class, (Class[])new Class[0]), (Expr)ctx));
                            for (int i = 0; i < args.length; ++i) {
                                params[i] = Jandex2Gizmo.classDescOf((Type)btMethod.parameterType(i));
                                args[i] = ctxParams.elem(i);
                            }
                        }
                        ClassDesc declaringClass = Jandex2Gizmo.classDescOf((ClassInfo)interceptedStaticMethod.getTarget());
                        String methodName = btMethod.name() + ORIGINAL_METHOD_COPY_SUFFIX;
                        MethodTypeDesc methodType = MethodTypeDesc.of(Jandex2Gizmo.classDescOf((Type)btMethod.returnType()), params);
                        InterfaceMethodDesc targetMethod = interceptedStaticMethod.getTarget().isInterface() ? InterfaceMethodDesc.of((ClassDesc)declaringClass, (String)methodName, (MethodTypeDesc)methodType) : ClassMethodDesc.of((ClassDesc)declaringClass, (String)methodName, (MethodTypeDesc)methodType);
                        Expr ret = lbc.invokeStatic((MethodDesc)targetMethod, args);
                        lbc.return_((Expr)(ret.isVoid() ? Const.ofNull(Object.class) : ret));
                    });
                });
                Expr metadata = b0.new_(INTERCEPTED_METHOD_METADATA_CONSTRUCTOR, new Expr[]{chain, rtMethod, rtBindings, forwardingFunc});
                b0.invokeStatic(INTERCEPTED_STATIC_METHODS_REGISTER, (Expr)Const.of((String)interceptedStaticMethod.getHash()), metadata);
                b0.return_();
                reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(this.getClass().getName(), btMethod));
            });
        });
    }

    private Expr createInterceptorInvocation(InterceptorInfo interceptor, BlockCreator bc, LocalVar parentCreationalContext) {
        Expr arc = bc.invokeStatic(ARC_REQUIRE_CONTAINER);
        Expr bean = bc.invokeInterface(ARC_CONTAINER_BEAN, arc, (Expr)Const.of((String)interceptor.getIdentifier()));
        LocalVar interceptorBean = bc.localVar("interceptor", bc.cast(bean, InjectableInterceptor.class));
        Expr creationalContext = bc.invokeStatic(CREATIONAL_CTX_CHILD, (Expr)parentCreationalContext);
        Expr interceptorInstance = bc.invokeInterface(INJECTABLE_REF_PROVIDER_GET, (Expr)interceptorBean, creationalContext);
        return bc.invokeStatic(INTERCEPTOR_INVOCATION_AROUND_INVOKE, (Expr)interceptorBean, interceptorInstance);
    }

    private Expr createBindingLiteral(IndexView index, BlockCreator bc, AnnotationInstance binding, AnnotationLiteralProcessor annotationLiterals) {
        ClassInfo bindingClass = index.getClassByName(binding.name());
        return annotationLiterals.create(bc, bindingClass, binding);
    }

    private void generateForward(ClassCreator cc, InterceptedStaticMethodBuildItem interceptedStaticMethod) {
        MethodInfo method = interceptedStaticMethod.getMethod();
        cc.staticMethod(interceptedStaticMethod.getForwardingMethodName(), mc -> {
            mc.returning(Jandex2Gizmo.classDescOf((Type)method.returnType()));
            ArrayList<ParamVar> params = new ArrayList<ParamVar>();
            for (MethodParameterInfo param : method.parameters()) {
                Object name = param.name();
                if (name == null) {
                    name = "p" + param.position();
                }
                params.add(mc.parameter((String)name, Jandex2Gizmo.classDescOf((Type)param.type())));
            }
            mc.body(bc -> {
                Expr args = bc.newArray(Object.class, params);
                Expr result = bc.invokeStatic(INTERCEPTED_STATIC_METHODS_AROUND_INVOKE, (Expr)Const.of((String)interceptedStaticMethod.getHash()), args);
                bc.return_((Expr)(method.returnType().kind() == Type.Kind.VOID ? Const.ofVoid() : result));
            });
        });
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void callInitializer(BeanContainerBuildItem beanContainer, List<InterceptedStaticMethodBuildItem> interceptedStaticMethods, InterceptedStaticMethodsRecorder recorder) {
        if (interceptedStaticMethods.isEmpty()) {
            return;
        }
        recorder.callInitializer();
    }

    static class InterceptedStaticMethodsEnhancer
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        private final String initializerClassName;
        private final List<InterceptedStaticMethodBuildItem> methods;

        public InterceptedStaticMethodsEnhancer(String initializerClassName, List<InterceptedStaticMethodBuildItem> methods) {
            this.methods = methods;
            this.initializerClassName = initializerClassName;
        }

        @Override
        public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
            ClassTransformer transformer = new ClassTransformer(className);
            for (InterceptedStaticMethodBuildItem interceptedStaticMethod : this.methods) {
                MethodInfo interceptedMethod = interceptedStaticMethod.getMethod();
                MethodDescriptor originalDescriptor = MethodDescriptor.of((MethodInfo)interceptedMethod);
                transformer.modifyMethod(originalDescriptor).rename(interceptedMethod.name() + InterceptedStaticMethodsProcessor.ORIGINAL_METHOD_COPY_SUFFIX);
                MethodCreator newMethod = (MethodCreator)((MethodCreator)transformer.addMethod(originalDescriptor).setModifiers((int)interceptedMethod.flags())).setSignature(interceptedMethod.genericSignatureIfRequired());
                for (AnnotationInstance annotationInstance : interceptedMethod.declaredAnnotations()) {
                    if (!annotationInstance.runtimeVisible()) continue;
                    newMethod.addAnnotation(annotationInstance);
                }
                for (MethodParameterInfo param : interceptedMethod.parameters()) {
                    AnnotatedElement newParam = newMethod.getParameterAnnotations((int)param.position());
                    for (AnnotationInstance paramAnnotation : param.declaredAnnotations()) {
                        if (!paramAnnotation.runtimeVisible()) continue;
                        newParam.addAnnotation(paramAnnotation);
                    }
                }
                for (Type exceptionType : interceptedMethod.exceptions()) {
                    newMethod.addException(exceptionType.name().toString());
                }
                ResultHandle[] args = new ResultHandle[interceptedMethod.parametersCount()];
                for (int i = 0; i < interceptedMethod.parametersCount(); ++i) {
                    args[i] = newMethod.getMethodParam(i);
                }
                ResultHandle ret = newMethod.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.initializerClassName, (String)interceptedStaticMethod.getForwardingMethodName(), (Object)interceptedMethod.returnType().descriptor(), (Object[])interceptedMethod.parameterTypes().stream().map(Descriptor::descriptor).toArray()), args);
                newMethod.returnValue(ret);
            }
            return transformer.applyTo(outputClassVisitor);
        }
    }
}

