/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.apicurio.registry.common;

import io.apicurio.rest.client.spi.ApicurioHttpClientProvider;
import io.quarkus.apicurio.registry.common.ApicurioRegistryClient;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.smallrye.openapi.deployment.spi.IgnoreStaticDocumentBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import java.io.IOException;

public class ApicurioRegistryClientProcessor {
    @BuildStep
    public void apicurioRegistryClient(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.apicurio.rest.client.auth.exception.NotAuthorizedException", "io.apicurio.rest.client.auth.exception.ForbiddenException", "io.apicurio.rest.client.auth.exception.AuthException", "io.apicurio.rest.client.auth.exception.AuthErrorHandler", "io.apicurio.rest.client.auth.request.TokenRequestsProvider", "io.apicurio.rest.client.request.Request", "io.apicurio.rest.client.auth.AccessTokenResponse", "io.apicurio.rest.client.auth.Auth", "io.apicurio.rest.client.auth.BasicAuth", "io.apicurio.rest.client.auth.OidcAuth"}).methods().fields().build());
    }

    @BuildStep
    void registerSPIClient(BuildProducer<ServiceProviderBuildItem> services) throws IOException {
        services.produce((BuildItem)new ServiceProviderBuildItem(ApicurioHttpClientProvider.class.getName(), new String[]{"io.apicurio.rest.client.VertxHttpClientProvider"}));
    }

    @BuildStep
    void ignoreIncludedOpenAPIDocument(BuildProducer<IgnoreStaticDocumentBuildItem> ignoreStaticDocumentProducer) {
        ignoreStaticDocumentProducer.produce((BuildItem)new IgnoreStaticDocumentBuildItem(".*/io/apicurio/apicurio-registry-common/.*/apicurio-registry-common-.*.jar.*"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void apicurioRegistryClient(VertxBuildItem vertx, ApicurioRegistryClient client, LaunchModeBuildItem launchMode) {
        if (launchMode.getLaunchMode().isDevOrTest()) {
            client.clearHttpClient();
        }
        client.setup(vertx.getVertx());
    }
}

