/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime.dev.ui;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.quarkus.agroal.runtime.AgroalDataSourceSupport;
import io.quarkus.agroal.runtime.AgroalDataSourceUtil;
import io.quarkus.arc.InactiveBeanException;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.logging.Log;
import io.quarkus.runtime.LaunchMode;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class DatabaseInspector {
    @Inject
    Instance<AgroalDataSourceSupport> agroalDataSourceSupports;
    private final Map<String, AgroalDataSource> checkedDataSources = new HashMap<String, AgroalDataSource>();
    private boolean isDev = false;
    private boolean allowSql = false;
    private String allowedHost = null;

    public DatabaseInspector() {
        LaunchMode currentMode = LaunchMode.current();
        this.isDev = currentMode == LaunchMode.DEVELOPMENT && !LaunchMode.isRemoteDev();
        Config config = ConfigProvider.getConfig();
        this.allowSql = config.getOptionalValue("quarkus.datasource.dev-ui.allow-sql", Boolean.class).orElse(false);
        this.allowedHost = config.getOptionalValue("quarkus.datasource.dev-ui.allowed-db-host", String.class).orElse(null);
    }

    @PostConstruct
    protected void init() {
        if (!this.agroalDataSourceSupports.isResolvable()) {
            return;
        }
        if (this.isDev) {
            AgroalDataSourceSupport agroalSupport = (AgroalDataSourceSupport)this.agroalDataSourceSupports.get();
            for (String name : agroalSupport.entries.keySet()) {
                AgroalDataSource ads;
                InjectableInstance dataSourceInstance;
                AgroalDataSourceSupport.Entry entry = (AgroalDataSourceSupport.Entry)agroalSupport.entries.get(name);
                if (entry == null || !(dataSourceInstance = AgroalDataSourceUtil.dataSourceInstance((String)name)).isResolvable() || !this.isAllowedDatabase(ads = (AgroalDataSource)dataSourceInstance.get())) continue;
                this.checkedDataSources.put(name, ads);
            }
        }
    }

    public List<Datasource> getDataSources() {
        if (this.isDev) {
            ArrayList<Datasource> datasources = new ArrayList<Datasource>();
            for (String ds : this.checkedDataSources.keySet()) {
                datasources.add(this.getDatasource(ds));
            }
            return datasources;
        }
        return List.of();
    }

    private Datasource getDatasource(String datasource) {
        AgroalDataSource ads;
        if (this.isDev && this.isAllowedDatabase(ads = this.checkedDataSources.get(datasource))) {
            AgroalDataSourceConfiguration configuration = ads.getConfiguration();
            String jdbcUrl = configuration.connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl();
            boolean isDefault = DataSourceUtil.isDefault((String)datasource);
            return new Datasource(datasource, jdbcUrl, isDefault);
        }
        return null;
    }

    public List<Table> getTables(String datasource) {
        if (this.isDev) {
            ArrayList<Table> tableList;
            block23: {
                tableList = new ArrayList<Table>();
                try {
                    AgroalDataSource ads = this.checkedDataSources.get(datasource);
                    if (!this.isAllowedDatabase(ads)) break block23;
                    try (Connection connection = ads.getConnection();){
                        DatabaseMetaData metaData = connection.getMetaData();
                        try (ResultSet tables = metaData.getTables(null, null, "%", new String[]{"TABLE"});){
                            while (tables.next()) {
                                String tableName = tables.getString("TABLE_NAME");
                                String tableSchema = tables.getString("TABLE_SCHEM");
                                List<String> primaryKeyList = this.getPrimaryKeys(metaData, tableSchema, tableName);
                                ArrayList<Column> columnList = new ArrayList<Column>();
                                try (ResultSet columns = metaData.getColumns(null, tableSchema, tableName, "%");){
                                    while (columns.next()) {
                                        String columnName = columns.getString("COLUMN_NAME");
                                        String columnType = columns.getString("TYPE_NAME");
                                        int columnSize = columns.getInt("COLUMN_SIZE");
                                        String nullable = columns.getString("IS_NULLABLE");
                                        int dataType = columns.getInt("DATA_TYPE");
                                        columnList.add(new Column(columnName, columnType, columnSize, nullable, this.isBinary(dataType)));
                                    }
                                }
                                tableList.add(new Table(tableSchema, tableName, primaryKeyList, columnList));
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return tableList;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public DataSet executeSQL(String datasource, String sql, Integer pageNumber, Integer pageSize) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getInsertScript(String datasource) {
        block23: {
            if (this.isDev) {
                try {
                    AgroalDataSource ads = this.checkedDataSources.get(datasource);
                    if (!this.isAllowedDatabase(ads)) break block23;
                    try (Connection connection = ads.getConnection();){
                        String string;
                        try (StringWriter writer = new StringWriter();){
                            DatabaseMetaData metaData = connection.getMetaData();
                            try (ResultSet tables = metaData.getTables(null, null, "%", new String[]{"TABLE"});){
                                while (tables.next()) {
                                    String tableName = tables.getString("TABLE_NAME");
                                    this.exportTable(connection, writer, tableName);
                                }
                            }
                            string = writer.toString();
                        }
                        return string;
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return null;
    }

    private void exportTable(Connection conn, StringWriter writer, String tableName) throws SQLException, IOException {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);){
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rs.next()) {
                int i;
                StringBuilder insertQuery = new StringBuilder("INSERT INTO " + tableName + " (");
                for (i = 1; i <= columnCount; ++i) {
                    insertQuery.append(metaData.getColumnName(i));
                    if (i >= columnCount) continue;
                    insertQuery.append(", ");
                }
                insertQuery.append(") VALUES (");
                for (i = 1; i <= columnCount; ++i) {
                    Object value = rs.getObject(i);
                    if (value == null) {
                        insertQuery.append("NULL");
                    } else if (value instanceof String || value instanceof Date || value instanceof Timestamp) {
                        insertQuery.append("'").append(value.toString().replace("'", "''")).append("'");
                    } else {
                        insertQuery.append(value.toString());
                    }
                    if (i >= columnCount) continue;
                    insertQuery.append(", ");
                }
                insertQuery.append(");\n");
                writer.write(insertQuery.toString());
            }
        }
    }

    private boolean sqlIsValid(String sql) {
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (this.allowSql) {
            return true;
        }
        String lsql = sql.toLowerCase().trim();
        return lsql.startsWith("select") && !lsql.contains("update ") && !lsql.contains("delete ") && !lsql.contains("insert ") && !lsql.contains("create ") && !lsql.contains("drop ");
    }

    private List<String> getPrimaryKeys(DatabaseMetaData metaData, String tableSchema, String tableName) throws SQLException {
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        try (ResultSet primaryKeys = metaData.getPrimaryKeys(null, tableSchema, tableName);){
            while (primaryKeys.next()) {
                String primaryKeyColumn = primaryKeys.getString("COLUMN_NAME");
                primaryKeyList.add(primaryKeyColumn);
            }
        }
        return primaryKeyList;
    }

    private boolean isAllowedDatabase(AgroalDataSource ads) {
        String allowedHost;
        String string = allowedHost = this.allowedHost == null ? null : this.allowedHost.trim();
        if (allowedHost != null && allowedHost.equals("*")) {
            return true;
        }
        try {
            AgroalDataSourceConfiguration configuration = ads.getConfiguration();
            String jdbcUrl = configuration.connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl();
            if (jdbcUrl.startsWith("jdbc:h2:mem:") || jdbcUrl.startsWith("jdbc:h2:file:") || jdbcUrl.startsWith("jdbc:h2:tcp://localhost") || allowedHost != null && !allowedHost.isBlank() && jdbcUrl.startsWith("jdbc:h2:tcp://" + allowedHost) || jdbcUrl.startsWith("jdbc:derby:memory:")) {
                return true;
            }
            String cleanUrl = jdbcUrl.replace("jdbc:", "");
            URI uri = new URI(cleanUrl);
            String host = uri.getHost();
            return host != null && (host.equals("localhost") || host.equals("127.0.0.1") || host.equals("::1") || allowedHost != null && !allowedHost.isBlank() && host.equalsIgnoreCase(allowedHost));
        }
        catch (URISyntaxException e) {
            Log.warn((Object)e.getMessage());
        }
        catch (InactiveBeanException inactiveBeanException) {
            // empty catch block
        }
        return false;
    }

    private boolean isBinary(int dataType, String javaClassName) {
        if (UUID.class.getName().equals(javaClassName)) {
            return false;
        }
        return this.isBinary(dataType);
    }

    private boolean isBinary(int dataType) {
        return dataType == 2004 || dataType == -3 || dataType == -4 || dataType == -2 || dataType == 2000 || dataType == 1111;
    }

    private record Datasource(String name, String jdbcUrl, boolean isDefault) {
    }

    private record Column(String columnName, String columnType, int columnSize, String nullable, boolean binary) {
    }

    private record Table(String tableSchema, String tableName, List<String> primaryKeys, List<Column> columns) {
    }

    private record DataSet(List<String> cols, List<Map<String, String>> data, String error, String message, int totalNumberOfElements) {
    }
}

