/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.deployment.devui;

import io.quarkus.agroal.runtime.DataSourcesJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.dev.ui.DatabaseInspector;
import io.quarkus.assistant.runtime.dev.Assistant;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;

@BuildSteps(onlyIf={IsLocalDevelopment.class})
class AgroalDevUIProcessor {
    private static final String USER_MESSAGE = "Given the provided sql script:\n{{currentInsertScript}}\nCan you add 10 more inserts into the script and return the result\n(including the provided entries, so update the script)\nReturn the result in a field called `script`.\n";

    AgroalDevUIProcessor() {
    }

    @BuildStep
    void devUI(DataSourcesJdbcBuildTimeConfig config, BuildProducer<CardPageBuildItem> cardPageProducer, LaunchModeBuildItem launchMode) {
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        cardPageBuildItem.setLogo("agroal_logo_dark.png", "agroal_logo_light.png");
        if (launchMode.getDevModeType().isPresent() && ((DevModeType)launchMode.getDevModeType().get()).equals((Object)DevModeType.LOCAL) && config.devui().enabled()) {
            cardPageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:database")).title("Database view")).componentLink("qwc-agroal-datasource.js").metadata("allowSql", String.valueOf(config.devui().allowSql()))).metadata("appendSql", config.devui().appendToDefaultSelect().orElse(""))).metadata("allowedHost", (String)config.devui().allowedDBHost().orElse(null)));
        }
        cardPageProducer.produce((BuildItem)cardPageBuildItem);
    }

    @BuildStep
    void createBuildTimeActions(BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer) {
        BuildTimeActionBuildItem bta = new BuildTimeActionBuildItem();
        bta.addAssistantAction("generateMoreData", (a, p) -> {
            Assistant assistant = (Assistant)a;
            return assistant.assistBuilder().userMessage(USER_MESSAGE).variables(p).assist();
        });
        buildTimeActionProducer.produce((BuildItem)bta);
    }

    @BuildStep
    JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem(DatabaseInspector.class);
    }
}

