/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit5.virtual.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Consumer;
import jdk.jfr.EventSettings;
import jdk.jfr.consumer.RecordedEvent;
import org.junit.jupiter.api.function.ThrowingSupplier;

public class EventStreamFacade {
    public static final String CARRIER_PINNED_EVENT_NAME = "jdk.VirtualThreadPinned";
    public static final boolean available;
    private static final MethodHandle constructor;
    private static final MethodHandle enableMethod;
    private static final MethodHandle stopMethod;
    private static final MethodHandle startAsyncMethod;
    private static final MethodHandle setMaxSizeMethod;
    private static final MethodHandle setOrderedMethod;
    private static final MethodHandle onEventMethod;
    private final Object stream;

    public EventStreamFacade() {
        try {
            this.stream = constructor.invoke();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T invoke(ThrowingSupplier<T> invocation) {
        if (!available) {
            throw new UnsupportedOperationException("Stream recording not configured correctly, make sure you use Java 14+");
        }
        try {
            return (T)invocation.get();
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to invoke event stream method", e);
        }
    }

    public EventSettings enable(String event) {
        return (EventSettings)this.invoke(() -> enableMethod.invoke(this.stream, event));
    }

    public void startAsync() {
        this.invoke(() -> startAsyncMethod.invoke(this.stream));
    }

    public void setMaxSize(int max) {
        this.invoke(() -> setMaxSizeMethod.invoke(this.stream, max));
    }

    public void setOrdered(boolean ordered) {
        this.invoke(() -> setOrderedMethod.invoke(this.stream, ordered));
    }

    public void onEvent(Consumer<RecordedEvent> consumer) {
        this.invoke(() -> onEventMethod.invoke(this.stream, consumer));
    }

    public boolean stop() {
        return (Boolean)this.invoke(() -> stopMethod.invoke(this.stream));
    }

    static {
        boolean en;
        MethodHandle tempConstructor = null;
        MethodHandle tempEnable = null;
        MethodHandle tempStartAsync = null;
        MethodHandle tempStop = null;
        MethodHandle tempSetMaxSize = null;
        MethodHandle tempSetOrdered = null;
        MethodHandle tempOnEvent = null;
        try {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            Class<?> clazz = EventStreamFacade.class.getClassLoader().loadClass("jdk.jfr.consumer.RecordingStream");
            tempConstructor = lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE));
            tempEnable = lookup.findVirtual(clazz, "enable", MethodType.methodType(EventSettings.class, String.class));
            tempSetMaxSize = lookup.findVirtual(clazz, "setMaxSize", MethodType.methodType(Void.TYPE, Long.TYPE));
            tempSetOrdered = lookup.findVirtual(clazz, "setOrdered", MethodType.methodType(Void.TYPE, Boolean.TYPE));
            tempOnEvent = lookup.findVirtual(clazz, "onEvent", MethodType.methodType(Void.TYPE, Consumer.class));
            tempStartAsync = lookup.findVirtual(clazz, "startAsync", MethodType.methodType(Void.TYPE));
            tempStop = lookup.findVirtual(clazz, "stop", MethodType.methodType(Boolean.TYPE));
            en = true;
        }
        catch (Throwable e) {
            en = false;
        }
        available = en;
        constructor = tempConstructor;
        enableMethod = tempEnable;
        startAsyncMethod = tempStartAsync;
        stopMethod = tempStop;
        setMaxSizeMethod = tempSetMaxSize;
        setOrderedMethod = tempSetOrdered;
        onEventMethod = tempOnEvent;
    }
}

