/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.handshake;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.undertow.websockets.ConfiguredServerEndpoint;
import io.undertow.websockets.UndertowSession;
import io.undertow.websockets.handshake.ExchangeHandshakeRequest;
import io.undertow.websockets.handshake.ExchangeHandshakeResponse;
import io.undertow.websockets.handshake.Handshake;
import io.undertow.websockets.handshake.WebSocketHttpExchange;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class HandshakeUtil {
    private static final String CONFIG_KEY = "ServerEndpointConfiguration";
    public static final String PATH_PARAMS = Handshake.class.getName() + ".PATH_PARAMS";
    public static final String PRINCIPAL = Handshake.class.getName() + ".PRINCIPAL";

    private HandshakeUtil() {
    }

    public static boolean checkOrigin(ServerEndpointConfig config, WebSocketHttpExchange exchange) {
        ServerEndpointConfig.Configurator c = config.getConfigurator();
        return c.checkOrigin(exchange.getRequestHeader(HttpHeaderNames.ORIGIN.toString()));
    }

    public static void prepareUpgrade(ServerEndpointConfig config, WebSocketHttpExchange exchange) {
        ExchangeHandshakeRequest request = new ExchangeHandshakeRequest(exchange);
        ExchangeHandshakeResponse response = new ExchangeHandshakeResponse(exchange);
        ServerEndpointConfig.Configurator c = config.getConfigurator();
        c.modifyHandshake(config, (HandshakeRequest)request, (HandshakeResponse)response);
        response.update();
    }

    public static void setConfig(UndertowSession channel, ConfiguredServerEndpoint config) {
        channel.setConfiguredServerEndpoint(config);
    }

    public static ConfiguredServerEndpoint getConfig(UndertowSession channel) {
        return channel.getConfiguredServerEndpoint();
    }

    static String selectSubProtocol(ConfiguredServerEndpoint config, String[] requestedSubprotocolArray) {
        if (config.getEndpointConfiguration().getConfigurator() != null) {
            return config.getEndpointConfiguration().getConfigurator().getNegotiatedSubprotocol(config.getEndpointConfiguration().getSubprotocols(), Arrays.asList(requestedSubprotocolArray));
        }
        for (String protocol : config.getEndpointConfiguration().getSubprotocols()) {
            for (String clientsupported : requestedSubprotocolArray) {
                if (!protocol.equals(clientsupported)) continue;
                return protocol;
            }
        }
        return null;
    }

    static List<Extension> selectExtensions(ConfiguredServerEndpoint config, List<Extension> requestedExtensions) {
        if (config.getEndpointConfiguration().getConfigurator() != null) {
            return config.getEndpointConfiguration().getConfigurator().getNegotiatedExtensions(config.getExtensions(), requestedExtensions);
        }
        return Collections.emptyList();
    }
}

