/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker13;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.undertow.websockets.WebSocketClientCompressionHandler;
import io.undertow.websockets.WebSocketClientNegotiation;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

class WebsocketConnectionBuilder {
    private final URI uri;
    private final EventLoopGroup eventLoopGroup;
    private SSLContext ssl;
    private InetSocketAddress bindAddress;
    private WebSocketVersion version = WebSocketVersion.V13;
    private WebSocketClientNegotiation clientNegotiation;
    private URI proxyUri;
    private SslContext proxySsl;
    private final int maxFrameSize;

    public WebsocketConnectionBuilder(URI uri, EventLoopGroup eventLoopGroup, int maxFrameSize) {
        this.uri = uri;
        this.eventLoopGroup = eventLoopGroup;
        this.maxFrameSize = maxFrameSize;
    }

    public URI getUri() {
        return this.uri;
    }

    public SSLContext getSsl() {
        return this.ssl;
    }

    public WebsocketConnectionBuilder setSsl(SSLContext ssl) {
        this.ssl = ssl;
        return this;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public WebsocketConnectionBuilder setBindAddress(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public WebSocketVersion getVersion() {
        return this.version;
    }

    public WebsocketConnectionBuilder setVersion(WebSocketVersion version) {
        this.version = version;
        return this;
    }

    public WebSocketClientNegotiation getClientNegotiation() {
        return this.clientNegotiation;
    }

    public WebsocketConnectionBuilder setClientNegotiation(WebSocketClientNegotiation clientNegotiation) {
        this.clientNegotiation = clientNegotiation;
        return this;
    }

    public URI getProxyUri() {
        return this.proxyUri;
    }

    public WebsocketConnectionBuilder setProxyUri(URI proxyUri) {
        this.proxyUri = proxyUri;
        return this;
    }

    public SslContext getProxySsl() {
        return this.proxySsl;
    }

    public WebsocketConnectionBuilder setProxySsl(SslContext proxySsl) {
        this.proxySsl = proxySsl;
        return this;
    }

    public <R> CompletableFuture<R> connect(Function<Channel, R> connectFunction) {
        Bootstrap b = new Bootstrap();
        final int actualPort = this.uri.getPort() == -1 ? (this.uri.getScheme().equals("wss") ? 443 : 80) : this.uri.getPort();
        final WebSocketClientHandler<R> handler = new WebSocketClientHandler<R>((WebSocketClientHandshaker)new WebSocketClientHandshaker13(this.uri, WebSocketVersion.V13, null, !this.clientNegotiation.getSupportedExtensions().isEmpty(), HttpHeaders.EMPTY_HEADERS, this.maxFrameSize){

            protected FullHttpRequest newHandshakeRequest() {
                int i;
                StringBuilder sb;
                FullHttpRequest request = super.newHandshakeRequest();
                if (WebsocketConnectionBuilder.this.clientNegotiation.getSupportedSubProtocols() != null) {
                    sb = new StringBuilder();
                    for (i = 0; i < WebsocketConnectionBuilder.this.clientNegotiation.getSupportedSubProtocols().size(); ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(WebsocketConnectionBuilder.this.clientNegotiation.getSupportedSubProtocols().get(i));
                    }
                    if (sb.length() > 0) {
                        request.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)sb.toString());
                    }
                }
                if (WebsocketConnectionBuilder.this.clientNegotiation.getSupportedExtensions() != null) {
                    sb = new StringBuilder();
                    for (i = 0; i < WebsocketConnectionBuilder.this.clientNegotiation.getSupportedExtensions().size(); ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        WebSocketExtensionData data = WebsocketConnectionBuilder.this.clientNegotiation.getSupportedExtensions().get(i);
                        sb.append(data.name());
                        for (Map.Entry parameter : data.parameters().entrySet()) {
                            sb.append(";");
                            sb.append((String)parameter.getKey());
                            if (parameter.getValue() == null) continue;
                            sb.append("=");
                            sb.append((String)parameter.getValue());
                        }
                    }
                    if (sb.length() > 0) {
                        request.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)sb.toString());
                    }
                }
                WebsocketConnectionBuilder.this.clientNegotiation.beforeRequest(request.headers());
                return request;
            }

            protected void verify(FullHttpResponse response) {
                super.verify(response);
                WebsocketConnectionBuilder.this.clientNegotiation.afterRequest(response.headers());
            }
        }, connectFunction);
        ((Bootstrap)((Bootstrap)b.group(this.determineEventLoopGroup())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (WebsocketConnectionBuilder.this.ssl != null) {
                    SSLEngine sslEngine = WebsocketConnectionBuilder.this.ssl.createSSLEngine(WebsocketConnectionBuilder.this.uri.getHost(), actualPort);
                    sslEngine.setUseClientMode(true);
                    pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                }
                pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
                pipeline.addLast("extensions-handler", (ChannelHandler)WebSocketClientCompressionHandler.INSTANCE);
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("ws-handler", (ChannelHandler)handler);
            }
        });
        b.connect(this.uri.getHost(), actualPort).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.cause() != null) {
                    handler.handshakeFuture.completeExceptionally(future.cause());
                }
            }
        });
        return handler.handshakeFuture;
    }

    private EventLoopGroup determineEventLoopGroup() {
        if (NioEventLoopGroup.class.equals(this.eventLoopGroup.getClass())) {
            return this.eventLoopGroup;
        }
        return new NioEventLoopGroup();
    }

    private class WebSocketClientHandler<R>
    extends SimpleChannelInboundHandler<Object> {
        private final WebSocketClientHandshaker handshaker;
        private final CompletableFuture<R> handshakeFuture = new CompletableFuture();
        private final Function<Channel, R> connectFunction;

        public WebSocketClientHandler(WebSocketClientHandshaker handshaker, Function<Channel, R> connectFunction) {
            this.handshaker = handshaker;
            this.connectFunction = connectFunction;
        }

        public CompletableFuture<R> handshakeFuture() {
            return this.handshakeFuture;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.handshaker.handshake(ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            this.handshakeFuture.completeExceptionally(new ClosedChannelException());
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            Channel ch = ctx.channel();
            if (!this.handshaker.isHandshakeComplete()) {
                try {
                    this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
                    this.handshakeFuture.complete(this.connectFunction.apply(ch));
                    ch.pipeline().remove((ChannelHandler)this);
                }
                catch (Exception e) {
                    this.handshakeFuture.completeExceptionally(e);
                }
                return;
            }
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ")");
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (!this.handshakeFuture.isDone()) {
                this.handshakeFuture.completeExceptionally(cause);
            }
            ctx.close();
        }
    }
}

