/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import io.undertow.websockets.JsrWebSocketLogger;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class OrderedExecutor
implements Executor {
    private final Deque<Runnable> tasks = new ConcurrentLinkedDeque<Runnable>();
    private final Executor delegate;
    private final ExecutorTask task = new ExecutorTask();
    private volatile int state = 0;
    private static final AtomicIntegerFieldUpdater<OrderedExecutor> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(OrderedExecutor.class, "state");
    private static final int STATE_NOT_RUNNING = 0;
    private static final int STATE_RUNNING = 1;

    public OrderedExecutor(Executor delegate) {
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable command) {
        this.tasks.add(command);
        if (stateUpdater.get(this) == 0) {
            this.delegate.execute(this.task);
        }
    }

    private final class ExecutorTask
    implements Runnable {
        private ExecutorTask() {
        }

        @Override
        public void run() {
            do {
                if (stateUpdater.compareAndSet(OrderedExecutor.this, 0, 1)) {
                    Runnable task = OrderedExecutor.this.tasks.poll();
                    while (task != null) {
                        try {
                            task.run();
                        }
                        catch (Throwable e) {
                            JsrWebSocketLogger.REQUEST_LOGGER.exceptionInWebSocketMethod(e);
                        }
                        task = OrderedExecutor.this.tasks.poll();
                    }
                } else {
                    return;
                }
                stateUpdater.set(OrderedExecutor.this, 0);
            } while (!OrderedExecutor.this.tasks.isEmpty());
        }
    }
}

