/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import jakarta.websocket.Session;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionContainer {
    private Runnable doneTask;
    private volatile int waiterCount;
    private final Set<Session> openSessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public Set<Session> getOpenSessions() {
        return Collections.unmodifiableSet(this.openSessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOpenSession(Session session) {
        SessionContainer sessionContainer = this;
        synchronized (sessionContainer) {
            this.openSessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOpenSession(Session session) {
        Runnable task = null;
        SessionContainer sessionContainer = this;
        synchronized (sessionContainer) {
            this.openSessions.remove(session);
            if (this.waiterCount > 0 && this.openSessions.isEmpty()) {
                this.notifyAll();
            }
            if (this.doneTask != null) {
                task = this.doneTask;
                this.doneTask = null;
            }
        }
        if (task != null) {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitClose(long timeout) {
        SessionContainer sessionContainer = this;
        synchronized (sessionContainer) {
            if (this.openSessions.isEmpty()) {
                return;
            }
            ++this.waiterCount;
            long end = System.currentTimeMillis() + timeout;
            try {
                while (System.currentTimeMillis() < end && !this.openSessions.isEmpty()) {
                    this.wait(end - System.currentTimeMillis());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                --this.waiterCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClosed(Runnable done) {
        boolean run = false;
        SessionContainer sessionContainer = this;
        synchronized (sessionContainer) {
            if (this.openSessions.isEmpty()) {
                run = true;
            } else {
                this.doneTask = done;
            }
        }
        if (run) {
            done.run();
        }
    }
}

