/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.handshake;

import io.undertow.websockets.handshake.HandshakeUtil;
import io.undertow.websockets.handshake.WebSocketHttpExchange;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.server.HandshakeRequest;

public final class ExchangeHandshakeRequest
implements HandshakeRequest {
    private final WebSocketHttpExchange exchange;
    private Map<String, List<String>> headers;

    public ExchangeHandshakeRequest(WebSocketHttpExchange exchange) {
        this.exchange = exchange;
    }

    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            this.headers = this.exchange.getRequestHeaders();
        }
        return this.headers;
    }

    public Principal getUserPrincipal() {
        return this.exchange.getUserPrincipal();
    }

    public URI getRequestURI() {
        return URI.create(this.exchange.getRequestURI());
    }

    public boolean isUserInRole(String role) {
        return this.exchange.isUserInRole(role);
    }

    public Object getHttpSession() {
        return this.exchange.getSession();
    }

    public Map<String, List<String>> getParameterMap() {
        HashMap requestParameters = new HashMap();
        for (Map.Entry<String, List<String>> e : this.exchange.getRequestParameters().entrySet()) {
            ArrayList list = (ArrayList)requestParameters.get(e.getKey());
            if (list == null) {
                list = new ArrayList();
                requestParameters.put(e.getKey(), list);
            }
            list.addAll(e.getValue());
        }
        Map pathParms = (Map)this.exchange.getAttachment(HandshakeUtil.PATH_PARAMS);
        if (pathParms != null) {
            for (Map.Entry e : pathParms.entrySet()) {
                ArrayList list = (ArrayList)requestParameters.get(e.getKey());
                if (list == null) {
                    list = new ArrayList();
                    requestParameters.put((String)e.getKey(), list);
                }
                list.add(e.getValue());
            }
        }
        return Collections.unmodifiableMap(requestParameters);
    }

    public String getQueryString() {
        return this.exchange.getQueryString();
    }
}

