/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.undertow.websockets.ServerWebSocketContainer;
import io.undertow.websockets.util.ImmediateObjectHandle;
import io.undertow.websockets.util.ObjectFactory;
import io.undertow.websockets.util.ObjectHandle;
import io.undertow.websockets.util.ObjectIntrospecter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;

public class UndertowContainerProvider
extends ContainerProvider {
    private static final boolean directBuffers = Boolean.getBoolean("io.undertow.websockets.direct-buffers");
    private static final boolean invokeInIoThread = Boolean.getBoolean("io.undertow.websockets.invoke-in-io-thread");
    private static final RuntimePermission PERMISSION = new RuntimePermission("io.undertow.websockets.jsr.MODIFY_WEBSOCKET_CONTAINER");
    private static final Map<ClassLoader, WebSocketContainer> webSocketContainers = new ConcurrentHashMap<ClassLoader, WebSocketContainer>();
    private static volatile ServerWebSocketContainer defaultContainer;
    private static volatile boolean defaultContainerDisabled;
    private static volatile EventLoopGroup defaultEventLoopGroup;
    private static final SwitchableObjectIntrospector defaultIntrospector;

    protected WebSocketContainer getContainer() {
        ClassLoader tccl = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        WebSocketContainer webSocketContainer = webSocketContainers.get(tccl);
        if (webSocketContainer == null) {
            return UndertowContainerProvider.getDefaultContainer();
        }
        return webSocketContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServerWebSocketContainer getDefaultContainer() {
        if (defaultContainerDisabled) {
            return null;
        }
        if (defaultContainer != null) {
            return defaultContainer;
        }
        Class<UndertowContainerProvider> clazz = UndertowContainerProvider.class;
        synchronized (UndertowContainerProvider.class) {
            if (defaultContainer == null) {
                Supplier<EventLoopGroup> supplier = new Supplier<EventLoopGroup>(){

                    @Override
                    public EventLoopGroup get() {
                        return UndertowContainerProvider.getDefaultEventLoopGroup();
                    }
                };
                defaultContainer = new ServerWebSocketContainer(defaultIntrospector, UndertowContainerProvider.class.getClassLoader(), supplier, Collections.EMPTY_LIST, !invokeInIoThread, new Supplier<Executor>(){

                    @Override
                    public Executor get() {
                        return GlobalEventExecutor.INSTANCE;
                    }
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventLoopGroup getDefaultEventLoopGroup() {
        if (defaultEventLoopGroup != null) return defaultEventLoopGroup;
        Class<UndertowContainerProvider> clazz = UndertowContainerProvider.class;
        synchronized (UndertowContainerProvider.class) {
            if (defaultEventLoopGroup != null) return defaultEventLoopGroup;
            defaultEventLoopGroup = new NioEventLoopGroup();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultEventLoopGroup;
        }
    }

    public static void addContainer(ClassLoader classLoader, WebSocketContainer webSocketContainer) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION);
        }
        webSocketContainers.put(classLoader, webSocketContainer);
    }

    public static void setDefaultContainer(ServerWebSocketContainer container) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION);
        }
        defaultContainer = container;
    }

    public static void removeContainer(ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION);
        }
        webSocketContainers.remove(classLoader);
    }

    public void setDefaultClassIntrospector(ObjectIntrospecter classIntrospector) {
        if (classIntrospector == null) {
            throw new IllegalArgumentException();
        }
        defaultIntrospector.setIntrospecter(classIntrospector);
    }

    public static void disableDefaultContainer() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION);
        }
        defaultContainerDisabled = true;
    }

    static {
        defaultContainerDisabled = false;
        defaultIntrospector = new SwitchableObjectIntrospector();
    }

    private static class SwitchableObjectIntrospector
    implements ObjectIntrospecter {
        private volatile ObjectIntrospecter introspecter = new ObjectIntrospecter(){

            @Override
            public <T> ObjectFactory<T> createInstanceFactory(final Class<T> clazz) {
                return new ObjectFactory<T>(){

                    @Override
                    public ObjectHandle<T> createInstance() {
                        try {
                            return new ImmediateObjectHandle(clazz.newInstance());
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };

        private SwitchableObjectIntrospector() {
        }

        @Override
        public <T> ObjectFactory<T> createInstanceFactory(Class<T> clazz) {
            return this.introspecter.createInstanceFactory(clazz);
        }

        public void setIntrospecter(ObjectIntrospecter introspecter) {
            this.introspecter = introspecter;
        }
    }
}

