/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.websocket.Extension;

public class ExtensionImpl
implements Extension {
    private final WebSocketExtensionData data;
    private final List<Extension.Parameter> parameters = new ArrayList<Extension.Parameter>();

    public ExtensionImpl(WebSocketExtensionData data) {
        this.data = data;
        for (Map.Entry i : data.parameters().entrySet()) {
            this.parameters.add(new ParameterImpl((String)i.getKey(), (String)i.getValue()));
        }
    }

    public WebSocketExtensionData getData() {
        return this.data;
    }

    public String getName() {
        return this.data.name();
    }

    public List<Extension.Parameter> getParameters() {
        return this.parameters;
    }

    public static class ParameterImpl
    implements Extension.Parameter {
        private final String name;
        private final String value;

        public ParameterImpl(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

