/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.cmd.DeployCommandActionResultBuildItem;
import io.quarkus.deployment.cmd.DeployCommandDeclarationHandler;
import io.quarkus.deployment.cmd.DeployCommandDeclarationResultBuildItem;
import io.quarkus.deployment.cmd.DeployCommandHandler;
import io.quarkus.deployment.util.DeploymentUtil;
import io.quarkus.gradle.tasks.QuarkusBuildTask;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class Deploy
extends QuarkusBuildTask {
    @Input
    Optional<String> deployer = Optional.empty();
    boolean imageBuild = false;
    Optional<String> imageBuilder = Optional.empty();

    @Option(option="deployer", description="The deployer to use")
    public void setDeployer(String deployer) {
        this.deployer = Optional.ofNullable(deployer);
    }

    @Option(option="image-build", description="Perform an image build before deployment")
    public void setImageBuild(boolean imageBuild) {
        this.imageBuild = imageBuild;
    }

    @Option(option="image-builder", description="Perform an image build using the selected builder before deployment")
    public void setImageBuilder(String imageBuilder) {
        this.imageBuilder = Optional.ofNullable(imageBuilder);
        this.imageBuild = true;
    }

    @Inject
    public Deploy() {
        super("Deploy");
    }

    @TaskAction
    public void checkRequiredExtensions() {
        ApplicationModel appModel = this.resolveAppModelForBuild();
        Properties sysProps = new Properties();
        sysProps.putAll(this.extension().buildEffectiveConfiguration(appModel.getAppArtifact()).getValues());
        try (CuratedApplication curatedApplication = QuarkusBootstrap.builder().setBaseClassLoader(((Object)((Object)this)).getClass().getClassLoader()).setExistingModel(appModel).setTargetDirectory(this.getProject().getBuildDir().toPath()).setBaseName(this.extension().finalName()).setBuildSystemProperties(sysProps).setAppArtifact(appModel.getAppArtifact()).setLocalProjectDiscovery(Boolean.valueOf(false)).setIsolateDeployment(true).build().bootstrap();){
            final AtomicReference tooMany = new AtomicReference();
            AugmentAction action = curatedApplication.createAugmentor();
            action.performCustomBuild(DeployCommandDeclarationHandler.class.getName(), (Object)new Consumer<List<String>>(){

                @Override
                public void accept(List<String> strings) {
                    tooMany.set(strings);
                }
            }, new String[]{DeployCommandDeclarationResultBuildItem.class.getName()});
            String target = System.getProperty("quarkus.deploy.target");
            List targets = (List)tooMany.get();
            if (targets.isEmpty() && target == null) {
                List unsatisfied;
                Deployer deployer = this.getDeployer();
                this.extension().forcedPropertiesProperty().convention(this.getProject().provider(() -> {
                    HashMap<Object, String> props = new HashMap<Object, String>();
                    props.put("quarkus." + deployer.name() + ".deploy", "true");
                    props.put("quarkus.container-image.build", String.valueOf(this.imageBuilder.isPresent() || this.imageBuild));
                    this.imageBuilder.ifPresent(b -> props.put("quarkus.container-image.builder", (String)b));
                    return props;
                }));
                String requiredDeployerExtension = deployer.getExtension();
                Optional<String> requiredContainerImageExtension = this.requiredContainerImageExtension();
                List projectDependencies = this.getProject().getConfigurations().stream().flatMap(c -> c.getDependencies().stream()).map(d -> d.getName()).collect(Collectors.toList());
                if (!projectDependencies.contains(requiredDeployerExtension)) {
                    this.abort("Task: {} requires extensions: {}\nTo add the extensions to the project you can run the following command:\n\tgradle addExtension --extensions={}", this.getName(), requiredDeployerExtension, requiredDeployerExtension);
                } else if (!requiredContainerImageExtension.map(b -> projectDependencies.stream().anyMatch(d -> d.equals(b))).orElse(true).booleanValue()) {
                    this.abort("Task: {} using: {} is explicitly configured with missing container image builder extension: {}. Aborting.", this.getName(), deployer.name(), requiredContainerImageExtension.get());
                } else if (this.imageBuild && deployer.getRequiresOneOf().length > 0 && (unsatisfied = Arrays.stream(deployer.requiresOneOf).filter(r -> !projectDependencies.stream().anyMatch(d -> d.equals(r))).collect(Collectors.toList())).size() == deployer.getRequiresOneOf().length) {
                    this.abort("Task: {} using: {} requires one of the following container image extensions: {}. Aborting.", this.getName(), deployer.name(), unsatisfied.stream().collect(Collectors.joining(", ", "[", "]")));
                }
                return;
            }
            if (targets.size() > 1 && target == null) {
                this.abort("Too many installed extensions support quarkus:deploy.  You must choose one by setting quarkus.deploy.target. Extensions: " + targets.stream().collect(Collectors.joining(" ")), new Object[0]);
            } else if (target != null && !targets.contains(target)) {
                this.abort("Unknown quarkus.deploy.target: " + target + " Extensions: " + targets.stream().collect(Collectors.joining(" ")), new Object[0]);
            } else {
                this.extension().forcedPropertiesProperty().convention(this.getProject().provider(() -> {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("quarkus.ignore.legacy.deploy.build", "true");
                    return props;
                }));
                if (target == null) {
                    target = (String)targets.get(0);
                }
                AugmentAction deployAction = curatedApplication.createAugmentor();
                this.getLogger().info("Deploy target: " + target);
                System.setProperty("quarkus.deploy.target", target);
                deployAction.performCustomBuild(DeployCommandHandler.class.getName(), (Object)new Consumer<Boolean>(){

                    @Override
                    public void accept(Boolean success) {
                    }
                }, new String[]{DeployCommandActionResultBuildItem.class.getName()});
            }
        }
        catch (BootstrapException ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            this.abort("Failed to run deploy", new Object[0]);
            return;
        }
    }

    public Deployer getDeployer() {
        return this.getDeployer(Deployer.kubernetes);
    }

    public Deployer getDeployer(Deployer defaultDeployer) {
        return this.deployer.or(() -> DeploymentUtil.getEnabledDeployer()).or(() -> this.getProjectDeployers().stream().findFirst()).map(Deployer::valueOf).orElse(defaultDeployer);
    }

    public Optional<String> requiredContainerImageExtension() {
        return this.imageBuilder.map(b -> "quarkus-container-image-" + b).or(() -> this.imageBuild ? Arrays.stream(this.getDeployer().requiresOneOf).findFirst() : Optional.empty());
    }

    private Set<String> getProjectDeployers() {
        return this.getProject().getConfigurations().stream().flatMap(c -> c.getDependencies().stream()).map(d -> d.getName()).filter(d -> Arrays.stream(Deployer.values()).map(Deployer::getExtension).anyMatch(e -> d.equals(e))).map(d -> d.replaceAll("^quarkus\\-", "")).collect(Collectors.toSet());
    }

    public static enum Deployer {
        kubernetes("quarkus-kubernetes", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        minikube("quarkus-minikube", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        kind("quarkus-kind", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        knative("quarkus-kubernetes", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        openshift("quarkus-openshift", new String[0]);

        private final String extension;
        private final String[] requiresOneOf;

        private Deployer(String extension, String ... requiresOneOf) {
            this.extension = extension;
            this.requiresOneOf = requiresOneOf;
        }

        public String getExtension() {
            return this.extension;
        }

        public String[] getRequiresOneOf() {
            return this.requiresOneOf;
        }
    }
}

