/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationsOverlay;
import io.quarkus.arc.processor.bcextensions.DeclarationInfoImpl;
import io.quarkus.arc.processor.bcextensions.MethodInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.util.Objects;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodParameterInfo;

class ParameterInfoImpl
extends DeclarationInfoImpl<MethodParameterInfo>
implements ParameterInfo {
    private final MethodInfoImpl method;
    private final short position;

    ParameterInfoImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, MethodParameterInfo jandexDeclaration) {
        super(jandexIndex, annotationOverlays, jandexDeclaration);
        this.method = new MethodInfoImpl(jandexIndex, annotationOverlays, jandexDeclaration.method());
        this.position = jandexDeclaration.position();
    }

    public String name() {
        String name = ((MethodParameterInfo)this.jandexDeclaration).name();
        return name != null ? name : "arg" + ((MethodParameterInfo)this.jandexDeclaration).position();
    }

    public Type type() {
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlays, ((MethodParameterInfo)this.jandexDeclaration).type());
    }

    public MethodInfo declaringMethod() {
        return new MethodInfoImpl(this.jandexIndex, this.annotationOverlays, ((MethodParameterInfo)this.jandexDeclaration).method());
    }

    @Override
    public String toString() {
        return "parameter " + this.name() + " of method " + String.valueOf(((MethodParameterInfo)this.jandexDeclaration).method());
    }

    @Override
    AnnotationsOverlay<MethodParameterInfo> annotationsOverlay() {
        return this.annotationOverlays.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterInfoImpl that = (ParameterInfoImpl)o;
        return this.position == that.position && Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.position);
    }
}

