/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationMember;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.IndexView;

class AnnotationMemberImpl
implements AnnotationMember {
    final IndexView jandexIndex;
    final AllAnnotationOverlays annotationOverlays;
    final AnnotationMember.Kind kind;
    final AnnotationValue jandexAnnotationMember;

    AnnotationMemberImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, AnnotationValue jandexAnnotationMember) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlays = annotationOverlays;
        this.kind = AnnotationMemberImpl.determineKind(jandexAnnotationMember);
        this.jandexAnnotationMember = jandexAnnotationMember;
    }

    private static AnnotationMember.Kind determineKind(AnnotationValue value) {
        switch (value.kind()) {
            case BOOLEAN: {
                return AnnotationMember.Kind.BOOLEAN;
            }
            case BYTE: {
                return AnnotationMember.Kind.BYTE;
            }
            case SHORT: {
                return AnnotationMember.Kind.SHORT;
            }
            case INTEGER: {
                return AnnotationMember.Kind.INT;
            }
            case LONG: {
                return AnnotationMember.Kind.LONG;
            }
            case FLOAT: {
                return AnnotationMember.Kind.FLOAT;
            }
            case DOUBLE: {
                return AnnotationMember.Kind.DOUBLE;
            }
            case CHARACTER: {
                return AnnotationMember.Kind.CHAR;
            }
            case STRING: {
                return AnnotationMember.Kind.STRING;
            }
            case ENUM: {
                return AnnotationMember.Kind.ENUM;
            }
            case CLASS: {
                return AnnotationMember.Kind.CLASS;
            }
            case NESTED: {
                return AnnotationMember.Kind.NESTED_ANNOTATION;
            }
            case ARRAY: {
                return AnnotationMember.Kind.ARRAY;
            }
        }
        throw new IllegalArgumentException("Unknown annotation member " + String.valueOf(value));
    }

    private void checkKind(AnnotationMember.Kind kind) {
        if (this.kind != kind) {
            throw new IllegalStateException("Not " + String.valueOf(kind) + ": " + String.valueOf(this.jandexAnnotationMember));
        }
    }

    public AnnotationMember.Kind kind() {
        return this.kind;
    }

    public boolean asBoolean() {
        this.checkKind(AnnotationMember.Kind.BOOLEAN);
        return this.jandexAnnotationMember.asBoolean();
    }

    public byte asByte() {
        this.checkKind(AnnotationMember.Kind.BYTE);
        return this.jandexAnnotationMember.asByte();
    }

    public short asShort() {
        this.checkKind(AnnotationMember.Kind.SHORT);
        return this.jandexAnnotationMember.asShort();
    }

    public int asInt() {
        this.checkKind(AnnotationMember.Kind.INT);
        return this.jandexAnnotationMember.asInt();
    }

    public long asLong() {
        this.checkKind(AnnotationMember.Kind.LONG);
        return this.jandexAnnotationMember.asLong();
    }

    public float asFloat() {
        this.checkKind(AnnotationMember.Kind.FLOAT);
        return this.jandexAnnotationMember.asFloat();
    }

    public double asDouble() {
        this.checkKind(AnnotationMember.Kind.DOUBLE);
        return this.jandexAnnotationMember.asDouble();
    }

    public char asChar() {
        this.checkKind(AnnotationMember.Kind.CHAR);
        return this.jandexAnnotationMember.asChar();
    }

    public String asString() {
        this.checkKind(AnnotationMember.Kind.STRING);
        return this.jandexAnnotationMember.asString();
    }

    public <E extends Enum<E>> E asEnum(Class<E> enumType) {
        this.checkKind(AnnotationMember.Kind.ENUM);
        return Enum.valueOf(enumType, this.jandexAnnotationMember.asEnum());
    }

    public String asEnumConstant() {
        this.checkKind(AnnotationMember.Kind.ENUM);
        return this.jandexAnnotationMember.asEnum();
    }

    public ClassInfo asEnumClass() {
        this.checkKind(AnnotationMember.Kind.ENUM);
        return new ClassInfoImpl(this.jandexIndex, this.annotationOverlays, this.jandexIndex.getClassByName(this.jandexAnnotationMember.asEnumType()));
    }

    public Type asType() {
        this.checkKind(AnnotationMember.Kind.CLASS);
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlays, this.jandexAnnotationMember.asClass());
    }

    public AnnotationInfo asNestedAnnotation() {
        this.checkKind(AnnotationMember.Kind.NESTED_ANNOTATION);
        return new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, this.jandexAnnotationMember.asNested());
    }

    public List<AnnotationMember> asArray() {
        this.checkKind(AnnotationMember.Kind.ARRAY);
        return this.jandexAnnotationMember.asArrayList().stream().map(it -> new AnnotationMemberImpl(this.jandexIndex, this.annotationOverlays, (AnnotationValue)it)).collect(Collectors.toUnmodifiableList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationMemberImpl that = (AnnotationMemberImpl)o;
        return Objects.equals(this.jandexAnnotationMember.value(), that.jandexAnnotationMember.value());
    }

    public int hashCode() {
        return Objects.hash(this.jandexAnnotationMember.value());
    }

    public String toString() {
        return String.valueOf(this.jandexAnnotationMember.value());
    }
}

