/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableObserverMethod;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.Mockable;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.RuntimeTypeCreator;
import io.quarkus.arc.processor.SyntheticComponentsUtil;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.spi.EventContext;
import java.lang.annotation.Annotation;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;

public class ObserverGenerator
extends AbstractGenerator {
    static final String OBSERVER_SUFFIX = "_Observer";
    static final String OBSERVED_TYPE = "observedType";
    static final String QUALIFIERS = "qualifiers";
    static final String DECLARING_PROVIDER_SUPPLIER = "declaringProviderSupplier";
    private final Map<ObserverInfo, String> observerToGeneratedName;
    private final AnnotationLiteralProcessor annotationLiterals;
    private final Predicate<DotName> applicationClassPredicate;
    private final BeanProcessor.PrivateMembersCollector privateMembers;
    private final Set<String> existingClasses;
    private final Predicate<DotName> injectionPointAnnotationsPredicate;
    private final boolean mockable;
    private final ConcurrentMap<String, ObserverInfo> generatedClasses;

    public ObserverGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, BeanProcessor.PrivateMembersCollector privateMembers, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Map<ObserverInfo, String> observerToGeneratedName, Predicate<DotName> injectionPointAnnotationsPredicate, boolean mockable) {
        super(generateSources, reflectionRegistration);
        this.annotationLiterals = annotationLiterals;
        this.applicationClassPredicate = applicationClassPredicate;
        this.privateMembers = privateMembers;
        this.existingClasses = existingClasses;
        this.observerToGeneratedName = observerToGeneratedName;
        this.injectionPointAnnotationsPredicate = injectionPointAnnotationsPredicate;
        this.mockable = mockable;
        this.generatedClasses = new ConcurrentHashMap<String, ObserverInfo>();
    }

    void precomputeGeneratedName(ObserverInfo observer) {
        String classBase = observer.isSynthetic() ? observer.getBeanClass().withoutPackagePrefix() : observer.getObserverMethod().declaringClass().name().withoutPackagePrefix();
        StringBuilder baseNameBuilder = new StringBuilder();
        baseNameBuilder.append(classBase).append(OBSERVER_SUFFIX).append("_");
        if (observer.isSynthetic()) {
            baseNameBuilder.append("Synthetic");
        } else {
            baseNameBuilder.append(observer.getObserverMethod().name());
        }
        baseNameBuilder.append("_").append(observer.getIdentifier());
        String baseName = baseNameBuilder.toString();
        String targetPackage = observer.isSynthetic() ? DotNames.packagePrefix(observer.getBeanClass()) : DotNames.packagePrefix(observer.getObserverMethod().declaringClass().name());
        String generatedName = ObserverGenerator.generatedNameFromTarget(targetPackage, baseName, "");
        this.observerToGeneratedName.put(observer, generatedName);
    }

    Collection<ResourceOutput.Resource> generate(ObserverInfo observer) {
        String generatedName = this.observerToGeneratedName.get(observer);
        ObserverInfo generatedObserver = this.generatedClasses.putIfAbsent(generatedName, observer);
        if (generatedObserver != null) {
            if (observer.isSynthetic()) {
                throw new IllegalStateException("A synthetic observer with the generated class name " + generatedName + " already exists for " + String.valueOf(generatedObserver));
            }
            return Collections.emptyList();
        }
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(observer.getBeanClass()) || observer.isForceApplicationClass();
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.OBSERVER : null, this.generateSources);
        Gizmo gizmo = ObserverGenerator.gizmo(classOutput);
        this.createObserver(gizmo, observer, generatedName, isApplicationClass);
        return classOutput.getResources();
    }

    private void createObserver(Gizmo gizmo, ObserverInfo observer, String generatedName, boolean isApplicationClass) {
        gizmo.class_(generatedName, cc -> {
            cc.implements_(InjectableObserverMethod.class);
            if (this.mockable) {
                cc.implements_(Mockable.class);
            }
            FieldDesc observedType = cc.field(OBSERVED_TYPE, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Type.class);
            });
            FieldDesc observedQualifiers = null;
            if (!observer.getQualifiers().isEmpty()) {
                observedQualifiers = cc.field(QUALIFIERS, fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(Set.class);
                });
            }
            FieldDesc mock = null;
            if (this.mockable) {
                mock = cc.field("mock", fc -> {
                    fc.private_();
                    fc.volatile_();
                    fc.setType(Boolean.TYPE);
                });
            }
            FieldDesc declaringProvider = cc.field(DECLARING_PROVIDER_SUPPLIER, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Supplier.class);
            });
            HashMap<InjectionPointInfo, FieldDesc> injectionPointToProviderField = new HashMap<InjectionPointInfo, FieldDesc>();
            if (!observer.isSynthetic()) {
                int providerIdx = 1;
                for (InjectionPointInfo injectionPoint : observer.getInjection().injectionPoints) {
                    if (injectionPoint.getRequiredType().name().equals((Object)DotNames.EVENT_METADATA)) continue;
                    FieldDesc desc = cc.field("observerProviderSupplier" + providerIdx++, fc -> {
                        fc.private_();
                        fc.final_();
                        fc.setType(Supplier.class);
                    });
                    injectionPointToProviderField.put(injectionPoint, desc);
                }
            }
            this.generateConstructor((ClassCreator)cc, observer, observedType, observedQualifiers, mock, declaringProvider, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderField, this.annotationLiterals, this.reflectionRegistration);
            this.generateGetObservedType((ClassCreator)cc, observedType);
            if (observedQualifiers != null) {
                this.generateGetObservedQualifiers((ClassCreator)cc, observedQualifiers);
            }
            this.generateGetBeanClass((ClassCreator)cc, observer.getBeanClass());
            if (!observer.getTransactionPhase().equals((Object)TransactionPhase.IN_PROGRESS)) {
                this.generateGetTransactionPhase((ClassCreator)cc, observer);
            }
            if (observer.getReception() == Reception.IF_EXISTS) {
                this.generateGetReceptionIfExists((ClassCreator)cc);
            }
            if (observer.getPriority() != 2500) {
                this.generateGetPriority((ClassCreator)cc, observer);
            }
            if (observer.isAsync()) {
                this.generateIsAsync((ClassCreator)cc);
            }
            this.generateGetDeclaringBeanIdentifier((ClassCreator)cc, observer.getDeclaringBean());
            if (mock != null) {
                this.generateMockMethods((ClassCreator)cc, mock);
            }
            this.generateToString((ClassCreator)cc, observer);
            this.generateNotify((ClassCreator)cc, observer, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderField, this.reflectionRegistration, isApplicationClass, declaringProvider, mock);
        });
    }

    private void generateConstructor(ClassCreator cc, ObserverInfo observer, FieldDesc observedTypeField, FieldDesc observedQualifiersField, FieldDesc mockField, FieldDesc declaringProviderField, Map<InjectionPointInfo, FieldDesc> injectionPointToProviderField, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration) {
        cc.constructor(mc -> {
            ParamVar declaringProviderSupplier;
            HashMap<InjectionPointInfo, ParamVar> injectionPointSuppliers = new HashMap<InjectionPointInfo, ParamVar>();
            if (!observer.isSynthetic()) {
                declaringProviderSupplier = mc.parameter(DECLARING_PROVIDER_SUPPLIER, Supplier.class);
                for (InjectionPointInfo injectionPoint : observer.getInjection().injectionPoints) {
                    if (BuiltinBean.resolve(injectionPoint) != null) continue;
                    FieldDesc field = (FieldDesc)injectionPointToProviderField.get(injectionPoint);
                    assert (field != null);
                    injectionPointSuppliers.put(injectionPoint, mc.parameter(field.name(), Supplier.class));
                }
            } else {
                declaringProviderSupplier = null;
            }
            mc.body(bc -> {
                bc.invokeSpecial(MethodDescs.OBJECT_CONSTRUCTOR, (Expr)cc.this_());
                if (observer.isSynthetic()) {
                    SyntheticComponentsUtil.addParamsFieldAndInit(cc, bc, observer.getParams(), annotationLiterals, observer.getBeanDeployment().getBeanArchiveIndex());
                } else {
                    bc.set((Assignable)cc.this_().field(declaringProviderField), (Expr)declaringProviderSupplier);
                    for (InjectionPointInfo injectionPoint : observer.getInjection().injectionPoints) {
                        ParamVar supplier;
                        ParamVar injectionPointParam = (ParamVar)injectionPointSuppliers.get(injectionPoint);
                        if (injectionPointParam == null) {
                            assert (injectionPoint.getResolvedBean() == null);
                            BuiltinBean builtinBean = BuiltinBean.resolve(injectionPoint);
                            assert (builtinBean != null);
                            FieldDesc providerField = (FieldDesc)injectionPointToProviderField.get(injectionPoint);
                            builtinBean.getGenerator().generate(new BuiltinBean.GeneratorContext(observer.getDeclaringBean().getDeployment(), observer, injectionPoint, cc, (BlockCreator)bc, providerField, annotationLiterals, reflectionRegistration, this.injectionPointAnnotationsPredicate, declaringProviderSupplier));
                            continue;
                        }
                        if (injectionPoint.isCurrentInjectionPointWrapperNeeded()) {
                            Expr delegateSupplier = bc.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, (Expr)injectionPointParam);
                            Expr wrap = BeanGenerator.wrapCurrentInjectionPoint(observer.getDeclaringBean(), bc, injectionPoint, (Expr)Const.ofNull(Object.class), delegateSupplier, null, annotationLiterals, reflectionRegistration, this.injectionPointAnnotationsPredicate);
                            supplier = bc.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, wrap);
                        } else {
                            supplier = injectionPointParam;
                        }
                        bc.set((Assignable)cc.this_().field((FieldDesc)injectionPointToProviderField.get(injectionPoint)), (Expr)supplier);
                    }
                }
                bc.set((Assignable)cc.this_().field(observedTypeField), (Expr)RuntimeTypeCreator.of(bc).create(observer.getObservedType()));
                Set<AnnotationInstance> qualifiers = observer.getQualifiers();
                if (!qualifiers.isEmpty()) {
                    LocalVar qualifiersArray = bc.localVar(QUALIFIERS, bc.newEmptyArray(Annotation.class, qualifiers.size()));
                    int i = 0;
                    for (AnnotationInstance qualifier : qualifiers) {
                        BuiltinQualifier builtin = BuiltinQualifier.of(qualifier);
                        if (builtin != null) {
                            bc.set(qualifiersArray.elem(i), (Expr)builtin.getLiteralInstance());
                        } else {
                            ClassInfo qualifierClass = observer.getBeanDeployment().getQualifier(qualifier.name());
                            bc.set(qualifiersArray.elem(i), annotationLiterals.create((BlockCreator)bc, qualifierClass, qualifier));
                        }
                        ++i;
                    }
                    bc.set((Assignable)cc.this_().field(observedQualifiersField), bc.invokeStatic(MethodDescs.SETS_OF, (Expr)qualifiersArray));
                }
                if (mockField != null) {
                    bc.set((Assignable)cc.this_().field(mockField), Const.of((boolean)false));
                }
                bc.return_();
            });
        });
    }

    private void generateGetObservedType(ClassCreator cc, FieldDesc observedTypeField) {
        cc.method("getObservedType", mc -> {
            mc.returning(Type.class);
            mc.body(bc -> bc.return_((Expr)cc.this_().field(observedTypeField)));
        });
    }

    private void generateGetObservedQualifiers(ClassCreator cc, FieldDesc observedQualifiersField) {
        cc.method("getObservedQualifiers", mc -> {
            mc.returning(Set.class);
            mc.body(bc -> bc.return_((Expr)cc.this_().field(observedQualifiersField)));
        });
    }

    private void generateGetBeanClass(ClassCreator cc, DotName beanClass) {
        cc.method("getBeanClass", mc -> {
            mc.returning(Class.class);
            mc.body(bc -> bc.return_((Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)beanClass))));
        });
    }

    private void generateGetTransactionPhase(ClassCreator cc, ObserverInfo observer) {
        cc.method("getTransactionPhase", mc -> {
            mc.returning(TransactionPhase.class);
            mc.body(bc -> bc.return_((Expr)Const.of((Constable)observer.getTransactionPhase())));
        });
    }

    private void generateGetReceptionIfExists(ClassCreator cc) {
        cc.method("getReception", mc -> {
            mc.returning(Reception.class);
            mc.body(bc -> bc.return_((Expr)Const.of((Constable)Reception.IF_EXISTS)));
        });
    }

    private void generateGetPriority(ClassCreator cc, ObserverInfo observer) {
        cc.method("getPriority", mc -> {
            mc.returning(Integer.TYPE);
            mc.body(bc -> bc.return_((Expr)Const.of((int)observer.getPriority())));
        });
    }

    private void generateIsAsync(ClassCreator cc) {
        cc.method("isAsync", mc -> {
            mc.returning(Boolean.TYPE);
            mc.body(bc -> bc.return_((Expr)Const.of((boolean)true)));
        });
    }

    private void generateGetDeclaringBeanIdentifier(ClassCreator cc, BeanInfo declaringBean) {
        cc.method("getDeclaringBeanIdentifier", mc -> {
            mc.returning(String.class);
            mc.body(bc -> bc.return_((Expr)(declaringBean != null ? Const.of((String)declaringBean.getIdentifier()) : Const.ofNull(String.class))));
        });
    }

    private void generateMockMethods(ClassCreator cc, FieldDesc mockField) {
        cc.method("arc$clearMock", mc -> {
            mc.returning(Void.TYPE);
            mc.body(bc -> {
                bc.set((Assignable)cc.this_().field(mockField), Const.of((boolean)false));
                bc.return_();
            });
        });
        cc.method("arc$setMock", mc -> {
            mc.returning(Void.TYPE);
            ParamVar mock = mc.parameter("ignored", Object.class);
            mc.body(bc -> {
                bc.set((Assignable)cc.this_().field(mockField), Const.of((boolean)true));
                bc.return_();
            });
        });
    }

    private void generateToString(ClassCreator cc, ObserverInfo observer) {
        cc.method("toString", mc -> {
            mc.returning(String.class);
            mc.body(bc -> {
                StringBuilder result = new StringBuilder();
                if (observer.isSynthetic()) {
                    result.append("Synthetic observer [");
                    if (observer.getUserId() != null) {
                        result.append("id=").append(observer.getUserId());
                    } else {
                        result.append("beanClass=").append(observer.getBeanClass());
                    }
                    result.append("]");
                } else {
                    result.append("Observer [method=").append(observer.getObserverMethod().declaringClass().name()).append("#").append(observer.getObserverMethod().name()).append("(").append(observer.getObserverMethod().parameterTypes().stream().map(Object::toString).collect(Collectors.joining(", "))).append(")]");
                }
                bc.return_((Expr)Const.of((String)result.toString()));
            });
        });
    }

    private void generateNotify(final ClassCreator cc, ObserverInfo observer, Map<InjectionPointInfo, FieldDesc> injectionPointToProviderField, ReflectionRegistration reflectionRegistration, boolean isApplicationClass, FieldDesc declaringProviderField, FieldDesc mockField) {
        cc.method("notify", mc -> {
            mc.returning(Void.TYPE);
            final ParamVar eventContext = mc.parameter("eventContext", EventContext.class);
            mc.body(b0 -> {
                LocalVar declaringProviderCtx;
                LocalVar declaringProviderInstance;
                LocalVar declaringProvider;
                LocalVar ctx;
                if (mockField != null) {
                    b0.if_((Expr)cc.this_().field(mockField), BlockCreator::return_);
                }
                if (observer.isSynthetic()) {
                    observer.getNotify().accept(new ObserverConfigurator.NotifyGeneration(){
                        final /* synthetic */ BlockCreator val$b0;
                        {
                            this.val$b0 = blockCreator;
                        }

                        @Override
                        public ClassCreator observerClass() {
                            return cc;
                        }

                        public ParamVar eventContext() {
                            return eventContext;
                        }

                        @Override
                        public BlockCreator notifyMethod() {
                            return this.val$b0;
                        }
                    });
                    return;
                }
                boolean isStatic = Modifier.isStatic(observer.getObserverMethod().flags());
                boolean hasDependencies = !observer.getInjection().injectionPoints.isEmpty();
                LocalVar localVar = ctx = hasDependencies ? b0.localVar("ctx", b0.new_(ConstructorDesc.of(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), (Expr)Const.ofNull(Contextual.class))) : null;
                if (!isStatic) {
                    declaringProvider = b0.localVar("declaringProvider", b0.cast(b0.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)cc.this_().field(declaringProviderField)), Contextual.class));
                    if (observer.getReception() == Reception.IF_EXISTS && !BuiltinScope.DEPENDENT.is(observer.getDeclaringBean().getScope())) {
                        context = b0.localVar("context", b0.invokeInterface(MethodDescs.ARC_CONTAINER_GET_ACTIVE_CONTEXT, b0.invokeStatic(MethodDescs.ARC_REQUIRE_CONTAINER), (Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)observer.getDeclaringBean().getScope().getDotName()))));
                        b0.ifNull((Expr)context, BlockCreator::return_);
                        declaringProviderInstance = b0.localVar("declaringProviderInstance", b0.invokeInterface(MethodDescs.CONTEXT_GET_IF_PRESENT, (Expr)context, (Expr)declaringProvider));
                        b0.ifNull((Expr)declaringProviderInstance, BlockCreator::return_);
                        declaringProviderCtx = null;
                    } else if (BuiltinScope.DEPENDENT.is(observer.getDeclaringBean().getScope())) {
                        declaringProviderCtx = b0.localVar("declaringProviderCtx", b0.new_(ConstructorDesc.of(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), (Expr)declaringProvider));
                        declaringProviderInstance = b0.localVar("declaringProviderInstance", b0.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)declaringProvider, (Expr)declaringProviderCtx));
                    } else {
                        context = b0.localVar("context", b0.invokeInterface(MethodDescs.ARC_CONTAINER_GET_ACTIVE_CONTEXT, b0.invokeStatic(MethodDescs.ARC_REQUIRE_CONTAINER), (Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)observer.getDeclaringBean().getScope().getDotName()))));
                        b0.ifNull((Expr)context, BlockCreator::return_);
                        declaringProviderInstance = b0.localVar("declaringProviderInstance", b0.invokeInterface(MethodDescs.CONTEXT_GET_IF_PRESENT, (Expr)context, (Expr)declaringProvider));
                        b0.ifNull((Expr)declaringProviderInstance, b1 -> b1.set((Assignable)declaringProviderInstance, b1.invokeInterface(MethodDescs.CONTEXT_GET, (Expr)context, (Expr)declaringProvider, b1.new_(ConstructorDesc.of(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), (Expr)declaringProvider))));
                        declaringProviderCtx = null;
                    }
                } else {
                    declaringProvider = null;
                    declaringProviderInstance = null;
                    declaringProviderCtx = null;
                }
                LocalVar[] args = new LocalVar[observer.getObserverMethod().parametersCount()];
                Iterator<InjectionPointInfo> injectionPointsIterator = observer.getInjection().injectionPoints.iterator();
                for (int i = 0; i < observer.getObserverMethod().parametersCount(); ++i) {
                    if (i == observer.getEventParameter().position()) {
                        Expr eventObject = b0.invokeInterface(MethodDescs.EVENT_CONTEXT_GET_EVENT, (Expr)eventContext);
                        args[i] = b0.localVar("arg" + i, eventObject);
                        continue;
                    }
                    if (i == observer.getEventMetadataParameterPosition()) {
                        args[i] = b0.localVar("arg" + i, b0.invokeInterface(MethodDescs.EVENT_CONTEXT_GET_METADATA, (Expr)eventContext));
                        continue;
                    }
                    InjectionPointInfo injectionPoint = injectionPointsIterator.next();
                    Expr provider = b0.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)cc.this_().field((FieldDesc)injectionPointToProviderField.get(injectionPoint)));
                    Expr childCtx = b0.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD, (Expr)ctx);
                    Expr dependency = b0.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, provider, childCtx);
                    LocalVar arg = b0.localVar("arg" + i, dependency);
                    BeanGenerator.checkPrimitiveInjection(b0, injectionPoint, arg);
                    args[i] = arg;
                }
                if (Modifier.isPrivate(observer.getObserverMethod().flags())) {
                    this.privateMembers.add(isApplicationClass, String.format("Observer method %s#%s()", observer.getObserverMethod().declaringClass().name(), observer.getObserverMethod().name()));
                    reflectionRegistration.registerMethod(observer.getObserverMethod());
                    LocalVar paramsArray = b0.localVar("paramTypes", b0.newEmptyArray(Class.class, args.length));
                    LocalVar argsArray = b0.localVar("args", b0.newEmptyArray(Object.class, args.length));
                    for (int i = 0; i < args.length; ++i) {
                        b0.set(paramsArray.elem(i), Const.of((ClassDesc)Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)observer.getObserverMethod().parameterType(i))));
                        b0.set(argsArray.elem(i), (Expr)args[i]);
                    }
                    b0.invokeStatic(MethodDescs.REFLECTIONS_INVOKE_METHOD, new Expr[]{Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)observer.getObserverMethod().declaringClass())), Const.of((String)observer.getObserverMethod().name()), paramsArray, declaringProviderInstance, argsArray});
                } else if (isStatic) {
                    b0.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)observer.getObserverMethod()), (Expr[])args);
                } else {
                    b0.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)observer.getObserverMethod()), declaringProviderInstance, (Expr[])args);
                }
                if (hasDependencies) {
                    b0.invokeInterface(MethodDescs.CREATIONAL_CTX_RELEASE, (Expr)ctx);
                }
                if (!isStatic && BuiltinScope.DEPENDENT.is(observer.getDeclaringBean().getScope())) {
                    b0.invokeInterface(MethodDescs.INJECTABLE_BEAN_DESTROY, (Expr)declaringProvider, (Expr)declaringProviderInstance, (Expr)declaringProviderCtx);
                }
                b0.return_();
            });
        });
    }
}

