/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.All;
import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.NoClassInterceptors;
import io.quarkus.arc.Unremovable;
import io.quarkus.arc.VetoedProducer;
import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.impl.Identified;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.control.ActivateRequestContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.ObservesAsync;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Stereotype;
import jakarta.enterprise.inject.TransientReference;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanContainer;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.util.Nonbinding;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InterceptorBinding;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletionStage;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class DotNames {
    private static final ComputingCache<String, DotName> NAMES = new ComputingCache(DotNames::create);
    public static final DotName OBJECT = DotNames.create(Object.class);
    public static final DotName OBSERVES = DotNames.create(Observes.class);
    public static final DotName OBSERVES_ASYNC = DotNames.create(ObservesAsync.class);
    public static final DotName PRODUCES = DotNames.create(Produces.class);
    public static final DotName DISPOSES = DotNames.create(Disposes.class);
    public static final DotName QUALIFIER = DotNames.create(Qualifier.class);
    public static final DotName REPEATABLE = DotNames.create(Repeatable.class);
    public static final DotName INHERITED = DotNames.create(Inherited.class);
    public static final DotName NONBINDING = DotNames.create(Nonbinding.class);
    public static final DotName INJECT = DotNames.create(Inject.class);
    public static final DotName POST_CONSTRUCT = DotNames.create(PostConstruct.class);
    public static final DotName PRE_DESTROY = DotNames.create(PreDestroy.class);
    public static final DotName INSTANCE = DotNames.create(Instance.class);
    public static final DotName INJECTABLE_INSTANCE = DotNames.create(InjectableInstance.class);
    public static final DotName PROVIDER = DotNames.create(Provider.class);
    public static final DotName INJECTION_POINT = DotNames.create(InjectionPoint.class);
    public static final DotName INTERCEPTOR = DotNames.create(Interceptor.class);
    public static final DotName INTERCEPTOR_BEAN = DotNames.create(jakarta.enterprise.inject.spi.Interceptor.class);
    public static final DotName INTERCEPTOR_BINDING = DotNames.create(InterceptorBinding.class);
    public static final DotName INTERCEPTED = DotNames.create(Intercepted.class);
    public static final DotName AROUND_INVOKE = DotNames.create(AroundInvoke.class);
    public static final DotName AROUND_CONSTRUCT = DotNames.create(AroundConstruct.class);
    public static final DotName PRIORITY = DotNames.create(Priority.class);
    public static final DotName DEFAULT = DotNames.create(Default.class);
    public static final DotName ANY = DotNames.create(Any.class);
    public static final DotName BEAN = DotNames.create(Bean.class);
    public static final DotName INJECTABLE_BEAN = DotNames.create(InjectableBean.class);
    public static final DotName BEAN_CONTAINER = DotNames.create(BeanContainer.class);
    public static final DotName BEAN_MANAGER = DotNames.create(BeanManager.class);
    public static final DotName EVENT = DotNames.create(Event.class);
    public static final DotName EVENT_METADATA = DotNames.create(EventMetadata.class);
    public static final DotName ALTERNATIVE = DotNames.create(Alternative.class);
    public static final DotName DEFAULT_BEAN = DotNames.create(DefaultBean.class);
    public static final DotName SCOPE = DotNames.create(Scope.class);
    public static final DotName NORMAL_SCOPE = DotNames.create(NormalScope.class);
    public static final DotName SINGLETON = DotNames.create(Singleton.class);
    public static final DotName APPLICATION_SCOPED = DotNames.create(ApplicationScoped.class);
    public static final DotName STEREOTYPE = DotNames.create(Stereotype.class);
    public static final DotName TYPED = DotNames.create(Typed.class);
    public static final DotName VETOED = DotNames.create(Vetoed.class);
    public static final DotName CLASS = DotNames.create(Class.class);
    public static final DotName ENUM = DotNames.create(Enum.class);
    public static final DotName EXTENSION = DotNames.create(Extension.class);
    public static final DotName BUILD_COMPATIBLE_EXTENSION = DotNames.create(BuildCompatibleExtension.class);
    public static final DotName OPTIONAL = DotNames.create(Optional.class);
    public static final DotName OPTIONAL_INT = DotNames.create(OptionalInt.class);
    public static final DotName OPTIONAL_LONG = DotNames.create(OptionalLong.class);
    public static final DotName OPTIONAL_DOUBLE = DotNames.create(OptionalDouble.class);
    public static final DotName NAMED = DotNames.create(Named.class);
    public static final DotName ACTIVATE_REQUEST_CONTEXT = DotNames.create(ActivateRequestContext.class);
    public static final DotName TRANSACTION_PHASE = DotNames.create(TransactionPhase.class);
    public static final DotName INITIALIZED = DotNames.create(Initialized.class);
    public static final DotName TRANSIENT_REFERENCE = DotNames.create(TransientReference.class);
    public static final DotName INVOCATION_CONTEXT = DotNames.create(InvocationContext.class);
    public static final DotName ARC_INVOCATION_CONTEXT = DotNames.create(ArcInvocationContext.class);
    public static final DotName DECORATOR = DotNames.create(Decorator.class);
    public static final DotName DELEGATE = DotNames.create(Delegate.class);
    public static final DotName SERIALIZABLE = DotNames.create(Serializable.class);
    public static final DotName UNREMOVABLE = DotNames.create(Unremovable.class);
    public static final DotName VETOED_PRODUCER = DotNames.create(VetoedProducer.class);
    public static final DotName LIST = DotNames.create(List.class);
    public static final DotName ALL = DotNames.create(All.class);
    public static final DotName IDENTIFIED = DotNames.create(Identified.class);
    public static final DotName INSTANCE_HANDLE = DotNames.create(InstanceHandle.class);
    public static final DotName NO_CLASS_INTERCEPTORS = DotNames.create(NoClassInterceptors.class);
    public static final DotName DEPRECATED = DotNames.create(Deprecated.class);
    @Deprecated(forRemoval=true, since="3.0")
    public static final DotName KOTLIN_METADATA_ANNOTATION = DotNames.create("kotlin.Metadata");
    public static final DotName BOOLEAN = DotNames.create(Boolean.class);
    public static final DotName BYTE = DotNames.create(Byte.class);
    public static final DotName CHARACTER = DotNames.create(Character.class);
    public static final DotName DOUBLE = DotNames.create(Double.class);
    public static final DotName FLOAT = DotNames.create(Float.class);
    public static final DotName INTEGER = DotNames.create(Integer.class);
    public static final DotName LONG = DotNames.create(Long.class);
    public static final DotName SHORT = DotNames.create(Short.class);
    public static final DotName STRING = DotNames.create(String.class);
    public static final DotName COMPLETION_STAGE = DotNames.create(CompletionStage.class);
    public static final DotName UNI = DotNames.create(Uni.class);
    public static final DotName MULTI = DotNames.create(Multi.class);

    private DotNames() {
    }

    static DotName create(Class<?> clazz) {
        return DotNames.create(clazz.getName());
    }

    static DotName create(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return DotName.createComponentized(null, (String)name);
        }
        String prefix = name.substring(0, lastDot);
        DotName prefixName = (DotName)NAMES.getValue((Object)prefix);
        String local = name.substring(lastDot + 1);
        return DotName.createComponentized((DotName)prefixName, (String)local);
    }

    public static String simpleName(ClassInfo clazz) {
        switch (clazz.nestingType()) {
            case TOP_LEVEL: {
                return DotNames.simpleName(clazz.name());
            }
            case INNER: {
                return clazz.simpleName();
            }
        }
        throw new IllegalStateException("Unsupported nesting type: " + clazz);
    }

    public static String simpleName(DotName dotName) {
        return DotNames.simpleName(dotName.toString());
    }

    public static String simpleName(String name) {
        return name.contains(".") ? name.substring(name.lastIndexOf(".") + 1, name.length()) : name;
    }

    public static String packageName(DotName dotName) {
        String name = dotName.toString();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index);
    }

    public static String internalPackageNameWithTrailingSlash(DotName dotName) {
        String name = dotName.toString();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index).replace('.', '/') + "/";
    }
}

