/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.providers;

import io.quarkiverse.openapi.generator.AuthConfig;
import io.quarkiverse.openapi.generator.AuthsConfig;
import io.quarkiverse.openapi.generator.OpenApiGeneratorConfig;
import io.quarkiverse.openapi.generator.SpecItemConfig;
import io.quarkiverse.openapi.generator.providers.AbstractAuthenticationPropagationHeadersFactory;
import io.quarkiverse.openapi.generator.providers.AuthProvider;
import io.quarkiverse.openapi.generator.providers.OperationAuthInfo;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractAuthProvider
implements AuthProvider {
    private static final String BEARER_WITH_SPACE = "Bearer ";
    private static final String CANONICAL_AUTH_CONFIG_PROPERTY_NAME = "quarkus.openapi-generator.%s.auth.%s.%s";
    private String openApiSpecId;
    private String name;
    private final OpenApiGeneratorConfig generatorConfig;
    private AuthConfig authConfig;
    private final List<OperationAuthInfo> applyToOperations = new ArrayList<OperationAuthInfo>();

    protected AbstractAuthProvider() {
        this.name = null;
        this.generatorConfig = null;
    }

    protected AbstractAuthProvider(OpenApiGeneratorConfig generatorConfig) {
        this.generatorConfig = generatorConfig;
    }

    protected void init(String name, String openApiSpecId) {
        this.name = name;
        this.setOpenApiSpecId(openApiSpecId);
    }

    private void setOpenApiSpecId(String openApiSpecId) {
        this.openApiSpecId = openApiSpecId;
        Optional<SpecItemConfig> specItemConfig = Objects.requireNonNull(this.generatorConfig, "generatorConfig can't be null.").getItemConfig(openApiSpecId);
        if (specItemConfig.isPresent()) {
            Optional<AuthsConfig> authsConfig = specItemConfig.get().getAuth();
            authsConfig.ifPresent(specItemAuthsConfig -> {
                this.authConfig = specItemAuthsConfig.getItemConfig(this.name).orElse(null);
            });
        }
    }

    public String getOpenApiSpecId() {
        return this.openApiSpecId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OpenApiGeneratorConfig getGeneratorConfig() {
        return this.generatorConfig;
    }

    public boolean isTokenPropagation() {
        return this.authConfig != null && this.authConfig.getTokenPropagation().orElse(false) != false;
    }

    public String getTokenForPropagation(MultivaluedMap<String, Object> httpHeaders) {
        String headerName = this.getHeaderName() != null ? this.getHeaderName() : "Authorization";
        String propagatedHeaderName = AbstractAuthenticationPropagationHeadersFactory.propagationHeaderName(this.getOpenApiSpecId(), this.getName(), headerName);
        return Objects.toString(httpHeaders.getFirst((Object)propagatedHeaderName));
    }

    public String getHeaderName() {
        if (this.authConfig != null) {
            return this.authConfig.getHeaderName().orElse(null);
        }
        return null;
    }

    @Override
    public List<OperationAuthInfo> operationsToFilter() {
        return this.applyToOperations;
    }

    @Override
    public AuthProvider addOperation(OperationAuthInfo operationAuthInfo) {
        this.applyToOperations.add(operationAuthInfo);
        return this;
    }

    public String getAuthConfigParam(String paramName, String defaultValue) {
        if (this.authConfig != null) {
            return this.authConfig.getConfigParam(paramName).orElse(defaultValue);
        }
        return defaultValue;
    }

    protected static String sanitizeBearerToken(String token) {
        if (token != null && token.toLowerCase().startsWith(BEARER_WITH_SPACE.toLowerCase())) {
            return token.substring(BEARER_WITH_SPACE.length());
        }
        return token;
    }

    protected String getCanonicalAuthConfigPropertyName(String authPropertyName) {
        return String.format(CANONICAL_AUTH_CONFIG_PROPERTY_NAME, this.getOpenApiSpecId(), this.getName(), authPropertyName);
    }
}

