/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.providers;

import java.util.regex.Pattern;

public class UrlPatternMatcher {
    private static final String URL_PARAM_REGEX = "\\{(\\w*?)\\}";
    private static final String URL_PARAM_MATCH_REGEX = "\\([%\\\\w-.\\\\~!\\$&'\\\\(\\\\)\\\\*\\\\+,;=:\\\\[\\\\]@]+?\\)";
    private static final String URL_FORMAT_REGEX = "(?:\\.\\{format\\})$";
    private static final String URL_FORMAT_MATCH_REGEX = "(?:\\\\.\\([\\\\w%]+?\\))?";
    private static final String URL_QUERY_STRING_REGEX = "(?:\\?.*?)?$";
    private final String urlPattern;
    private Pattern compiledUrl;

    public UrlPatternMatcher(String pattern) {
        this.urlPattern = pattern;
        String parsedPattern = this.urlPattern.replaceFirst(URL_FORMAT_REGEX, URL_FORMAT_MATCH_REGEX);
        parsedPattern = parsedPattern.replaceAll(URL_PARAM_REGEX, URL_PARAM_MATCH_REGEX);
        this.compiledUrl = Pattern.compile(parsedPattern + URL_QUERY_STRING_REGEX);
    }

    public boolean matches(String url) {
        return this.compiledUrl.matcher(url).matches();
    }
}

