/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.providers;

import io.quarkiverse.openapi.generator.OpenApiGeneratorConfig;
import io.quarkiverse.openapi.generator.providers.AbstractAuthProvider;
import io.quarkus.arc.Priority;
import java.io.IOException;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
@Dependent
public class OAuth2AuthenticationProvider
extends AbstractAuthProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2AuthenticationProvider.class);
    private OidcClientRequestFilterDelegate delegate;

    OAuth2AuthenticationProvider() {
        this.delegate = null;
    }

    @Inject
    public OAuth2AuthenticationProvider(OpenApiGeneratorConfig generatorConfig) {
        super(generatorConfig);
    }

    public void init(String name, String openApiSpecId, OidcClientRequestFilterDelegate delegate) {
        this.delegate = delegate;
        super.init(name, openApiSpecId);
        this.validateConfig();
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.isTokenPropagation()) {
            String bearerToken = this.getTokenForPropagation((MultivaluedMap<String, Object>)requestContext.getHeaders());
            bearerToken = OAuth2AuthenticationProvider.sanitizeBearerToken(bearerToken);
            requestContext.getHeaders().add((Object)"Authorization", (Object)("Bearer " + bearerToken));
        } else {
            this.delegate.filter(requestContext);
        }
    }

    private void validateConfig() {
        if (this.isTokenPropagation()) {
            LOGGER.warn("Token propagation was enabled for a the oauth2: {} securityScheme in the specification file: {}. This configuration can be done by using the property: {} and is not necessary a problem if the configuration is intentional.", new Object[]{this.getName(), this.getOpenApiSpecId(), this.getCanonicalAuthConfigPropertyName("token-propagation")});
        }
    }

    public static interface OidcClientRequestFilterDelegate<T extends ClientRequestContext> {
        public void filter(T var1) throws IOException;
    }
}

