/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.providers;

import io.quarkiverse.openapi.generator.OpenApiGeneratorConfig;
import io.quarkiverse.openapi.generator.providers.AbstractAuthProvider;
import io.quarkiverse.openapi.generator.providers.AbstractCompositeAuthenticationProvider;
import io.quarkiverse.openapi.generator.providers.HeadersProvider;
import java.util.List;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;

public abstract class AbstractAuthenticationPropagationHeadersFactory
implements ClientHeadersFactory {
    private static final String HEADER_NAME_PREFIX_FOR_TOKEN_PROPAGATION = "QCG_%s";
    private static final String HEADER_NAME_FOR_TOKEN_PROPAGATION = "QCG_%s_%s_%s";
    protected AbstractCompositeAuthenticationProvider compositeProvider;
    protected OpenApiGeneratorConfig generatorConfig;
    protected HeadersProvider headersProvider;

    protected AbstractAuthenticationPropagationHeadersFactory(AbstractCompositeAuthenticationProvider compositeProvider, OpenApiGeneratorConfig generatorConfig, HeadersProvider headersProvider) {
        this.compositeProvider = compositeProvider;
        this.generatorConfig = generatorConfig;
        this.headersProvider = headersProvider;
    }

    public MultivaluedMap<String, String> update(MultivaluedMap<String, String> incomingHeaders, MultivaluedMap<String, String> clientOutgoingHeaders) {
        MultivaluedHashMap propagatedHeaders = new MultivaluedHashMap();
        MultivaluedMap<String, String> providedHeaders = this.headersProvider.getStringHeaders(this.generatorConfig);
        this.compositeProvider.getAuthenticationProviders().stream().filter(AbstractAuthProvider.class::isInstance).map(AbstractAuthProvider.class::cast).filter(AbstractAuthProvider::isTokenPropagation).forEach(arg_0 -> AbstractAuthenticationPropagationHeadersFactory.lambda$update$0(providedHeaders, incomingHeaders, (MultivaluedMap)propagatedHeaders, arg_0));
        return propagatedHeaders;
    }

    public static String propagationHeaderName(String openApiSpecId, String authName, String headerName) {
        return String.format(HEADER_NAME_FOR_TOKEN_PROPAGATION, openApiSpecId, authName, headerName);
    }

    public static String propagationHeaderNamePrefix(String openApiSpecId) {
        return String.format(HEADER_NAME_PREFIX_FOR_TOKEN_PROPAGATION, openApiSpecId);
    }

    private static /* synthetic */ void lambda$update$0(MultivaluedMap providedHeaders, MultivaluedMap incomingHeaders, MultivaluedMap propagatedHeaders, AbstractAuthProvider authProvider) {
        String headerName = authProvider.getHeaderName() != null ? authProvider.getHeaderName() : "Authorization";
        List headerValue = (List)providedHeaders.get((Object)headerName);
        if (headerValue == null) {
            headerValue = (List)incomingHeaders.get((Object)headerName);
        }
        if (headerValue != null) {
            propagatedHeaders.put((Object)AbstractAuthenticationPropagationHeadersFactory.propagationHeaderName(authProvider.getOpenApiSpecId(), authProvider.getName(), headerName), (Object)headerValue);
        }
    }
}

