/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.deployment.wrapper;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.languages.JavaClientCodegen;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkusJavaClientCodegen
extends JavaClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuarkusJavaClientCodegen.class);
    public static final String QUARKUS_GENERATOR_NAME = "quarkus-generator";
    private static final String AUTH_PACKAGE = "auth";
    private static final String DEFAULT_SERVER_URL = "defaultServerUrl";

    public QuarkusJavaClientCodegen() {
        this.setSerializationLibrary("jackson");
        this.setTemplateDir("templates");
    }

    public String getName() {
        return "quarkus";
    }

    public void processOpts() {
        super.processOpts();
        this.projectFolder = "";
        this.projectTestFolder = "";
        this.sourceFolder = "";
        this.testFolder = "";
        this.embeddedTemplateDir = "templates";
        this.replaceWithQuarkusTemplateFiles();
    }

    private void replaceWithQuarkusTemplateFiles() {
        this.supportingFiles.clear();
        Boolean enableSecurityGeneration = (Boolean)this.additionalProperties.get("enable-security-generation");
        if (enableSecurityGeneration == null || enableSecurityGeneration.booleanValue()) {
            if (ProcessUtils.hasHttpBasicMethods((OpenAPI)this.openAPI) || ProcessUtils.hasApiKeyMethods((OpenAPI)this.openAPI) || ProcessUtils.hasHttpBearerMethods((OpenAPI)this.openAPI) || ProcessUtils.hasOAuthMethods((OpenAPI)this.openAPI)) {
                this.supportingFiles.add(new SupportingFile("auth/compositeAuthenticationProvider.qute", this.authFileFolder(), "CompositeAuthenticationProvider.java"));
                this.supportingFiles.add(new SupportingFile("auth/headersFactory.qute", this.authFileFolder(), "AuthenticationPropagationHeadersFactory.java"));
            }
        } else {
            LOGGER.info("Generating of security classes is disabled!");
        }
        this.apiTemplateFiles.clear();
        this.apiTemplateFiles.put("api.qute", ".java");
        this.modelTemplateFiles.clear();
        this.modelTemplateFiles.put("model.qute", ".java");
    }

    public String authFileFolder() {
        return this.apiPackage().replace('.', File.separatorChar) + File.separator + AUTH_PACKAGE;
    }

    public static Optional<URL> getServerURL(OpenAPI openAPI, Map<String, String> userDefinedVariables) {
        List servers = openAPI.getServers();
        if (servers == null || servers.isEmpty()) {
            return Optional.empty();
        }
        Server server = (Server)servers.get(0);
        return server.getUrl().equals("/") ? Optional.empty() : Optional.ofNullable(URLPathUtils.getServerURL((Server)server, userDefinedVariables));
    }

    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        QuarkusJavaClientCodegen.getServerURL(this.openAPI, this.serverVariableOverrides()).ifPresent(url -> this.additionalProperties.put(DEFAULT_SERVER_URL, url));
        this.additionalProperties.put("defaultSecurityScheme", GlobalSettings.getProperty((String)"defaultSecurityScheme"));
        this.configureAdditionalPropertiesAsAttribute();
    }

    public void postProcess() {
        boolean verbose = Boolean.parseBoolean(GlobalSettings.getProperty((String)"verbose"));
        if (verbose) {
            super.postProcess();
        }
    }

    public String toEnumVarName(String value, String datatype) {
        if (value.isBlank()) {
            return "EMPTY";
        }
        if (this.getSymbolName(value) != null) {
            return this.getSymbolName(value).toUpperCase(Locale.ROOT);
        }
        String enumVarName = super.toEnumVarName(value, datatype);
        if (enumVarName.startsWith("NUMBER_")) {
            return enumVarName;
        }
        TreeMap<Integer, String> indexesOfSpecialChars = new TreeMap<Integer, String>();
        for (String key : this.specialCharReplacements.keySet()) {
            if (Objects.equals(key, "_")) continue;
            int index = value.indexOf(key);
            while (index != -1) {
                indexesOfSpecialChars.put(index, key);
                index = value.indexOf(key, index + key.length());
            }
        }
        for (String specialChar : indexesOfSpecialChars.values()) {
            enumVarName = enumVarName.replaceFirst("_", (String)this.specialCharReplacements.get(specialChar));
        }
        for (String specialChar : this.specialCharReplacements.values()) {
            if (!enumVarName.contains(specialChar)) continue;
            enumVarName = enumVarName.replace(specialChar, "_" + specialChar + "_");
        }
        enumVarName = enumVarName.replaceAll("^_+|_+$", "");
        enumVarName = enumVarName.replaceFirst("\\d.*", "_".concat(enumVarName));
        return enumVarName.toUpperCase(Locale.ROOT);
    }

    protected String getSymbolName(String input) {
        String symbolName = (String)this.specialCharReplacements.get(input);
        return symbolName != null ? symbolName.concat("_symbol") : null;
    }

    private void configureAdditionalPropertiesAsAttribute() {
        String property = GlobalSettings.getProperty((String)"supportsAdditionalPropertiesWithComposedSchema");
        if (Boolean.parseBoolean(property)) {
            this.supportsAdditionalPropertiesWithComposedSchema = true;
        }
    }
}

