/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openapi.generator.deployment.template;

import io.quarkiverse.openapi.generator.deployment.codegen.OpenApiGeneratorOutputPaths;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.NamespaceResolver;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public class OpenApiNamespaceResolver
implements NamespaceResolver {
    private static final String GENERATE_DEPRECATED_PROP = "generateDeprecated";
    static final OpenApiNamespaceResolver INSTANCE = new OpenApiNamespaceResolver();

    private OpenApiNamespaceResolver() {
    }

    public boolean genDeprecatedModelAttr(String pkg, String classname, HashMap<String, Object> codegenConfig) {
        String key = String.format("%s.%s.%s", pkg, classname, GENERATE_DEPRECATED_PROP);
        return Boolean.parseBoolean(codegenConfig.getOrDefault(key, "true").toString());
    }

    public boolean genDeprecatedApiAttr(String pkg, String classname, HashMap<String, Object> codegenConfig) {
        String key = String.format("%s.%s.%s", pkg, classname, GENERATE_DEPRECATED_PROP);
        return Boolean.parseBoolean(codegenConfig.getOrDefault(key, "true").toString());
    }

    public String parseUri(String uri) {
        return OpenApiGeneratorOutputPaths.getRelativePath(Path.of(uri, new String[0])).toString();
    }

    public CompletionStage<Object> resolve(EvalContext context) {
        try {
            Class[] classArgs = new Class[context.getParams().size()];
            Object[] args = new Object[context.getParams().size()];
            int i = 0;
            for (Expression expr : context.getParams()) {
                args[i] = context.evaluate(expr).toCompletableFuture().get();
                classArgs[i] = args[i].getClass();
                ++i;
            }
            return CompletableFuture.completedFuture(this.getClass().getMethod(context.getName(), classArgs).invoke((Object)this, args));
        }
        catch (InterruptedException | ReflectiveOperationException | ExecutionException ex) {
            return CompletableFuture.failedStage(ex);
        }
    }

    public String getNamespace() {
        return "openapi";
    }
}

