/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import io.qameta.allure.Param;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.util.ResultsUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class ParameterUtils {
    private ParameterUtils() {
        throw new IllegalStateException("do not instance");
    }

    public static List<Parameter> createParameters(Method method, Object ... args) {
        java.lang.reflect.Parameter[] parameters = method.getParameters();
        return IntStream.range(0, parameters.length).mapToObj(i -> {
            java.lang.reflect.Parameter parameter = parameters[i];
            Object value = args[i];
            Param annotation = parameter.getAnnotation(Param.class);
            if (Objects.isNull(annotation)) {
                return ResultsUtils.createParameter(parameter.getName(), value);
            }
            String name = Stream.of(annotation.value(), annotation.name(), parameter.getName()).map(String::trim).filter(s -> s.length() > 0).findFirst().orElseGet(() -> "arg" + i);
            return ResultsUtils.createParameter(name, value, annotation.excluded(), annotation.mode());
        }).collect(Collectors.toList());
    }
}

