/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.internal;

import io.qameta.allure.internal.shadowed.jackson.annotation.JsonInclude;
import io.qameta.allure.internal.shadowed.jackson.core.JsonGenerator;
import io.qameta.allure.internal.shadowed.jackson.databind.MapperFeature;
import io.qameta.allure.internal.shadowed.jackson.databind.ObjectMapper;
import io.qameta.allure.internal.shadowed.jackson.databind.SerializationFeature;
import io.qameta.allure.internal.shadowed.jackson.databind.SerializerProvider;
import io.qameta.allure.internal.shadowed.jackson.databind.module.SimpleModule;
import io.qameta.allure.internal.shadowed.jackson.databind.ser.std.StdSerializer;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.Status;
import java.io.IOException;
import java.util.Locale;

public final class Allure2ModelJackson {
    public static final String INDENT_OUTPUT_PROPERTY_NAME = "allure.results.indentOutput";

    private Allure2ModelJackson() {
        throw new IllegalStateException("Do not instance Allure2ModelJackson");
    }

    public static ObjectMapper createMapper() {
        return new ObjectMapper().configure(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(SerializationFeature.INDENT_OUTPUT, Boolean.getBoolean(INDENT_OUTPUT_PROPERTY_NAME)).registerModule(new SimpleModule().addSerializer(Status.class, new StatusSerializer()).addSerializer(Stage.class, new StageSerializer()).addSerializer(Parameter.Mode.class, new ParameterModeSerializer()));
    }

    private static class StatusSerializer
    extends StdSerializer<Status> {
        protected StatusSerializer() {
            super(Status.class);
        }

        @Override
        public void serialize(Status value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.name().toLowerCase(Locale.ENGLISH));
        }
    }

    private static class StageSerializer
    extends StdSerializer<Stage> {
        protected StageSerializer() {
            super(Stage.class);
        }

        @Override
        public void serialize(Stage value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.name().toLowerCase(Locale.ENGLISH));
        }
    }

    private static class ParameterModeSerializer
    extends StdSerializer<Parameter.Mode> {
        protected ParameterModeSerializer() {
            super(Parameter.Mode.class);
        }

        @Override
        public void serialize(Parameter.Mode value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.name().toLowerCase(Locale.ENGLISH));
        }
    }
}

