/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.ExceptionUtils;
import io.qameta.allure.util.ResultsUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public final class Allure {
    private static final String TXT_EXTENSION = ".txt";
    private static final String TEXT_PLAIN = "text/plain";
    private static AllureLifecycle lifecycle;

    private Allure() {
        throw new IllegalStateException("Do not instance");
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = new AllureLifecycle();
        }
        return lifecycle;
    }

    public static void setLifecycle(AllureLifecycle lifecycle) {
        Allure.lifecycle = lifecycle;
    }

    public static void step(String name) {
        Allure.step(name, Status.PASSED);
    }

    public static void step(String name, Status status) {
        String uuid = UUID.randomUUID().toString();
        Allure.getLifecycle().startStep(uuid, new StepResult().setName(name).setStatus(status));
        Allure.getLifecycle().stopStep(uuid);
    }

    public static void step(String name, ThrowableRunnableVoid runnable) {
        Allure.step(name, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T step(String name, ThrowableRunnable<T> runnable) {
        return (T)Allure.step((StepContext step) -> {
            step.name(name);
            return runnable.run();
        });
    }

    public static void step(ThrowableContextRunnableVoid<StepContext> runnable) {
        Allure.step((StepContext step) -> {
            runnable.run((StepContext)step);
            return null;
        });
    }

    public static void step(String name, ThrowableContextRunnableVoid<StepContext> runnable) {
        Allure.step((StepContext step) -> {
            step.name(name);
            runnable.run((StepContext)step);
            return null;
        });
    }

    public static <T> T step(String name, ThrowableContextRunnable<T, StepContext> runnable) {
        return (T)Allure.step((StepContext step) -> {
            step.name(name);
            return runnable.run((StepContext)step);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T step(ThrowableContextRunnable<T, StepContext> runnable) {
        String uuid = UUID.randomUUID().toString();
        Allure.getLifecycle().startStep(uuid, new StepResult().setName("step"));
        try {
            T result = runnable.run(new DefaultStepContext(uuid));
            Allure.getLifecycle().updateStep(uuid, step -> step.setStatus(Status.PASSED));
            T t = result;
            return t;
        }
        catch (Throwable throwable) {
            Allure.getLifecycle().updateStep(s -> s.setStatus(ResultsUtils.getStatus(throwable).orElse(Status.BROKEN)).setStatusDetails((StatusDetails)ResultsUtils.getStatusDetails(throwable).orElse(null)));
            ExceptionUtils.sneakyThrow(throwable);
            T t = null;
            return t;
        }
        finally {
            Allure.getLifecycle().stopStep(uuid);
        }
    }

    public static void epic(String value) {
        Allure.label("epic", value);
    }

    public static void feature(String value) {
        Allure.label("feature", value);
    }

    public static void story(String value) {
        Allure.label("story", value);
    }

    public static void suite(String value) {
        Allure.label("suite", value);
    }

    public static void label(String name, String value) {
        Label label = new Label().setName(name).setValue(value);
        Allure.getLifecycle().updateTestCase(testResult -> testResult.getLabels().add(label));
    }

    public static <T> T parameter(String name, T value) {
        Parameter parameter = ResultsUtils.createParameter(name, value);
        Allure.getLifecycle().updateTestCase(testResult -> testResult.getParameters().add(parameter));
        return value;
    }

    public static void issue(String name, String url) {
        Allure.link(name, "issue", url);
    }

    public static void tms(String name, String url) {
        Allure.link(name, "tms", url);
    }

    public static void link(String url) {
        Allure.link(null, url);
    }

    public static void link(String name, String url) {
        Allure.link(name, null, url);
    }

    public static void link(String name, String type, String url) {
        Link link = new Link().setName(name).setType(type).setUrl(url);
        Allure.getLifecycle().updateTestCase(testResult -> testResult.getLinks().add(link));
    }

    public static void description(String description) {
        Allure.getLifecycle().updateTestCase(executable -> executable.setDescription(description));
    }

    public static void descriptionHtml(String descriptionHtml) {
        Allure.getLifecycle().updateTestCase(executable -> executable.setDescriptionHtml(descriptionHtml));
    }

    public static void attachment(String name, String content) {
        Allure.addAttachment(name, content);
    }

    public static void attachment(String name, InputStream content) {
        Allure.addAttachment(name, content);
    }

    @Deprecated
    public static void addLabels(Label ... labels) {
        Allure.getLifecycle().updateTestCase(testResult -> testResult.getLabels().addAll(Arrays.asList(labels)));
    }

    @Deprecated
    public static void addLinks(Link ... links) {
        Allure.getLifecycle().updateTestCase(testResult -> testResult.getLinks().addAll(Arrays.asList(links)));
    }

    @Deprecated
    public static void addDescription(String description) {
        Allure.description(description);
    }

    @Deprecated
    public static void addDescriptionHtml(String descriptionHtml) {
        Allure.descriptionHtml(descriptionHtml);
    }

    public static void addAttachment(String name, String content) {
        Allure.getLifecycle().addAttachment(name, TEXT_PLAIN, TXT_EXTENSION, content.getBytes(StandardCharsets.UTF_8));
    }

    public static void addAttachment(String name, String type, String content) {
        Allure.getLifecycle().addAttachment(name, type, TXT_EXTENSION, content.getBytes(StandardCharsets.UTF_8));
    }

    public static void addAttachment(String name, String type, String content, String fileExtension) {
        Allure.getLifecycle().addAttachment(name, type, fileExtension, content.getBytes(StandardCharsets.UTF_8));
    }

    public static void addAttachment(String name, InputStream content) {
        Allure.getLifecycle().addAttachment(name, null, null, content);
    }

    public static void addAttachment(String name, String type, InputStream content, String fileExtension) {
        Allure.getLifecycle().addAttachment(name, type, fileExtension, content);
    }

    public static CompletableFuture<byte[]> addByteAttachmentAsync(String name, String type, Supplier<byte[]> body) {
        return Allure.addByteAttachmentAsync(name, type, "", body);
    }

    public static CompletableFuture<byte[]> addByteAttachmentAsync(String name, String type, String fileExtension, Supplier<byte[]> body) {
        String source = Allure.getLifecycle().prepareAttachment(name, type, fileExtension);
        return CompletableFuture.supplyAsync(body).whenComplete((result, ex) -> Allure.getLifecycle().writeAttachment(source, new ByteArrayInputStream((byte[])result)));
    }

    public static CompletableFuture<InputStream> addStreamAttachmentAsync(String name, String type, Supplier<InputStream> body) {
        return Allure.addStreamAttachmentAsync(name, type, "", body);
    }

    public static CompletableFuture<InputStream> addStreamAttachmentAsync(String name, String type, String fileExtension, Supplier<InputStream> body) {
        String source = lifecycle.prepareAttachment(name, type, fileExtension);
        return CompletableFuture.supplyAsync(body).whenComplete((result, ex) -> lifecycle.writeAttachment(source, (InputStream)result));
    }

    private static final class DefaultStepContext
    implements StepContext {
        private final String uuid;

        private DefaultStepContext(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public void name(String name) {
            Allure.getLifecycle().updateStep(this.uuid, stepResult -> stepResult.setName(name));
        }

        @Override
        public <T> T parameter(String name, T value) {
            Parameter param = ResultsUtils.createParameter(name, value);
            Allure.getLifecycle().updateStep(this.uuid, stepResult -> stepResult.getParameters().add(param));
            return value;
        }
    }

    public static interface StepContext {
        public void name(String var1);

        public <T> T parameter(String var1, T var2);
    }

    @FunctionalInterface
    public static interface ThrowableContextRunnableVoid<T> {
        public void run(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowableContextRunnable<T, U> {
        public T run(U var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowableRunnableVoid {
        public void run() throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowableRunnable<T> {
        public T run() throws Throwable;
    }
}

