/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesUtils.class);
    private static final String ALLURE_PROPERTIES_FILE = "allure.properties";

    private PropertiesUtils() {
    }

    public static Properties loadAllureProperties() {
        Properties properties = new Properties();
        PropertiesUtils.loadPropertiesFrom(ClassLoader.getSystemClassLoader(), properties);
        PropertiesUtils.loadPropertiesFrom(Thread.currentThread().getContextClassLoader(), properties);
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    private static void loadPropertiesFrom(ClassLoader classLoader, Properties properties) {
        if (classLoader.getResource(ALLURE_PROPERTIES_FILE) != null) {
            try (InputStream stream = classLoader.getResourceAsStream(ALLURE_PROPERTIES_FILE);){
                properties.load(stream);
            }
            catch (IOException e) {
                LOGGER.error("Error while reading allure.properties file from classpath: %s", (Object)e.getMessage());
            }
        }
    }
}

