/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import io.qameta.allure.Issue;
import io.qameta.allure.LabelAnnotation;
import io.qameta.allure.Link;
import io.qameta.allure.TmsLink;
import io.qameta.allure.model.Label;
import io.qameta.allure.util.ResultsUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationUtils.class);
    private static final String VALUE_METHOD_NAME = "value";

    private AnnotationUtils() {
        throw new IllegalStateException("Do not instance");
    }

    public static List<io.qameta.allure.model.Link> getLinks(AnnotatedElement annotatedElement) {
        ArrayList<io.qameta.allure.model.Link> result = new ArrayList<io.qameta.allure.model.Link>();
        result.addAll(AnnotationUtils.extractLinks(annotatedElement, Link.class, ResultsUtils::createLink));
        result.addAll(AnnotationUtils.extractLinks(annotatedElement, Issue.class, ResultsUtils::createLink));
        result.addAll(AnnotationUtils.extractLinks(annotatedElement, TmsLink.class, ResultsUtils::createLink));
        return result;
    }

    public static List<io.qameta.allure.model.Link> getLinks(Annotation ... annotations) {
        return AnnotationUtils.getLinks(Arrays.asList(annotations));
    }

    public static List<io.qameta.allure.model.Link> getLinks(Collection<Annotation> annotations) {
        ArrayList<io.qameta.allure.model.Link> result = new ArrayList<io.qameta.allure.model.Link>();
        result.addAll(AnnotationUtils.extractLinks(annotations, Link.class, ResultsUtils::createLink));
        result.addAll(AnnotationUtils.extractLinks(annotations, Issue.class, ResultsUtils::createLink));
        result.addAll(AnnotationUtils.extractLinks(annotations, TmsLink.class, ResultsUtils::createLink));
        return result;
    }

    public static Set<Label> getLabels(AnnotatedElement annotatedElement) {
        return AnnotationUtils.getLabels(annotatedElement.getDeclaredAnnotations());
    }

    public static Set<Label> getLabels(Annotation ... annotations) {
        return AnnotationUtils.getLabels(Arrays.asList(annotations));
    }

    public static Set<Label> getLabels(Collection<Annotation> annotations) {
        return annotations.stream().flatMap(AnnotationUtils::extractRepeatable).map(AnnotationUtils::getMarks).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static <T extends Annotation> Set<io.qameta.allure.model.Link> extractLinks(AnnotatedElement element, Class<T> annotationType, Function<T, io.qameta.allure.model.Link> mapper) {
        return Stream.of(element.getAnnotationsByType(annotationType)).map(mapper).collect(Collectors.toSet());
    }

    private static <T extends Annotation> Set<io.qameta.allure.model.Link> extractLinks(Collection<Annotation> annotations, Class<T> annotationType, Function<T, io.qameta.allure.model.Link> mapper) {
        return annotations.stream().flatMap(AnnotationUtils::extractRepeatable).filter(annotation -> annotationType.isAssignableFrom(annotation.annotationType())).map(annotation -> annotation).map(mapper).collect(Collectors.toSet());
    }

    private static Set<Label> getMarks(Annotation annotation) {
        return Stream.of(annotation.annotationType().getAnnotationsByType(LabelAnnotation.class)).map(marker -> AnnotationUtils.getLabel(annotation, marker)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<Label> getLabel(Annotation annotation, LabelAnnotation m) {
        if (Objects.equals(m.value(), "$$$$$$$$__value__$$$$$$$$")) {
            try {
                Method method = annotation.annotationType().getMethod(VALUE_METHOD_NAME, new Class[0]);
                Object object = method.invoke((Object)annotation, new Object[0]);
                return AnnotationUtils.objectToStringStream(object).map(value -> new Label().setName(m.name()).setValue(value)).collect(Collectors.toSet());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Invalid annotation {}: marker annotations without value should contains value() method", (Object)annotation);
                return Collections.emptySet();
            }
        }
        return Collections.singleton(new Label().setName(m.name()).setValue(m.value()));
    }

    private static Stream<String> objectToStringStream(Object object) {
        if (Objects.nonNull(object) && object.getClass().isArray()) {
            if (object instanceof Object[]) {
                return Stream.of((Object[])object).map(Objects::toString);
            }
            if (object instanceof long[]) {
                return Stream.of((long[])object).map(Objects::toString);
            }
            if (object instanceof short[]) {
                return Stream.of((short[])object).map(Objects::toString);
            }
            if (object instanceof int[]) {
                return Stream.of((int[])object).map(Objects::toString);
            }
            if (object instanceof char[]) {
                return Stream.of((char[])object).map(Objects::toString);
            }
            if (object instanceof double[]) {
                return Stream.of((double[])object).map(Objects::toString);
            }
            if (object instanceof float[]) {
                return Stream.of((float[])object).map(Objects::toString);
            }
            if (object instanceof boolean[]) {
                return Stream.of((boolean[])object).map(Objects::toString);
            }
            if (object instanceof byte[]) {
                return Stream.of((byte[])object).map(Objects::toString);
            }
        }
        return Stream.of(Objects.toString(object));
    }

    private static Stream<Annotation> extractRepeatable(Annotation annotation) {
        if (AnnotationUtils.isRepeatableWrapper(annotation)) {
            try {
                Method method = annotation.annotationType().getMethod(VALUE_METHOD_NAME, new Class[0]);
                return Stream.of((Annotation[])method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Could not extract repeatable annotation {}", (Object)annotation);
                return Stream.empty();
            }
        }
        return Stream.of(annotation);
    }

    private static boolean isRepeatableWrapper(Annotation annotation) {
        return Stream.of(annotation.annotationType().getDeclaredMethods()).filter(method -> VALUE_METHOD_NAME.equalsIgnoreCase(method.getName())).filter(method -> method.getReturnType().isArray()).anyMatch(method -> AnnotationUtils.isRepeatable(method.getReturnType().getComponentType()));
    }

    private static boolean isRepeatable(Class<?> annotationType) {
        return annotationType.isAnnotationPresent(Repeatable.class);
    }
}

